/* global _homeUrl, _baseURL, URL_SERVER */

const IMG = 1;
const PDF = 2;
const DOC = 3;
const XLS = 4;

var p = 0;
var Src = [];
var modalDocumentoIsOpen = false;

$(document).ready( () => {
   $('#view-imagen').on('shown.bs.modal', () => {
       modalDocumentoIsOpen = true;
   });
   
   $('#view-imagen').on('hidden.bs.modal', () => {
       modalDocumentoIsOpen = false;
   }); 
   
    document.addEventListener('keyup', (e) => {
        const pasoTecla = e.keyCode-0;
        if( modalDocumentoIsOpen && ( pasoTecla===37 || pasoTecla===39 ) ) {
            const indice = obtenerPunteroNavegacionImagen(pasoTecla);
            const { id, src, title, srcName, tipo, _nombre_ } = Src[indice];
            mostrarImagen( src, title, id, tipo, srcName, _nombre_,toggle=false,changeSrc=true);
        }
    });
   
});

const miniaturaImgCard = ( { tipo, urlDocumento} ) => {
    if ( tipo === XLS ) {
        return _homeUrl + 'img/excel-olivia.jpg';
    } else if ( tipo === PDF) {
        return _homeUrl + 'img/pdf-olivia.jpg';
    } else if ( tipo === DOC ) {
        return _homeUrl + 'img/word-olivia.jpg';
    }  else {
        return urlDocumento;
    }
};  

/**
 * Obtener los documentos por fecha proveninentes del historial del paciente
 * @author Guillermo Rodriguez <alvaradog.antonio600@gmail.com>
 * @param {array} documentosHis - Array de objetos de documentos del paciente
 */
function documentosPacienteHistorial(documentosHis){
    $('#sec-documentos').hide();  
    $('#sec-documentos').children().remove();
    $('#sec-documentos-scroll').hide();  
    if( documentosHis.length > 0){
        let documentos = '';
        $('#docs-vacio-msg').hide();
        $.each( documentosHis, (i,documento)=>{
            documentos += '<div id="miniatura-'+documento.id+'" class="col-md-4 card mt-2">\n\
                <img src="'+miniaturaImgCard( documento )+'" \n\
                    class="prev-image img-cita" alt="..." \n\
                    data-id="'+documento.id+'" \n\
                    data-descripcion="'+documento.descripcion+'" \n\
                    data-tipo="'+documento.tipo+'" \n\
                    data-srcname="'+documento.urlDocumento+'" \n\
                    data-nombre="'+documento._nombre_+'"> \n\
                    <div class="card-body">\n\
                        <p class="" id="descripcion-'+documento.id+'">'+documento.descripcion+'</p>\n\
                </div>\n\
            </div>';
        });
        $('#sec-documentos').append( documentos );
        $('#sec-documentos-scroll').show();
        $('#sec-documentos').show();
        initSrcImagenes();
    } else {
        $('#docs-vacio-msg').show();
    }
}

function initSrcImagenes(){
    const imgs = $(".img-cita");
    Src = [];
    Array.prototype.map.call(imgs, img => {
        Src.push({
            'id':img.dataset.id ,
            'src':img.src,
            '_nombre_': img.dataset.nombre,
            'title':img.dataset.descripcion, 
            'tipo':img.dataset.tipo, 
            'srcName':img.dataset.srcname
        });
    });
    clickImagen();
    guardarDescripcion();
    navegacionImagen();
    //accionesImagen();
}

function clickImagen(){
    $(".img-cita").unbind();
    $(".img-cita").click(function(e){
        const { src, dataset:{ descripcion, id, tipo, srcname, nombre } } = e.target;
        accionesDeTitulo();
        mostrarImagen( src, descripcion, id, tipo, srcname, nombre, toggle=true );
    });
}

function accionesDeTitulo(){
    $(".edit-title").hide();
    $(".title").show();
}

$("#edit-title").click(function(){
    $(".edit-title").show();
    $(".title").hide();
});

$("#close-edit").click(function(){
    $(".edit-title").hide();
    $(".title").show();
});

$('#eliminar-adjunto').click( () => {
    const id = $("#img-view")[0].dataset.id;
    const bool = confirm('Esta seguro de eliminar este elemento');
    if( bool ){
        $.post(_baseURL + '/documento-paciente/delete',{'id':id},function(json){
            if(json.Correcto){            
                $('#view-imagen').modal('hide');
                $('#miniatura-' + id).remove();
                revisarSeccionDocumentos();
                //window.location.reload();
            }
        },'json');
    }
});

function revisarSeccionDocumentos(){
    const DOCS_MINS = $('#sec-documentos').children().length;
    if( DOCS_MINS === 0){
        $('#sec-documentos-scroll').hide();
        $('#docs-vacio-msg').show();
    } else{
        $('#sec-documentos-scroll').show();
        $('#docs-vacio-msg').hide();
    }
}

function navegacionImagen(){
    $('.navigation-btn').unbind();
    $('.navigation-btn').click(function(e){
        const paso = e.target.id;
        const indice = obtenerPunteroNavegacionImagen(paso);
        const { id, src, title, srcName, tipo, _nombre_ } = Src[indice];
        mostrarImagen( src, title, id, tipo, srcName, _nombre_,toggle=false,changeSrc=true);
    });
}

/**
 * Obtener el indice de navegación dentro del arreglo de objetos de imagenes
 * @param {string}|{number} paso identificador de hacia donde se debe mover el indice dentro del arreglo
 * @return {number} p como el nuevo indice   
 */        
function obtenerPunteroNavegacionImagen(paso){
        const srcLong =  Src.length;
        if( ( typeof paso  === 'string' && paso === 'next') || ( typeof paso  === 'number' && paso === 39 ) ){
            p = p + 1 ;
            if( p >= srcLong ){
                p = 0;
            }	
        } else if( ( typeof paso  === 'string' && paso === 'prev' ) || ( typeof paso  === 'number' && paso === 37 ) ) {
            p = p - 1;
            if( p < 0 ){
                p = srcLong-1;
            }
        }
        return p;
}


function guardarDescripcion(){
    $("#guardar").unbind();
    $("#guardar").click(function(){
        var img = $("#img-view");
        var title = $("#descripcion").val();
        var id = img[0].dataset.id;
        $.ajax({
            url: _baseURL + '/documento-paciente/actualizar-descripcion',
            method: 'POST',
            data: {'id': id, 'title': title},
            dataType: 'json',
            success: (response) => {
                if(response.Correcto){
                    const { src, descripcion, id, tipo, srcname, _nombre_ } = response.documento;
                    const changeSrc = tipo !== '1' ? false : true;
                    $('.edit-title').hide();
                    $('.title').show();
                    $('#descripcion-' + id).html( descripcion );
                    mostrarImagen( src, descripcion, id, tipo, srcname, _nombre_, false, changeSrc );	
                }
            }
        });
    });
}


function mostrarImagen(src,descripcion,id,tipo,srcname,nombre,toggle=false,changeSrc=true){
	p = getIndex(id)-0;
        Src[p].title = descripcion;
        const ext = srcname.split('.')[1];
        ext === 'pdf' && $('#url-adjunto').attr('target', '_blank');
	changeSrc && $('#img-view').attr('src',src);
        $('#url-adjunto').attr('href', srcname);
        $('#url-adjunto').attr('download', nombre);
        $('#img-view').attr('data-id',id);
	$('#title').html(descripcion);
        $('#descripcion').val(descripcion);
        $('#view-doc').remove();
        if ( tipo-0 !== IMG ) {
            $('#img-view').hide();
            const CARPETA = carpetaAdjunto(tipo-0); 
            const URL_DOC = URL_SERVER + '/web/uploads/adjuntos/' + CARPETA + '/' + nombre;
            const SRC_DOC = 'https://docs.google.com/gview?url=' + URL_DOC + '&embedded=true';
            $('#view-modal-body').append('<iframe id="view-doc" src="' + SRC_DOC + '" width="100%" height="500"></iframe>');
        } else {
            $('#img-view').show();
        }
	toggle && $('#view-imagen').modal('toggle');
}

function carpetaAdjunto(TIPO) {
    switch(TIPO){
        case XLS:
            return 'excel';
        case PDF:
            return 'pdf';
        case DOC:
            return 'doc';
        default:
            return 'img';
    }
}

function getIndex(id){
    const tamanioSrc = Src.length;
    for(var i = 0; i < tamanioSrc; i++){
        if(Src[i].id-0 === id-0){
            return i;
        }
    }
    
    return 0;
}