/* global existCitaProx, _baseURL, TIPO_COBRO, init_fns_cobro, id_cita, id_paciente */
var enviarNotificacion = true;
var totalSeguimientos = 0;
$(document).ready(function(){
    getSeguimientosPaciente();
    enviarReprogramacionCita();
    
    //funciones de cobro cobro-cita.js
    if( init_fns_cobro ){
        eventosCalcularTotal();
        calcularTotal();
        efectuarCobroBtn();
        cerrar_modal_cobro();
        copiarBtn();
    }
    if( TIPO_COBRO === 1 ){//Link externo
        cambioEstadoCobro();
    }
    copiarBtnDetalle();
});

$('#cancelar-todas-periodicas').click( () => {
    $.post( _baseURL + '/cita/cancelar-cita', 
        { 
            cita_periodica_token, 
            fecha:cita_periodica_fecha 
        }, 
        (json) => json.Correcto && location.reload(), 
    'json');
});
$('#cancelar-individual-periodica').click( e => {
    $.post( _baseURL + '/cita/cancelar-cita', 
        { id: id_cita }, 
        (json) => json.Correcto && location.reload(), 
    'json');
});

$('#cancelar-cita-periodica').click( () => $('#cancelar-cita-periodica-modal').modal('show') );

$('#btn-estado').click(function(){
    const estado = $('#estado').val();
    if(estado === ''){
        $.bsAlert('Debe seleccionar un estado');
        return;
    }
    if( estado-0 === 3 && cita_periodica_token !== ''){
        $('#cambiar-estado-cita-modal').modal('hide');
        $('#cancelar-cita-periodica-modal').modal('show');
        return;
    }
    $.post(_baseURL + '/cita/cambiarestadocita', {'id':id_cita, 'estado':estado},function(json){
        if(json.Correcto){
            const Cita = json.Cita;
            if(Cita.estado-0 === 3){
                $('#cambiar-estado-cita-modal').modal('toggle');
                $.post(_baseURL + '/seguimiento/create',{'idC':Cita.id},function(json){
                     if(json.Correcto){
                          $('#segTitulo').html('Nuevo Seguimiento');
                          $('#segCuerpo').append(json.viewForm);
                          $('#pacienteAutocomplete').val(json.paciente);
                          $('#pacienteAutocomplete').attr('disabled',true);
                          $('#bitacora-inte').hide();
                          isNewRecord = true;
                          addPickers();
                          saveBtnClick();
                     }
                 },'json');
                 modal.style.display = "block"; 
            } else {
                funcionFinalConfirmarCita();
            }
        }
    },'json');
});//ready fn
   
   
function funcionFinalConfirmarCita(){
    window.location.reload();
}

function getSeguimientosPaciente(){
    var items = '';
    var icono = '';
    var textoModal = '';
    if(existCitaProx == 'true'){
        $.post(_baseURL + '/seguimiento/seguimiento-paciente',{ id_paciente },(json)=>{
            if(json.Correcto){
                var Seguimientos = json.Seguimientos
                if(Seguimientos.length > 0){
                    totalSeguimientos = Seguimientos.length;
                    textoModal = json.CitaProxima != null ? '<p><strong>Este paciente tiene una cita agendada para el día '+json.CitaProxima.fecha+'. ¿Desea marcar cómo completados los seguimientos existentes?</strong></p>' 
                    : '<p><strong>Desea marcar como completados los seguimientos del paciente '+json.Paciente+'</strong></p>';
                    $('#kt-list-items').children().remove();
                    $('#pseg-title').html('Seguimientos - '+json.Paciente);
                    $('#desc').append(textoModal);
                    $.each(Seguimientos,function(i,seguimiento){
                        icono = '<input type="checkbox" class="form-control delete-sp" data-id="'+seguimiento.id+'">';
                        items += '<div class="kt-list-timeline__item" id="sp-'+seguimiento.id+'">\n\
                                <span class="kt-list-timeline__badge kt-list-timeline__badge--success"></span>\n\
                                <span class="kt-list-timeline__text"><strong>'+seguimiento.fecha+'</strong><br>'+seguimiento.motivo+'</span>\n\
                                <span class="kt-list-timeline__time">'+icono+'</span>\n\
                            </div>';
                    });
                    $('#kt-list-items').append(items);
                    $('#foot').append('<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>\n\
                                       <button type="button" class="btn btn-success" id="mark-all">Marcar Todo</button>'
                                    );
                    deleteSeguimientoPaciente();
                    markAllSeguimientosPaciente();
                    $('#btn-modal-seg').show();
                    if(isCreateCita == 'true'){
                        $('#seguimientos-paciente').modal('toggle');
                    }
                    
                } else {
                   $('#btn-modal-seg').hide();
                }
            }
        },'json')
    
    }
}


function deleteSeguimientoPaciente(){
    $('.delete-sp').click(function(e){
        var id = e.target.dataset.id;
        $.post(_baseURL + '/seguimiento/delete',{'id':id},function(json){
            if(json.Correcto){
                $('#sp-'+id).remove();
                totalSeguimientos = totalSeguimientos -1;
                if(totalSeguimientos == 0){
                    $('#seguimientos-paciente').modal('toggle');
                    getSeguimientosPaciente();
                }
            }
        });
    });
}

function markAllSeguimientosPaciente(){
    $('#mark-all').click(function(){
        $.post(_baseURL + '/seguimiento/completar-seguimientos-paciente',{ id_paciente },function(json){
            if(json.Correcto){
                $('#seguimientos-paciente').modal('toggle');
                $('#kt-list-items').children().remove();
                getSeguimientosPaciente();
            }
        },'json');
    });
}



function crearSeguimiento(Cita){
    var idC = Cita.id;
    $.post(_baseURL + '/seguimiento/create',{'idC':idC},function(json){
         if(json.Correcto){
              $('#segTitulo').html('Nuevo Seguimiento');
              $('#segCuerpo').append(json.viewForm);
              $('#pacienteAutocomplete').val(json.paciente);
              $('#pacienteAutocomplete').attr('disabled',true);
              $('#bitacora-inte').hide();
              isNewRecord = true;
              addPickers();
              saveBtnClick();
         }
     },'json');
     modal.style.display = "block"; 
}


function enviarReprogramacionCita(){
    if(reprogramar == 'true'){
        $('#enviar-reprogramacion').modal('toggle');
    }
}

$('#si-enviar').click(function(){
    enviarReprogramacion();
});

$('#no-enviar').click(function(){
    var bool = confirm('Esta seguro de realizar esta acción?');
    if(bool){
        enviarNotificacion = false;
        $('#enviar-reprogramacion').modal('toggle');
        window.location.href = _baseURL + "/cita/view?id=" + id_cita;
    }
});

$('#enviar-reprogramacion').on('hidden.bs.modal', function(){
    if(enviarNotificacion)enviarReprogramacion();
});

function enviarReprogramacion(){
    $.post(_baseURL + '/cita/enviar-reprogramacion-cita-paciente',{'id_cita':id_cita, 'fecha_anterior':fecha_anterior},function(json){
        if(json.Correcto){
            enviarNotificacion = true;
            $.bsAlert('Se ha enviado la notificación')
            window.location.href = _baseURL + "/cita/view?id=" + id_cita;
        }
    });
}

function viewCita(id_cita){
    window.location.href = _baseURL + "/cita/view?id=" + id_cita;
}

