/* global _baseURL, $datetimePickerOptions, todayDate, diasNoHabiles */


var eventAppended = false;
var trValidarCalendario = false;
var minutosDeshabilitados = [];
var sobremontarCita = false;
var horarioDisponible = [];
const minutos = [0,5,10,15,20,25,30,35,40,45,50,55];
const isMoszilla = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
const addCero = n => n < 10 ? `0${n}` : n;  

$(document).ready(function(){
    //Comienza a partir de la fecha exacta donde se entre al sistema y deshabilita fechas pasadas
    $datetimePickerOptions.startDate = todayDate;
    //$datetimePickerOptions.endDate = endMonth;
    $datetimePickerOptions.daysOfWeekDisabled = diasNoHabiles;
    $datetimePickerOptions.keyboardNavigation = true;
    $datetimePickerOptions.autoclose = true;
    $datetimePickerOptions.showMeridian = true;
    //Solo mostrar datepicker
    $datetimePickerOptions.minView = 2;
    $datetimePickerOptions.language = 'es';
    $datetimePickerOptions.format = 'dd/mm/yyyy';    
    $datetimePickerOptions.pickTime = false;
    
    $("#sobremontar").change(function(e){
        var { checked } = e.target;
        sobremontarCita = checked;
        if( sobremontarCita ){
            $datetimePickerOptions.startDate = null;
            $datetimePickerOptions.daysOfWeekDisabled = [];
            $('#cita-fecha').datetimepicker('remove');
            $('#cita-fecha').datetimepicker($datetimePickerOptions);
            var opt = '';
            $('#horas').children().remove();
            $('#horas').append('<option value="">Horas disponibles</option>');
            for(var i = 0; i < 24; i++){
                var h = i > 12 ? i - 12 : i;
                for(var j = 0; j < minutos.length; j++){
                    var horaMinuto =  (addCero(h))+':'+(addCero(minutos[j]))+(i < 12 ? ' AM' : ' PM');
                    opt += '<option value="'+horaMinuto+'">'+horaMinuto+'</option>';
                }
            }
            $('#horas').append(opt);

        } else {
            $datetimePickerOptions.startDate = todayDate;
            $datetimePickerOptions.daysOfWeekDisabled = diasNoHabiles;
            $('#cita-fecha').datetimepicker('remove');
            $('#cita-fecha').datetimepicker($datetimePickerOptions);
            llenarSelectHorario(horarioDisponible);
        }
    });
    
    $('#cita-fecha').val(fechaCita);//fecha que viene desde calendario
    
    if(horaCita !== ''){
        $('#horas').children().remove();
        $('#horas').append('<option value="'+horaCita+'" selected>'+horaCita+'</option>');
    }
    
    $('#cita-fecha').datetimepicker($datetimePickerOptions).on('changeDay',function(){
        var idClinica = $("#cita-id_clinica").length > 0 ?  $("#cita-id_clinica").val() : 0;
        $.blockUI({ message: '<h3>Cargando...</h3>'});
        var duracion = $('#cita-tiempo_estimado').val();
        var data = {fecha: getCurrentDate(),duracion:duracion,id_clinica: idClinica};
        if(vistaCita == 'update'){
            data.id_cita = $("#id_cita").val();
        }
        if(!sobremontarCita){
            $.post(_baseURL + "/utils/obtener-horas-no-habiles",data,function(json){
                if(json.Correcto){
                    var [Y,M,D] = json.Fecha.split('-');
                    var date = new Date(json.Fecha);
                    $('#cita-fecha').datetimepicker('setDate',date);
                    var horasDeshabilitadas = sobremontarCita ? [] : $.map(json.Horas, function(e) {return parseInt(e);});
                    minutosDeshabilitados = json.Minutos;
                    horarioDisponible = json.Disponible;
                    llenarSelectHorario(horarioDisponible);
                    $('#sobremontar').removeAttr('checked');
                    $('#horas').datetimepicker('setHoursDisabled',horasDeshabilitadas);
                    $('#cita-fecha').val( addCero(D) + "/" + addCero(M) + "/" + Y );
                    $('#horas').select2('open');
                }
                $.unblockUI();
            },"json");
        } else {
            $.unblockUI();
            $('#horas').select2('open');
        }    
    })
    .on('changeMonth',function(){
        validarCalendarioDateTimePicker(false);
    })
    .on('show',function(){
        if(!trValidarCalendario){
            validarCalendarioDateTimePicker();
            trValidarCalendario = true;
        }
        $("#horas").val('').trigger('change');
        eventosFechas();
        habilitarRepetirCita();
    })
    .on('hide',function(){
        trValidarCalendario = false;
        $.unblockUI();
        setFormatoFechaCita();
        habilitarRepetirCita();
        selectDiaSemana();
        fechaInicioRepeticionesTimePicker();
        textoOpcionesRepetirCita();
    });
         
    $('#horas').select2({
        closeOnSelect: true,
        placeholder: 'Horas disponibles'
    }).change(validarFecha);
    
    //-->acciones de solicitud de cita que coincide con un horario

    $('#confirmar-denegacion-modal').on('shown.bs.modal', ()=>{
        $('#solicitud-cita-web-info').hide();
    });
    
    $('#confirmar-denegacion-modal').on('hidden.bs.modal', ()=>{
        $('#solicitud-cita-web-info').show();
        $('#solicitud-cita-web-info').attr('style', '');
    });
    
    $('.denegar').click( () =>{
        $('#confirmar-denegacion-modal').modal('toggle');
    });
    
    $('#enviar-ls-espera').click(()=>{
        denegarSolicitud( true );
    });
    
    $('#no-enviar-ls-espera').click(()=>{
        denegarSolicitud( false );
    });
    
    $('.aceptar').click( e =>{
        const id = $('#id_solicitud').val()-0;
        aceptar(id);
    });

    //<--acciones de solicitud de cita que coincide con un horario
});//ready fn

function validarFecha(){
    var [hora, meridiano] = $('#horas').val().split(' ');
    if(meridiano === 'PM'){
        var [h,min] = hora.split(':');
        hora = (h-0 === 12 ? h-0 : h-0 + 12) + ':' + min;
    }
    var idClinica = $("#cita-id_clinica").length > 0 ?  $("#cita-id_clinica").val() : 0;
    var fecha = $('#cita-fecha').val()+' '+hora;
    var data = { fecha: fecha, minutos: $("#cita-tiempo_estimado").val(), validarHorario: 1,id_clinica: idClinica};
    if(vistaCita == 'update'){
        data.id_cita = id_cita;
    }
    var [d,m,y] = $('#cita-fecha').val().split('/');
    var [h,min] = hora.split(':');
    var fechaHoy = new Date();
    var fechaCita = new Date(y,m-1,d,h,min,0);
    if(!sobremontarCita){
        if(fechaCita.getTime() < fechaHoy.getTime()){
            $.bsAlert("No hay disponibilidad de horario en la fecha y hora seleccionada, por favor verifique el calendario del médico.");
            $("#cita-fecha").val('');
            $("#horas").empty(); 
            return;
        }
    }    
    if(!sobremontarCita){
        $.post(_baseURL + "/utils/validar-fecha",data , function (json) {
            if (json.Correcto) {
                if(!json.FechaValida){
                    $.bsAlert("No hay disponibilidad de horario en la fecha y hora seleccionada, por favor verifique el calendario del médico.");
                    $("#cita-fecha").val('');
                    $("#horas").empty();
                }
                if( json.existeSolicitud ){
                    $("#cita-fecha").val('');
                    $("#horas").empty();
                    setInfoSolicitudModal( json.solicitud );
                    $('#solicitud-cita-web-info').modal('toggle');
                }
            }
        }, "json");
    }
}


function horasNoHabilesFechaCalendario(){
        var d = new Date(setFechaCalendar);
        var anio = d.getFullYear();
        var mes = d.getMonth() + 1;
        var dia = d.getDate() + 1;
        var date = anio+'-'+mes+'-'+dia;
        if(!trValidarCalendario){
            var idClinica = $("#cita-id_clinica").length > 0 ?  $("#cita-id_clinica").val() : 0;
            $.blockUI({ message: '<h3>Cargando...</h3>'});
            var duracion = $('#cita-tiempo_estimado').val();
            var data = {fecha: date,duracion:duracion,id_clinica: idClinica};
            if(vistaCita == 'update'){
                data.id_cita = id_cita;
            }
            if(!sobremontarCita){
                $.post(_baseURL + "/utils/obtener-horas-no-habiles",data,function(json){
                    if(json.Correcto){
                        var [Y,M,D] = json.Fecha.split('-');
                        var date = new Date(json.Fecha);
                        $('#cita-fecha').datetimepicker('setDate',date);
                        var horasDeshabilitadas = sobremontarCita ? [] : $.map(json.Horas, function(e) {return parseInt(e);});
                        horarioDisponible = json.Disponible;
                        llenarSelectHorario(horarioDisponible);
                        $('#horas').datetimepicker('setHoursDisabled',horasDeshabilitadas);
                        $('#cita-fecha').val( addCero(D) + "/" + addCero(M) + "/" + Y );
                        $('#horas').select2('open');
                    } 
                    $.unblockUI();
                },"json");
            }
            $.unblockUI();
        }
};

document.onreadystatechange = function(){
     if(document.readyState === 'complete'){
        if(fechaCita != ''  && horaCita == '' &&  $('#procedimientos').val().length > 0 && vistaCita == 'create'){
            horasNoHabilesFechaCalendario()
        }
        if(fechaCita != ''  && horaCita != '' &&  $('#procedimientos').val().length > 0 && vistaCita == 'create'){
            validarFecha();
        }
     }
}

function setInfoSolicitudModal( s ){
    $('#solicitud-cita-web-info').show();
    $('#id_solicitud').val( s.id  );
    $('#titulo-solicitud').html('Una solicitud de ' + s.paciente.nombreCorto + ' está chocando con la cita que quiere crear. ¿Qué quisiera hacer con esta solicitud?' );
    $('#paciente').html( s.paciente.nombreCompleto );
    $('#fecha').html( s.fecha );
    $('#tipo-cita-label').html( 'Tipo de cita: ' + s.tipoCita );
    $('#procedimiento').html( 'Procedimiento: ' + s.procedimientos );
    $('#cometario').html( 'Comentario: ' + s.comentario );
}

function validarCalendarioDateTimePicker(currentMonth = true){
    var fecha = ($('#cita-fecha').val() == '' && currentMonth ) ? todayDate : getCurrentDate();
    var duracion = $('#cita-tiempo_estimado').val();
    if($("#cita-tiempo_estimado").val() == '' || $("#cita-tiempo_estimado").val() == '0'){
        $('#cita-fecha').datetimepicker().trigger( "click" );
    }
    else{
        $.blockUI({ message: '<h3>Cargando...</h3>'});
        var idClinica = $("#cita-id_clinica").length > 0 ?  $("#cita-id_clinica").val() : 0;
        var data = {fecha: fecha, duracion:duracion,id_clinica: idClinica};
        if(vistaCita == 'update'){
            data.id_cita = $("#id_cita").val();
        }
        if(!sobremontarCita){
            $.post(_baseURL + '/utils/validar-calendario',data,function(json){
                if(json.Correcto){
                    var diasDeshabilitados = $.map(json.Dias,function(dia){return dia});
                    $('#cita-fecha').datetimepicker('setDatesDisabled',diasDeshabilitados);
                    if(!currentMonth){
                        var [Y,M,D] = json.Fecha.split('-');
                        var date = new Date(json.Fecha);
                        $('#cita-fecha').datetimepicker('setDate',date);
                        $('#cita-fecha').val(addCero(D) + "/" + addCero(M) + "/" + date.getFullYear());
                    }
                }
                $.unblockUI();
            },'json');
        }
        $.unblockUI();
    }
}


function getCurrentDate(full = true,formated = true){
    var date = $('#cita-fecha').datetimepicker('valueOf').viewDate;
    return formated ? formatDate(date,full) : date;
}
function formatDate(date,full = true){
    return date.getUTCFullYear() 
            + '-' + (date.getUTCMonth() + 1)  
            + '-' + date.getUTCDate(); 
            //+ (full ? ' ' + date.getUTCHours() + ':' + date.getUTCMinutes() : '');
}

const setDia = (dia) => isMoszilla  ?  dia + 1 : dia; 

function eventosFechas(){
    if(!eventAppended){
        
        $(".datetimepicker .datetimepicker-days .next").click(function(){
            validarCalendarioDateTimePicker(false);
        });

        eventAppended = true;
    }
}

function getHours(){
    var date = $('#cita-fecha').datetimepicker('valueOf').viewDate;
    return date.getUTCHours();
}

function llenarSelectHorario(data){
    var opt = '';
    $('#horas').children().remove();
    $('#horas').append('<option value="">Horas disponibles</option>');
    $.each(data,function(i,hora){
        opt += '<option value="'+hora+'" >'+hora+'</option>';
    });
    $('#horas').append(opt);
}

function aceptar( id ){
    $.get( _baseURL + '/solicitud-cita/aceptar',
    {
        id: id
    },
    ( json )=> {
        if( json.Correcto ){

            $('#solicitud-cita-web-info').modal('toggle');
            $.bsAlert( json.Mensaje ); 
        } else {
            $.bsAlert( json.Mensaje );
        }
    },
    'json');
}

function denegarSolicitud( bool_lista_espera ){
    const id = $('#id_solicitud').val()-0;
    $.post( _baseURL + '/solicitud-cita/denegar', 
        {
            id: id,
            lista_espera: bool_lista_espera ? 1 : 0 
        }, ( json )=>{
            if( json.Correcto ){
                $('#confirmar-denegacion-modal').modal('toggle');
                $('#solicitud-cita-web-info').modal('toggle');
                $.bsAlert( json.Mensaje ); 
            } else {
                $.bsAlert( json.Mensaje ); 
            }
    },'json'); 
}
   