/* global _baseURL */
var isNewRecord = false;
var modal = document.getElementById('seguimientosModal');
var span = document.getElementById('closeModalSeg');
$(document).ready(function(){
    citasAsistencia();
    getSeguimientos();
    span.onclick = function() {
      modal.style.display = "none";
      closeModal();
    }
    window.onclick = function(event) {
      if (event.target == modal && open) {
        closeModal();
        modal.style.display = "none";
      }
    }
});

function citasAsistencia(){
    $('#citas-asistencia-t').DataTable({
        "pagingType": "full_numbers",
        "serverSide": true,
        "order": [[ 2, "asc" ]],
        "columnDefs": [{
            "targets": 3,
            "orderable": false
        }],
        "language":{
            "lengthMenu": "Mostrar _MENU_ entradas",
            "zeroRecords": "No se encontrarón resultados :(",
            "info": "Página _PAGE_ de _PAGES_",
            "infoEmpty": "Ninguna coincidencia encontrada",
            "infoFiltered": "(0 de _MAX_ )",
            "search": "Buscar:",
            "paginate": {
                "first": "Inicio",
                "last":  "Fin",
                "next":  "Sig.",
                "previous": "Ante." 
            }    
        },
        "createdRow": function( row, data, dataIndex ) {
            $(row).attr('data-id', data[0]);
            $(row).attr('data-accion', 'asistencias');
            $(row).addClass('trpointer');
        },
        "ajax": {
            "url": _baseURL + '/seguimiento/citas-asistencia',
            "type": "post",
            "dataType":"json",
            "error":function(e){console.log(e);},
        },
        "columns": [        
            { "data": 2},
            { "data": 3},
            { "data": 4},
            { "data": 5}
        ],
    });
    $('tbody td:not(.disable-click)').css('cursor', 'pointer');
}

function btnClickSi(id){
    $.post(_baseURL + '/cita/confirmar-cita',{id:id,asistio:'si'},function(json){
        if(json.Correcto){
            dataTableReload('citas-asistencia-t');
        }
        else{
            $.bsAlert(json.Mensaje);
            dataTableReload('citas-asistencia-t');
        }
    },'json');
}
      
function btnClickNo(id){
    $.post(_baseURL + '/cita/confirmar-cita',{id:id,asistio:'no'},function(json){
        if(json.Correcto){
            var estado = json.Cita.estado;
            var idC = json.Cita.id;
            if(estado == 5){
                   $.post(_baseURL + '/seguimiento/create',{'idC':idC},function(json){
                        if(json.Correcto){
                             $('#segTitulo').html('Nuevo Seguimiento');
                             $('#segCuerpo').append(json.viewForm);
                             $('#pacienteAutocomplete').val(json.paciente);
                             $('#bitacora-inte').hide();
                             isNewRecord = true;
                             addPickers();
                             pacienteAutoComplete();
                             removePacienteAutocomplete();
                             saveBtnClick();
                        }
                    },'json');
                    modal.style.display = "block";
            }
            dataTableReload('citas-asistencia-t');
        }
        else{
            $.bsAlert(json.Mensaje);
            dataTableReload('citas-asistencia-t');
        }
    },'json');
}

function getSeguimientos(){
     $('#seguimientos-t').DataTable({
        "pagingType": "full_numbers",
        "processing": true,
        "serverSide": true,
        "order": [[ 2, "asc" ]],
        "columnDefs": [{
            "targets": 3,
            "orderable": false
        }],
        "language":{
            "lengthMenu": "Mostrar _MENU_ entradas",
            "processing":     "Buscando...",
            "zeroRecords": "No se encontrarón resultados :(",
            "info": "Página _PAGE_ de _PAGES_",
            "infoEmpty": "Ninguna coincidencia encontrada",
            "infoFiltered": "(0 de _MAX_ )",
            "search": "Buscar:",
            "paginate": {
                "first": "Inicio",
                "last":  "Fin",
                "next":  "Sig.",
                "previous": "Ante." 
            }    
        },
        "createdRow": function( row, data, dataIndex ) {
            $(row).attr('data-id', data[0]);
            $(row).attr('data-accion', 'seguimientos');
            $(row).addClass(data[1]);
            $(row).addClass('trpointer');
        },
        "ajax": {
            "url": _baseURL + '/seguimiento/seguimientos',
            "type": "post",
            "dataType":"json",
            "error":function(e){console.log(e);},
        },
        "columns": [        
            { "data": 2},
            { "data": 3},
            { "data": 4},
            { "data": 5},
            { "data": 6}
        ],
    });
    $('tbody td:not(.disable-click)').css('cursor', 'pointer');
}


function dataTableReload(id){
    $('#'+id).DataTable().ajax.reload();
}

function marcarCompletoT(id){
    var bool = confirm('¿Esta seguro de marcar este elemento como completo?');
    if(bool){
        $.post(_baseURL + '/seguimiento/delete',{id:id}, function(json){
            if(json.Correcto)dataTableReload('seguimientos-t');
        });
    }
}

function marcarPerdidoT(id){
    var bool = confirm('¿Esta seguro de marcar este elemento como perdido?');
    if(bool){
        $.post(_baseURL + '/seguimiento/perdido',{id:id}, function(json){
            if(json.Correcto)dataTableReload('seguimientos-t');
        });
    }
}

function verSeguimiento(id){
    $.get(_baseURL + '/seguimiento/view', {id:id},function(json){
        if(json.Correcto){
            $('#_ViewSegBody').append(json.viewForm);
            $('#_ViewSegTitle').html('Seguimiento - '+json.Paciente.nombreCompleto);
            marcarCompleto();
            marcarPerdido();
            interacciones(json.Bitacora);
            removeChildrenModalViewSeg();
            btnComentarioClick();
            btnAcercamiento();
            $('#_ViewSeg').modal('toggle');
        }
    });
}

function marcarCompleto(){
    $('.mc-s-mod').click(function(e){
        var id = e.target.dataset.id;
        var bool = confirm('¿Esta seguro de marcar este elemento como completo?');
        if(bool){
            $.post(_baseURL + '/seguimiento/delete',{id:id}, function(json){
                if(json.Correcto){
                    dataTableReload('seguimientos-t');
                    $('#_ViewSeg').modal('toggle');
                }
            });
        }
    });
}

function marcarPerdido(){
    $('.mp-s-mod').click(function(e){
        var id = e.target.dataset.id;
        var bool = confirm('¿Esta seguro de marcar este elemento como perdido?');
        if(bool){
            $.post(_baseURL + '/seguimiento/perdido',{id:id}, function(json){
                if(json.Correcto){
                    dataTableReload('seguimientos-t');
                    $('#_ViewSeg').modal('toggle');
                }
            });
        }
    }); 
}


$(document).on('click','table tr td:not(.disable-click)',function(e) {
    var id = $(this).closest('tr').data('id');
    var accion = $(this).closest('tr').data('accion');
    if (e.target == this && id){
        if(accion == 'asistencias'){
            location.href =  _baseURL + '/cita/view?id='+id;
        } else {
            $.get(_baseURL + '/seguimiento/view', {id:id},function(json){
                if(json.Correcto){
                    $('#_ViewSegBody').append(json.viewForm);
                    $('#_ViewSegTitle').html('Seguimiento - '+json.Paciente.nombreCompleto);
                    marcarCompleto();
                    marcarPerdido();
                    interacciones(json.Bitacora);
                    removeChildrenModalViewSeg();
                    btnComentarioClick();
                    btnAcercamiento();
                    $('#_ViewSeg').modal('toggle');
                }
            });
            
        }
    }
});

function btnComentarioClick(){
    $('#btnComentario').click(function(e){
        var {dataset} = e.target;
        var id = dataset.id;
        var paciente = dataset.paciente;
        var comentario = dataset.comentario;
        $('#_segTitle').html('¿Qué ocurrió luego del seguimiento que tuviste con '+paciente+'?');
        $('#_segBody').append(
                '<div class="row">\n\
                    <div class="col-md-12">\n\
                        <label>Comentario<span style="color:red;">&nbsp;*</span></label>\n\
                        <textarea class="form-control" rows="5" id="comentario" maxlength="500" placeholder="Escribe aquí cuál fue la respuesta del acercamiento que tuviste. Por ejemplo: Le marqué y me dijo que seguía enfermo, tendré que marcarle nuevamente en 1 semana.">'+comentario+'</textarea>\n\
                    </div>\n\
                 </div>'
                );
        $('#_segFoot').append('<button id="btnSaveComentario" class="btn btn-success" data-id="'+id+'">Guardar</button>');
        $('#_segMod').modal('toggle');
        $('#_ViewSegCont').addClass('no-visible');
        btnSaveComentario(); 
    });
}

function btnSaveComentario(){
    $('#btnSaveComentario').click(function(e){
        var id = e.target.dataset.id;
        var comentario = $('#comentario').val().replace(/[^a-zñáéíóúñ¿?¡!()@,.0-9\/\s]/gi,'');
        if(comentario == ''){
            setValidate('comentario','Comentario');
            return;
        }
        $.post(_baseURL + '/seguimiento/comentario',{'id':id,'comentario':comentario},function(json){
            if(json.Correcto){
                var coment = json.C;
                $('#_segMod').modal('toggle');
                $('#btnComentario').attr('data-comentario',coment.comentario);
                $('#comentarioDB').html('-'+coment.comentario);
                interacciones(json.Bitacora);
            }
        },'json');
    });
}

function btnAcercamiento(){
    $('.acercamiento').click(function(e){
        var {dataset} = e.target;
        var id = dataset.id;
        var fecha = dataset.fecha;
        var hora = dataset.hora;
        var paciente = dataset.paciente;
        $('#_segTitle').html('¿Qué seguimiento futuro tendrás con '+paciente+'?');
        $('#_segBody').append(
                '<div class="row">\n\
                    <div class="col-md-6">\n\
                        <label>Fecha<span style="color:red;">&nbsp;*</span></label>\n\
                        <input type="text" class="form-control" id="fecha_seguimiento">\n\
                    </div>\n\
                    <div class="col-md-6">\n\
                        <label>Hora<span style="color:red;">&nbsp;*</span></label>\n\
                        <input type="text" class="form-control" id="hora_seguimiento">\n\
                    </div>\n\
                 </div>\n\
                 <div class="row mt-3">\n\
                    <div class="col-md-12">\n\
                        <label>Seguimiento<span style="color:red;">&nbsp;*</span></label>\n\
                        <textarea class="form-control" rows="5" id="acercamiento" maxlength="500" placeholder="Escribe aquí la acción que debes de hacer para dar el seguimiento necesario. Por ejemplo: ¡Llamar al paciente porque él no ha marcado aún!" ></textarea>\n\
                    </div>\n\
                 </div>'
                );
        $('#_segFoot').append('<button id="saveAcercamiento" class="btn btn-success" data-id="'+id+'">Guardar</button>');
        $('#fecha_seguimiento').val(fecha);
        $('#hora_seguimiento').val(hora);
        $('#fecha_seguimiento').datepicker({'todayHighlight': true});
        $('#hora_seguimiento').timepicker();
        $('#_ViewSegCont').addClass('no-visible');
        $('#_segMod').modal('toggle');
        btnSaveAcercamiento(); 
    });
}

function btnSaveAcercamiento(){
    $('#saveAcercamiento').click(function(e){
        var id = e.target.dataset.id;
        var fecha = $('#fecha_seguimiento').val();        
        var hora = $('#hora_seguimiento').val();
        var acercamiento = $('#acercamiento').val().replace(/[^a-zñáéíóúñ¿?¡!()@,.0-9\/\s]/gi,'');
        if(fecha == ''){setValidate('fecha_seguimiento','Fecha');return}        
        if(hora == ''){setValidate('hora_seguimiento','Hora');return}
        if(acercamiento == ''){setValidate('acercamiento','Acercamiento');return}
        $.post(_baseURL + '/seguimiento/update',
        {
            'id':id,
            'fecha':fecha,
            'hora':hora,
            'acercamiento':acercamiento
        },function(json){
            if(json.Correcto){
                var acercamiento = json.Acercamiento;
                var model = json.S;
                $('#btnComentario').attr('data-id',acercamiento.id);
                $('#btnComentario').attr('data-comentario','');
                $('#fechaSegDB').html('');
                $('#fechaSegDB').html('<span>'+json.fecha+' '+model.hora_seguimiento.substring(0,5)+ '</span>');
                $('#acercamientoBD').html('Creado el&nbsp;<strong>'+acercamiento.fecha_incidencia.substring(0,10)+'</strong> para  <strong>'+acercamiento.fecha_seguimiento+'</strong><br>\n\
                                        <strong>'+acercamiento.interaccion+'</strong><br>\n\
                                        <span id="comentarioDB">&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;'+(acercamiento.comentario != null ? acercamiento.comentario : 'No has ingresado un comentario...')+'</span>'
                                        );
                interacciones(json.Bitacora);
                dataTableReload('seguimientos-t');
                $('#_segMod').modal('toggle');
            }
        },'json');
    });
}

function setValidate(id,campo){
    $('#'+id)[0].setCustomValidity('El campo '+campo+' no puede quedar vacio');
}

function marcarSeguimientoCompleto(){
    $('#seguimiento-estado').click(function(){
        var bool = confirm('¿Desea marcar este elemento como completado?');
        if(bool){
            seguimientCompletado();
        }
    });
}

function seguimientCompletado(){
    var id = $('#seguimiento-id').val();
    $.post(_baseURL + '/seguimiento/marcar-completado',{'id':id},function(json){
       if(json.Correcto){
            modal.style.display = "none";
            removeChildrensModal();
            dataTableReload('seguimientos-t');
       } 
    });
}


function interacciones(Bitacora){
    var items = '';
    $('#kt-list-bitacora').children().remove();
    $.each(Bitacora,function(i,bitacora){
        var interaccion = bitacora.interaccion == null ? 'No definido' : bitacora.interaccion;
        icono = '<i style="font-size:1.8rem; cursor:pointer;" class="la la-trash kt-font-danger delete-bs" data-id="'+bitacora.id+'"></i>';
        items += '<div class="kt-list-timeline__item" id="bp-'+bitacora.id+'">\n\
                <span class="kt-list-timeline__badge kt-list-timeline__badge--success"></span>\n\
                <span class="kt-list-timeline__text">Creado el <strong>'+bitacora.fecha_incidencia.substring(0,10)+'</strong> para <strong>'+bitacora.fecha_seguimiento+'</strong><br>\n\
                    <strong>'+interaccion+'</strong><br>\n\
                     &nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;'+(bitacora.comentario != null ? bitacora.comentario : 'No has ingresado un comentario...')+'\n\
                </span>\n\
                <span class="kt-list-timeline__time">'+icono+'</span>\n\
            </div>';
    });
    $('#kt-list-bitacora').append(items);
    deleteBitacoraSeg();
}

function deleteBitacoraSeg(){
    $('.delete-bs').click(function(e){
        var id = e.target.dataset.id;
        var bool = confirm('Esta seguro de eliminar este elemento');
        if(bool){
            $.post(_baseURL + '/seguimiento/delete-bitacora-item',{'id':id},function(json){
                if(json.Correcto){
                    $('#bp-'+id).remove();
                }
            },'json');
        }
    })
}

function pacienteAutoComplete(){
    $("#pacienteAutocomplete").autocomplete({
        source: function (request, response) {
            $.post(_baseURL + "/utils/pacientes", { text: request.term }, function (json) {
                if (json.Correcto) {
                    response($.map(json.Pacientes, function(p) {
                        var nombreCompleto = p.nombre + ' ' + p.apellido+ ' ' +(p.codigo == null ? 'No definido' : p.codigo);
                        return {
                            label: nombreCompleto,
                            value: nombreCompleto,
                            cod: p.codigo,
                            id: p.id
                        };
                    }));
                }
            }, "json");
        },
        minLength: 1,
        select: function (event, ui) {
            $("#seguimiento-id_paciente").val(ui.item.id);
            $("#pacienteAutocomplete").addClass("cuadro-lleno");
            var cod = ui.item.cod == '' ? 'No definido' : ui.item.cod;
            $("#cod-pac").html(cod);
        }
    });

}


function removePacienteAutocomplete(){
    $("#pacienteAutocomplete").click(function () {
        if ($("#pacienteAutocomplete").hasClass("cuadro-lleno")) {
            $("#pacienteAutocomplete").removeClass("cuadro-lleno");
            $("#pacienteAutocomplete").val("");
            $("#seguimiento-id_paciente").val("");
            $("#cod-pac").html('');
        }
    });
}

function addPickers(){
    $('#seguimiento-fecha_seguimiento').datepicker({'todayHighlight': true});
    $('#seguimiento-hora_seguimiento').timepicker();
    
    
}

$('#crear-seguimiento').click(function(){
   removeChildrensModal(); 
   $.get(_baseURL + '/seguimiento/create',function(json){
       if(json.Correcto){
            $('#segTitulo').html('Nuevo Seguimiento');
            $('#segCuerpo').append(json.viewForm);
            $('#paciente-field').show();
            isNewRecord = true;
            addPickers();
            pacienteAutoComplete();
            removePacienteAutocomplete();
            saveBtnClick();
       }
   },'json');
   modal.style.display = "block";
});

function saveBtnClick(){
    $('#seg-form').submit(function(e){
        e.preventDefault();
        if(isNewRecord){
           guardarSeguimiento();
       } else {
           editarSeguimiento();
       }
    });
}

function closeModal(){
    if(isNewRecord){
        guardarSeguimiento();
    } 
    removeChildrensModal();
}

function guardarSeguimiento(){
    var paciente = $('#seguimiento-id_paciente').val();
    var fecha = $('#seguimiento-fecha_seguimiento').val();
    var hora = $('#seguimiento-hora_seguimiento').val();
    var motivo = $('#seguimiento-motivo').val();
    var interaccion = $('#seguimiento-interaccion').val();
    if(paciente == '' || fecha == '' || hora == '' || motivo == '' || interaccion == ''){
        $.bsAlert('Para continuar debe ingresar los datos correspondientes');
        return;
    }
    $.post( _baseURL + "/seguimiento/create", {
            'paciente_id':paciente,
            'fecha_seguimiento':fecha,
            'hora_seguimiento':hora,
            'motivo':motivo,
            'interaccion':interaccion
        }, function(json){
        if(json.Correcto){
            isNewRecord = false;
            modal.style.display = "none";
            removeChildrensModal();
            dataTableReload('seguimientos-t');
        }
    },'json');
}


function editarSeguimiento(){
    var id = $('#seguimiento-id').val();
    var fecha = $('#fecha_seguimiento').val();
    var hora = $('#hora_seguimiento').val();
    var interaccion = $('#interaccion').val();
    if(id == '' || fecha == '' || hora == '' || interaccion == ''){
        $.bsAlert('Para continuar debe ingresar los datos correspondientes');
        return;
    };
    $.post( _baseURL + "/seguimiento/update", {
            'id': id,
            'fecha_seguimiento':fecha,
            'hora_seguimiento':hora,
            'interaccion':interaccion,
        }, function(json){
        if(json.Correcto){
            modal.style.display = "none";
            removeChildrensModal();
            dataTableReload('seguimientos-t');
        }
    },'json');
}

function removeChildrensModal(){
    $('#segTitulo').html('');
    $('#segCuerpo').children().remove();
    $('#segFooter').children().remove();
    $('.seg').html('');
}



function removeChildrenModalViewSeg(){
    $('#_ViewSeg').on('hidden.bs.modal', function () {
        $('#_ViewSegTitle').html('');
        $('#_ViewSegBody').children().remove();
        $('#_ViewSegFoot').children().remove(); 
    });
}

$('#_segMod').on('hidden.bs.modal', function () {
    //$('#_ViewSeg').show();
    $('#_ViewSegCont').removeClass('no-visible');
    if($('#_ViewSegCont').height() > 550){
            $('#_ViewSeg').addClass('scrolly');
    }
    $('#_segTitle').html('');
    $('#_segBody').children().remove();
    $('#_segFoot').children().remove(); 
});