Chart.defaults.line.spanGaps = true;

$(document).ready(function(){
    //$('#fecha-inicio').datepicker();
    //$('#fecha-fin').datepicker();
    //$('#fecha-u-a').datepicker();
    $("#btnLimpiar").click(function(){
        $("#usuarios-chart-container").children().remove();
    });
    
    $("#get-grafica").click(function(){
        var fecha_inicio = $('#fecha-inicio').val();
        var fecha_fin = $('#fecha-fin').val();
        var partFi = fecha_inicio.split("/");
        var partFf = fecha_fin.split("/");
        var fI = new Date(partFi[2],partFi[1],partFi[0]);
        var fF = new Date(partFf[2],partFf[1],partFf[0]);
        if(fF.getTime() < fI.getTime()){
            $.bsAlert('La fecha final debe ser mayor a la de inicio');
            return;
        }
        cargarDatos("usuarios-chart-container",fecha_inicio,fecha_fin);
    });
    
    $("#grafica-citas-p").click(function(){
        var fecha_inicio = $('#fecha-inicio_c').val();
        var fecha_fin = $('#fecha-fin_c').val();
        var partFi = fecha_inicio.split("/");
        var partFf = fecha_fin.split("/");
        var fI = new Date(partFi[2],partFi[1],partFi[0]);
        var fF = new Date(partFf[2],partFf[1],partFf[0]);
        if(fF.getTime() < fI.getTime()){
            $.bsAlert('La fecha final debe ser mayor a la de inicio');
            return;
        }
        cargarDatosGCitas("citas-us-chart-container",fecha_inicio,fecha_fin);
    });
    
    var fecha_inicio = $('#fecha-inicio').val();
    var fecha_fin = $('#fecha-fin').val();
    cargarDatos("usuarios-chart-container",fecha_inicio,fecha_fin);
    
    var fecha_inicio_c = $('#fecha-inicio_c').val();
    var fecha_fin_c = $('#fecha-fin_c').val();
    cargarDatosGCitas("citas-us-chart-container",fecha_inicio_c,fecha_fin_c);
});

function cargarDatos(eId,fecha_inicio,fecha_fin){
    $.post(_baseURL + '/reportes-admin/datos-usuarios-activos',{'fecha_inicio':fecha_inicio, 'fecha_fin':fecha_fin},function(data){
        var datosGrafica = data.DatosGrafica;
        drawChart(eId,datosGrafica,'Usuarios Activos',1);
    },'json');
}

function cargarDatosGCitas(eId,fecha_inicio,fecha_fin){
    $.post(_baseURL + '/reportes-admin/citas-usuarios',{'fecha_inicio':fecha_inicio, 'fecha_fin':fecha_fin},function(data){
        console.log(data);
        var datosGrafica = data.DatosGrafica;
        drawChart(eId,datosGrafica,'Citas Agendadas',20);
    },'json');
}

$("#get-inactivos").click(function(){
    var fecha = $("#fecha-u-a").val();
    if(fecha == ''){
        $.bsAlert('Debe ingresar una fecha para poder continuar');
        return;
    }
    $.post(_baseURL + '/reportes-admin/usuarios-inactivos',{'fecha':fecha},function(data){
        if(data.Correcto){
            var users = data.usuariosInactivos;
            var trs = '';
            $("#usuarios-inactivos").children().remove();
            for(var i=0; i < users.length; i++){
                trs += '<tr>\n\
                            <td>'+users[i].id+'</td>\n\
                            <td>'+users[i].usuario+'</td>\n\
                            <td>'+users[i].nombre+'</td>\n\
                            <td>'+users[i].apellido+'</td>\n\
                            <td>'+users[i].telefonos+'</td>\n\
                            <td>'+users[i].Ncitas+'</td>\n\
                            <td><a target="_blank" href="'+users[i].url+'"><i class="fas fa-eye" style="font-size: 2rem;"></i></a></td>\n\
                        </tr>'
            }
            $("#usuarios-inactivos").append(trs);
        }
    },'json');
});


function drawChart(eId,datosGrafica,label,steps){
    $("#" + eId).children().remove();
    var canvas = '<canvas class="chart" height="400" width="400"></canvas>';
    $("#" + eId).append(canvas);
    var ctx = $("#" + eId + " canvas.chart");

    var barChartData = {
        labels: datosGrafica.Labels,
        datasets : [
            {
                label:label,
                fill: false,
                borderColor : '#646c9aAA',
                pointHoverRadius: 4,
                pointHoverBorderWidth: 12,
                pointBackgroundColor: Chart.helpers.color('#000000').alpha(0).rgbString(),
                pointBorderColor: Chart.helpers.color('#000000').alpha(0).rgbString(),
                pointHoverBackgroundColor: '#74747499',
                pointHoverBorderColor: Chart.helpers.color('#000000').alpha(0.1).rgbString(),
                data: datosGrafica.Conteo,
                lineTension: 0
            },
        ]
    };

    var scatterChart = new Chart(ctx,{
        type: 'line',
        data: barChartData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: false,
                scales: {
                    xAxes: [{
                        categoryPercentage: 0.35,
                        barPercentage: 0.70,
                        display: true,
                        scaleLabel: {
                            display: false,
                            labelString: 'Month'
                        },
                        gridLines: false,
                        ticks: {
                            display: true,
                            beginAtZero: true,
                            fontColor: '#545454',
                            fontSize: 13,
                            padding: 10
                        }
                    }],
                    yAxes: [{
                        categoryPercentage: 0.35,
                        barPercentage: 0.70,
                        display: true,
                        scaleLabel: {
                            display: false,
                            labelString: 'Value'
                        },
                        gridLines: {
                            color: '#A9A9A9',
                            drawBorder: false,
                            offsetGridLines: false,
                            drawTicks: false,
                            borderDash: [3, 4],
                            zeroLineWidth: 1,
                            zeroLineColor: '#A9A9A9',
                            zeroLineBorderDash: [3, 4]
                        },
                        ticks: {
                            max: Math.max(...datosGrafica.Conteo) + 1,
                            stepSize: steps,
                            display: true,
                            beginAtZero: true,
                            fontColor: '#545454',
                            fontSize: 13,
                            padding: 10
                        }
                    }]
                },
                title: {
                    display: true,
                    text: label,
                    fontSize: 18,
                    fontFamily: 'Helvetica Neue',
                    padding: 15
                },
                hover: {
                    mode: 'index'
                },
                tooltips: {
                    enabled: true,
                    intersect: false,
                    mode: 'nearest',
                    bodySpacing: 5,
                    yPadding: 10,
                    xPadding: 10, 
                    caretPadding: 0,
                    displayColors: false,
                    backgroundColor: '#454545AA',
                    titleFontColor: '#ffffff', 
                    cornerRadius: 4,
                    footerSpacing: 0,
                    titleSpacing: 0
                },
                layout: {
                    padding: {
                        left: 0,
                        right: 0,
                        top: 5,
                        bottom: 5
                    }
                }
            }
    });
}