$(document).ready(function(){
    
    $("#btnLimpiar").click(function(){
        $("#citas-chart-container").children().remove();
    });
    
    
    $('#fecha-inicio').keyup(function(){
        var fecha_n = $('#fecha-inicio').val();
        var re = new RegExp(escapeRegExp('_'),'g');
        var limpiarFecha = fecha_n.replace(re, '');
        var fechaLongitud = limpiarFecha.length;
        if(fechaLongitud == 10){
            var validarFn = existeFecha(fecha_n);
            if(!validarFn){
                $.bsAlert('La fecha ingresada no es válida');
                $('#fecha-inicio').val('');
            }
        }
    });
    
    
    $('#fecha-fin').keyup(function(){
        var fecha_n = $('#fecha-fin').val();
        var re = new RegExp(escapeRegExp('_'),'g');
        var limpiarFecha = fecha_n.replace(re, '');
        var fechaLongitud = limpiarFecha.length;
        if(fechaLongitud == 10){
            var validarFn = existeFecha(fecha_n);
            if(!validarFn){
                $.bsAlert('La fecha ingresada no es válida');
                $('#fecha-fin').val('');
            }
        }
    });
    
    $('#obtener-rango').click(function(){
        $('#rango-fechas').modal('toggle');
        var fecha_inicio = $('#fecha-inicio').val();
        var fecha_fin = $('#fecha-fin').val();
        if(fecha_inicio == '' || fecha_fin == '' ){
            $.bsAlert('Debe seleccionar dos fechas');
            return;
        }
        var partFi = fecha_inicio.split("/");
        var partFf = fecha_fin.split("/");
        var fI = new Date(partFi[2],partFi[1],partFi[0]);
        var fF = new Date(partFf[2],partFf[1],partFf[0]);
        if(fF.getTime() < fI.getTime()){
            $.bsAlert('La fecha final debe ser mayor a la de inicio');
            return;
        }
        var rango = fecha_inicio + '|' + fecha_fin;
        location.href = _baseURL + '/reportes/retroalimentacion?periodo=custom?'+rango;
        $('#fecha-inicio').val('');
        $('#fecha-fin').val('');
    });
    
});


function escapeRegExp(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');//buscar todas las incidencias del valor a reemplazar  
}

function existeFecha(fecha){
      var fechaf = fecha.split("/");
      var dia = fechaf[0];
      var mes = fechaf[1];
      var anio = fechaf[2];
      var f = new Date(anio,mes,'0');
      if( (dia-0)>( f.getDate()-0 ) || (mes-0) >( f.getMonth()+1 ) ){
            return false;
      }
      return true;
}
