/* global $datetimePickerOptions, _baseURL, showPacienteField */

$(document).ready(function(){
    $datetimePickerOptions.minuteStep = 15;
    $datetimePickerOptions.startDate = now();
    $datetimePickerOptions.autoclose = true;
    showPacienteField ? $('.paciente').show() : $('.paciente').hide() ; 
    $('#recordatoriodoctor-todo_dia').bootstrapSwitch({size:'small',onText:'Sí',offText:'No'});
    $('#recordatoriodoctor-todo_dia').change(validarTodoDia);
    
    function validarTodoDia(){
        var todoDia = $('#recordatoriodoctor-todo_dia').val();
        console.log(todoDia);
    }
    
    $('#recordatoriodoctor-es_paciente').bootstrapSwitch({size:'small', onText:'Sí',offText:'No'});
    $('#recordatoriodoctor-es_paciente').change(agregarPaciente);
    function agregarPaciente(){
        var esPaciente = $('#recordatoriodoctor-es_paciente').val();
        console.log(esPaciente);
    }
    
        $("#pacienteAutocomplete").autocomplete({
        source: function (request, response) {
            $.post(_baseURL + "/utils/pacientes", { text: request.term }, function (json) {
                if (json.Correcto) {
                    response($.map(json.Pacientes, function(p) {
                        var nombreCompleto = p.nombre + ' ' + p.apellido;
                        return {
                            label: nombreCompleto,
                            value: nombreCompleto,
                            id: p.id
                        };
                    }));
                }
            }, "json");
        },
        minLength: 1,
        select: function (event, ui) {
            $("#recordatoriodoctor-id_paciente").val(ui.item.id);
            $("#pacienteAutocomplete").addClass("cuadro-lleno");
        }
    });
    
    $("#pacienteAutocomplete").click(function () {
        if ($("#pacienteAutocomplete").hasClass("cuadro-lleno")) {
            $("#pacienteAutocomplete").removeClass("cuadro-lleno");
            $("#pacienteAutocomplete").val("");
            $("#cita-id_paciente").val("");
        }
    });
    
    
    $('#recordatoriodoctor-fecha_inicio').focus(function(){
    });
    
    $('#recordatoriodoctor-todo_dia').on('switchChange.bootstrapSwitch',function(e,state){
        $('#recordatoriodoctor-fecha_inicio').val('');
        $('#recordatoriodoctor-fecha_fin').val('');
        cargarFechasrecordatorio(state);
        $('#recordatoriodoctor-fecha_inicio').focus();
    });
    
    $('#recordatoriodoctor-fecha_inicio').datetimepicker($datetimePickerOptions).on('changeDate',
        function(){
            //validarFecha();
            if($('#recordatoriodoctor-fecha_inicio').val() !=  ""){
                $('#recordatoriodoctor-fecha_fin').datetimepicker('setStartDate',$('#recordatoriodoctor-fecha_inicio').val());
            }
    });
    $('#recordatoriodoctor-fecha_fin').datetimepicker($datetimePickerOptions).on('changeDate');
    
    var cstate = $('#recordatoriodoctor-todo_dia').is(':checked');
    cargarFechasrecordatorio(cstate);
});

function cargarFechasrecordatorio(state){
    if(state){
        $('#recordatoriodoctor-fecha_inicio').datetimepicker('remove');
        $('#recordatoriodoctor-fecha_inicio').datepicker({format: 'dd/mm/yyyy', minDate: nowPicker()});
        $('.field-recordatoriodoctor-fecha_fin').hide();
    }
    else{

        $('#recordatoriodoctor-fecha_inicio').datepicker('remove');
        $('#recordatoriodoctor-fecha_inicio').datetimepicker($datetimePickerOptions);
        $('.field-recordatoriodoctor-fecha_fin').show();
    }
}

$('#recordatoriodoctor-es_paciente').on('switchChange.bootstrapSwitch',function(e,state){
    if(state){
       $('.paciente').show(); 
    } else {
       $('.paciente').hide();
    }
});

function now(){
    var today = new Date();
    var date = today.getFullYear()+'-'+(today.getMonth()+1)+'-'+today.getDate();
    var time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
    return date+' '+time;
}

function nowPicker(){
    var today = new Date();
    var date = today.getDate()+'/'+today.getFullYear()+'/'+(today.getMonth()+1);
    return date;
}