/* global clinicaSeleccionada, _baseURL, tipoUsuario, tipoSuscripcion, hoy */

var idReceta = 0;
$(document).ready(function(){
   $('#fechaCita').datepicker({
        'setDate': new Date(),
        'gotoCurrent': true,
        'todayHighlight': true
    });
   $('#fechaCita').val(hoy);
   $('#proximaCita').datepicker({
       'gotoCurrent': true,
       'todayHighlight': true
   });
   
   $('#new-receta').click(function(){
       if(configInfoReceta == 1){
            $('#receta-modal').modal('toggle');
       } else {
           var bool = confirm('¿Ir a la configuración ahora?');
           if(bool)window.location.href = _baseURL + '/settings/index';
       }
   });
   
   $('#crear-receta').click(function(){
       var id_receta = $('#id_receta').val() - 0;
       var id_paciente = $('#id_paciente').val();
       var fechaCita = $('#fechaCita').val();
       var proximaCita = $('#proximaCita').val();
       var receta = $('textarea#receta').val();
       if(fechaCita == '' || receta == '' ){
           $.bsAlert('Debe ingresar los datos requeridos');
           return; 
       }
       if(id_receta == '' || id_receta == 0){
            $.post(_baseURL + '/receta/create', {'id_paciente': id_paciente, 'fechaCita':fechaCita, 'proximaCita': proximaCita, 'receta':receta },function(json){
                if(json.Correcto){
                    $('#receta-modal').modal('toggle');
                    historialPaciente('all');
                    listaFechasHistorial(id_paciente);
                    idReceta = json.id;
                    verRecetaTipoUsuario(json.id,'¿Desea visualizar la receta creada?');
                }
            });
        } else {
            $.post(_baseURL + '/receta/update', {'id': id_receta, 'fechaCita':fechaCita, 'proximaCita': proximaCita, 'receta':receta },function(json){
                if(json.Correcto){
                    $('#receta-modal').modal('toggle');
                    $('#fechaCita').val(hoy);
                    $('#proximaCita').val('');
                    $('#receta').val('');
                    historialPaciente('all');
                    listaFechasHistorial(id_paciente);
                    idReceta = json.id;
                    verRecetaTipoUsuario(json.id,'¿Desea visualizar la receta editada?');
                }
            });
        }
   });
   
   
    //Ver receta después de seleccionar una clínica con usuario doctor    
    $('#verReceta').click(function(){
        let idClinica = $('#id_clinica').val();
        window.open( _baseURL + '/receta/receta-pdf?id='+idReceta+'&clinica='+idClinica, '_blank' );
        idReceta = 0;
        $('#clinicas-modal').modal('toggle');
    });
   
});

function verRecetaTipoUsuario(id,mensaje){
    var bool = confirm(mensaje);
    if(bool){
        if( tipoSuscripcion === 1 ){
                window.open( _baseURL + '/receta/receta-pdf?id='+id, '_blank');
        } else {
            if(tipoUsuario === 2){
                window.open(_baseURL + '/receta/receta-pdf?id='+id+'&clinica='+clinicaSeleccionada, '_blank');
            } else {
                $('#clinicas-modal').modal('toggle');
            }
        }
    } else {
        idReceta = 0;
    }
    
}



function verReceta(){
    $('.view-receta').click(function(e){
        var id = e.target.id;
        $.get(_baseURL + '/receta/view',{'id':id},function(json){
            if(json.Correcto){
                var model = json.model;
                $('#recetaTitle').html(model.fechaCita);
                $('#bnt-print').append('<button id="imp-receta-modal" data-id="'+model.id+'" type="button" class="btn btn-primary"><i class="la la-print"></i> Imprimir</button>');
                $('#receta').append('<div>\n\
                                            <div class="separator"></div>\n\
                                            <div class="info-rec">\n\
                                                <div class="fecha-cita"><strong>Fecha de Cita: </strong>'+model.fechaCita+'</div>\n\
                                                <div class="cita-prox"><strong>Próxima Cita: </strong>'+(model.proximaCita == null ? 'No definido': model.proximaCita)+'</div>\n\
                                            </div>\n\
                                            <div class="separator"></div>\n\
                                            <div class="pill-medicamentos">&nbsp;&nbsp;Rp/</div><br>\n\
                                            <div class="receta-text">'+model.receta+'</div>\n\
                                       </div>');
                imprimirRecetaModal();
                $('#view-receta').modal('toggle');
                
            }
        },'json');
    });
}

function imprimirRecetaModal(){
    $('#imp-receta-modal').click(function(e){
        const id = e.target.dataset.id
        idReceta = id;
        if( tipoSuscripcion === 1 ){
            window.open( _baseURL + '/receta/receta-pdf?id='+id, '_blank');
        } else {
            if(tipoUsuario === 2){
                window.open(_baseURL + '/receta/receta-pdf?id='+id+'&clinica='+clinicaSeleccionada, '_blank');
            } else {
                $('#clinicas-modal').modal('toggle');
            }
        }
    });
}

function imprimirReceta(){
    $('.icon-pdf').click(function(e){
        const id = e.target.id;
        idReceta = e.target.id;
        if( tipoSuscripcion === 1 ){
            window.open( _baseURL + '/receta/receta-pdf?id='+id, '_blank');
        } else {
            if( tipoUsuario-0 === 2){
                window.open(_baseURL + '/receta/receta-pdf?id='+id+'&clinica='+clinicaSeleccionada, '_blank');
            } else {
                $('#clinicas-modal').modal('toggle');
            }
        }
    });  
}

function editarReceta(){
    $('.box-receta').click(function(e){
        const id = e.target.id;
        $.get(_baseURL + '/receta/view',{'id':id},function(json){
            if(json.Correcto){
                var model = json.model;
                $('#id_receta').val(model.id);
                $('#fechaCita').val(model.fechaCita);
                $('#proximaCita').val(model.proximaCita);
                $('textarea#receta').val(model.formatoReceta);
                $('#receta-modal').modal('toggle');
            }
        },'json');
    });  
}


function eliminarReceta(){
    $('.eliminar-rec').click((e)=>{
        const id_paciente = $('#id_paciente').val();
        const id = e.target.id;
        bool = confirm('¿Esta seguro de elimiar este elemento?');
        if(bool){
            $('#rec-'+id).addClass('del-el');
            $.post(_baseURL + '/receta/delete',{'id':id},(json)=>{
                if(json.Correcto){
                    historialPaciente('all');
                    listaFechasHistorial(id_paciente); 
                }
            },'json');
        }
    });
}

$('#receta-modal').on('hidden.bs.modal', function () {
    $('#id_receta').val('');
    $('#fechaCita').val(hoy);
    $('#proximaCita').val('');
    $('textarea#receta').val('');

});

$('#view-receta').on('hidden.bs.modal', function () {
        $('#id_receta').val('');
        $('#bnt-print').children().remove();
        $('#receta').children().remove();

});

$('#clinicas-modal').on('hidden.bs.modal', function () {
    idReceta = 0;
});

