/* global _baseURL */

var currentZIndex = 99;
$(document).ready(function(){
    var selected = 0;
    $(".ficha-paciente").draggable({ 
        start: function(e,ui) {
            currentZIndex ++;
            $(this).css("z-index", currentZIndex++);
            
            selected = $(this).data("id");
        }
    });
    $(".ficha-paciente").droppable({
        drop: function( event, ui ) {
            var id = $(this).data("id");
            var data = {id1: selected, id2: id};
            
            $("#dialog-union-pacientes").data("id1",selected);
            $("#dialog-union-pacientes").data("id2",id);
            $.post( _baseURL + '/paciente/obtener-pacientes-unir',data,function(json){
                if(json.Correcto){
                    llenarPaciente(1,json.Paciente1);
                    llenarPaciente(2,json.Paciente2);
                    $("#dialog-union-pacientes").modal("show");
                    
                }
            },'json');
        }
    });
    
    $('#dialog-union-pacientes').on('hide.bs.modal', function () {
        window.location.reload();
    });
    
    
    $("#btn-unir").click(function(){
        
        var id1 = $("#dialog-union-pacientes").data("id1");
        var id2 = $("#dialog-union-pacientes").data("id2");
        var data = {id1: id1, id2: id2};
        $.post(_baseURL + "/paciente/unir",data,function(json){
            if(json.Correcto){
                window.location.reload();
            }
        },'json');
    });
    
    
    $(".abrir-ficha-paciente").click(function(){
        var parent = $(this).parent().parent().parent().parent();
        if($(parent).hasClass("kt-portlet--collapsed")){
            $(parent).removeClass("kt-portlet--collapsed");
        }
        else{
            $(parent).addClass("kt-portlet--collapsed");
        }
        var icon = $(this).find('i');
        var content = $(icon).hasClass("fa-plus") ? '<i class="fa fa-minus"></i> Contraer' : '<i class="fa fa-plus"></i> Expandir';

        $(this).html(content);
    });
});

function llenarPaciente(no,paciente){
    $("#p" + no + "-nombreCompleto").val(paciente.nombre + " " +  paciente.apellido);
    $("#p" + no + "-telefono_fijo").val(paciente.telefono_fijo);
    $("#p" + no + "-email").val(paciente.email);
    $("#p" + no + "-celular").val(paciente.celular);
    $("#p" + no + "-direccion").val(paciente.direccion);
}
