/* global _baseURL */

$(document).ready(function(){
    //$('#paciente-fecha_nacimiento').datepicker();
    valoresComunicacion();
    $("#paisAutocomplete").autocomplete({
        source: function (request, response) {
            $.post(_baseURL+"/utils/paises", { text: request.term }, function (json) {
                if (json.Correcto) {
                    response($.map(json.Paises, function(p) {
                                var nombre = p.nombre + " (" + p.iso + ")"
                                return {
                                    label: nombre,
                                    value: nombre,
                                    id: p.id
                                };
                           }));
                }
            }, "json");
        },
        minLength: 2,
        select: function (event, ui) {
            $("#paciente-id_pais").val(ui.item.id);
            $("#paisAutocomplete").addClass("cuadro-lleno");
            $("#paciente-direccion").focus();
        }
    });
    
    $("#paisAutocomplete").click(function () {
        if ($("#paisAutocomplete").hasClass("cuadro-lleno")) {
            $("#paisAutocomplete").removeClass("cuadro-lleno");
            $("#paisAutocomplete").val("");
            $("#paciente-id_pais").val("");
        }
    });
    
    $("#paciente-aseguradora").select2({tags: true});
    $("#seleccionar-clinica-paciente").select2();
    
    $("#paciente-procedencia").select2({
        tags: true,
        language: {
            noResults: function() {
                return "No hay procedencias";        
            },
            searching: function() {
                return "Buscando..";
            }
        }
    });
});

$('#paciente-fecha_nacimiento').blur(function(){
    var re = new RegExp(escapeRegExp('_'),'g');
    var fecha_n = $('#paciente-fecha_nacimiento').val().split('/').map(x=>x.replace(re, ''));
    if(fecha_n.length > 1){
        if(fecha_n[0].length < 2 || fecha_n[1].length < 2 || fecha_n[2].length < 4){
            $.bsAlert('¡El formato de fecha ingresado no es válido. Ingrese una fecha con el formato siguiente ejem: "16/07/1995"!');
        }
    }
});

$('#paciente-fecha_nacimiento').keyup(function(){
    var fecha_n = $('#paciente-fecha_nacimiento').val();
    var re = new RegExp(escapeRegExp('_'),'g');
    var limpiarFecha = fecha_n.replace(re, '');
    var fechaLongitud = limpiarFecha.length;
    if( fechaLongitud === 10 ){
        var validarFn = existeFecha(fecha_n);
        if(!validarFn){
            $.bsAlert('La fecha ingresada no es válida');
            $('#paciente-fecha_nacimiento').val('');
        }
    }
});

function escapeRegExp(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');//buscar todas las incidencias del valor a reemplazar  
}

function existeFecha(fecha){
      var [ dia, mes, anio ] = fecha.split("/");
      var f = new Date(anio,mes,'0');
      if( (dia-0)>( f.getDate()-0 ) || (mes-0) >( f.getMonth()+1 ) ){
            return false;
      }
      return true;
}

function valoresComunicacion(){
    var valores = $("#valores-comunicacion").val();
    var valores = valores.split("|");
    if( valores.includes('sms') ){
        $("#paciente-celular").addClass("campo-activo");
    }
    
    if( valores.includes('correo') ){
        $("#paciente-email").addClass("campo-activo");
    }
}
