/* global id_cita, _baseURL, id_paciente, tipoSuscripcion, hoy, init_fns_cobro, TIPO_COBRO, boolCobroPasarela, porcentajePasarela, montoPasarela, fecha_anterior, reprogramar, isCreateCita, existCitaProx */
var isNewSeg = false;
const modal = document.getElementById('seguimientosModal');
const span = document.getElementById('closeModalSeg');
$(document).ready(function(){

    getSeguimientosPaciente();
    
    let primerItemId = $('#items-fecha').children()[0].children[1].id;
    listaFechasHistorial( id_paciente );
    
    $('#fecha_doc').val( hoy );
    $('#fecha_doc').datepicker({
        setDate: new Date(),
        gotoCurrent: true,
        todayHighlight: true
    }).blur( e =>{
       if( e.target.value.trim() === ''){
            $('#fecha_doc').val( hoy );
       }  
    });
    
    
    /**
     * click de elemtos de la lista de fechas
     * */
    $('.cita-lista-el').click(function(e){
        const fecha = e.target.id;
        selecItemCita(fecha);
    });
    
    
    if(id_cita !== 0){
        selecItemCita(id_cita);
    } else {
        $('#'+primerItemId).addClass('selected-item');
        viewCita(primerItemId);
    }
    
    
    if( tipoSuscripcion-0 === 1 ){
      $('.item-estado-paciente').click( e => {
            const { dataset:{ id, estado } } = e.target;
            $('#estados-paciente').html('');
            const spanEstado = e.target.children[0].cloneNode( true );
            const textoEstado = e.target.text;
            $('#estados-paciente').append( spanEstado );
            $('#estados-paciente').append( textoEstado );
            $.post(_baseURL + '/paciente/cambiar-estado', 
            {
                id: id,
                estado: estado
            }, (json)=>{
                !json.Correcto && $.bsAlert( json.mensaje );
                ocultarItemsEstado();
            },'json');
        });
    }
    
    span.onclick = function() {
      modal.style.display = "none";
      closeModal();
    }
    
    window.onclick = function(event) {
      if (event.target == modal && open) {
        closeModal();
        modal.style.display = "none";
      }
    }
    
    $('.crear-seguimiento-pac').click(function(){
        $.post(_baseURL + '/seguimiento/create',{'idP':id_paciente},function(json){
            if(json.Correcto){
                  $('#segTitulo').html('Nuevo Seguimiento');
                  $('#segCuerpo').append(json.viewForm);
                  $('#pacienteAutocomplete').val(json.paciente);
                  $('#pacienteAutocomplete').attr('disabled',true);
                  //$('#bitacora-inte').hide();
                  addPickers();
                  saveBtnClick();
            }
        },'json');
        modal.style.display = "block"; 
    });
    
    const $el1 = $('#documentos-paciente');
    $el1.fileinput({
        allowedFileExtensions: ['jpg', 'gif', 'png', 'jpeg', 'pdf', 'doc', 'docx', 'xlsx', 'xls'],
        language: 'es',
        theme: 'fa',
        uploadUrl: _baseURL + '/documento-paciente/create',
        uploadAsync: true,
        deleteUrl: _baseURL + '/documento-paciente/delete',
        showUpload: false,
        showRemove: false,
        overwriteInitial: false,
        minFileCount: 1,
        maxFileCount: 6,
        browseOnZoneClick: true,
        initialPreviewAsData: true,
        fileActionSettings:{
            showUpload: false,
            showDelete: false,
            uploadIcon:'<i class="fa fa-upload kt-font-primary"></i>',
            downloadIcon:'<i class="fa fa-download kt-font-success"></i>',
            removeIcon:'<i class="fa fa-trash kt-font-danger"></i>',
            zoomIcon:'<i class="fa fa-eye"></i>'
        },
        browseIcon:'<i class="fa fa-search"></i>&nbsp;',
        uploadExtraData: (previewId, index) => {
            return {
                id_paciente: id_paciente, 
                fecha: $('#fecha_doc').val()
            };
        }
    }).on('fileuploaded', () => {
        $('#documentos-paciente').fileinput('clear');
        listaFechasHistorial(id_paciente);
    });
    
    $('#enviar-docs').click( () => {
        $('#documentos-paciente').fileinput('upload');
    });

 });
 
function ocultarItemsEstado(){
    const itemsEstado = $('.item-estado-paciente');
    const itemActive = $('#estados-paciente').children()[0];
    $.each( itemsEstado, (i,el) => {
        const { estado } = el.dataset;
        if( itemActive.dataset.estado-0 === estado-0 ){
            $( '#estado-' + estado ).addClass('hide');
        } else {
            $( '#estado-' + estado ).removeClass('hide');
        } 
    }); 
}
 function selecItemCita(id){
    $('.cita-lista-el').removeClass('selected-item');
    $('#'+id).addClass('selected-item');
    eliminarVariables();
    viewCita(id);   
 }
 
 function confirmar(id){
    $('#confirmarCitaModal').find('#btn-confirmarCitaModalYes').click(function () {
        $('#confirmarCitaModal').modal('hide');
        $.post(_baseURL + '/cita/confirmar-cita',{id:id,asistio:'si'},function(json){
            if(json.Correcto){
                $('#confirmarCitaModal').data("desmarcar",false);
                viewCita(id);
            }
            else{
                $.bsAlert(json.Mensaje);
                viewCita(id);
            }
        },"json");
    });
    $('#confirmarCitaModal').find('#btn-confirmarCitaModalNo').click(function () {
        $('#confirmarCitaModal').modal('hide');
        $.post(_baseURL + '/cita/confirmar-cita',{id:id,asistio:'no'},function(json){
            if(json.Correcto){
                $('#confirmarCitaModal').data("desmarcar",false);
                viewCita(id);
                crearSeguimiento(json.Cita);
            }
            else{
                $.bsAlert(json.Mensaje);
                viewCita(id);
                crearSeguimiento(json.Cita);
            }
        },"json");
    });
    $('#confirmarCitaModal').data("desmarcar",true);
    $('#confirmarCitaModal').data("id-cita",id);
    $('#confirmarCitaModal').modal('show');
    $("#confirmarCitaModal button.close").click(function(){$('#confirmarCitaModal').modal('hide');});
}

 
function viewCita(id){
    $('#id_cita').val(id);
    if(id-0 !== 0){
        $.ajax({
            url: _baseURL + '/cita/view-template?id=' + id,
            type: "GET",
            contentType: "text/html; charset=utf-8",
            success: function (data) {
                $('#cita-view').children().remove();
                $('#cita-view').html(data);
                $('#fecha-label').html('Cita: <small style="font-size: 15px;">'+$('#fecha-cita-str')[0].dataset.fecha+'</small>');
                cambiarEstado();
                cancelarCita();
                //funciones de cobro cobro-cita.js
                if(init_fns_cobro){
                    eventosCalcularTotal();
                    calcularTotal();
                    efectuarCobroBtn();
                    //ocultarCampoUrl();
                    cerrar_modal_cobro();
                    copiarBtn();
                }
                if (TIPO_COBRO === 1) {//Link externo
                    cambioEstadoCobro();
                }
                copiarBtnDetalle();
                $(".edit-title").hide();
            }
        });
    }else {
        $('#cita-view').children().remove();
        $('#cita-view').html(sinCitasMensaje());
    }
}

function eliminarVariables(){
    delete existCitaProx;
    delete isCreateCita;
    delete reprogramar;
    delete fecha_anterior;
    delete id_cita;
    delete init_fns_cobro; 
}

function cambiarEstado(){
    $('#btn-estado').click(function(){
        var idCita = $('#id_cita').val();
        var estado = $('#estado').val();
        if(estado === ''){
            $.bsAlert('Debe seleccionar un estado');
            return;
        }
        $.post(_baseURL + '/cita/cambiarestadocita', {'id':idCita, 'estado':estado},function(json){
            if(json.Correcto){
                var Cita = json.Cita
                $('#cambiar-estado').modal('toggle');
                if(Cita.estado == 3){
                    $.post(_baseURL + '/seguimiento/create',{'idC':Cita.id},function(json){
                         if(json.Correcto){
                              $('#segTitulo').html('Nuevo Seguimiento');
                              $('#segCuerpo').append(json.viewForm);
                              $('#pacienteAutocomplete').val(json.paciente);
                              $('#pacienteAutocomplete').attr('disabled',true);
                              $('#bitacora-inte').hide();
                              addPickers();
                              saveBtnClick();
                              viewCita(idCita);
                              modal.style.display = "block"; 
                         }
                     },'json');
                } else {
                    viewCita(idCita);
                }
            }
        },'json');
    });
}
function cancelarCita(){
    $('#cancelar-cita').click((e)=>{
        var id = e.target.dataset.id;
        var bool = confirm('¿Esta seguro de cancelar esta cita?');
        if(bool){
            $.post(_baseURL + '/cita/cancelar-cita',{'id':id},(json)=>{
                if(json.Correcto){
                    viewCita(id);
                }
            });
        }
    });
}

//$('#view-imagen').on('hidden.bs.modal', function (e) {
//  window.location.reload();
//});
 
function getSeguimientosPaciente(){
    var items = '';
    var icono = '';
    var textoModal = '';
    $.post( _baseURL + '/seguimiento/seguimiento-paciente',{'id_paciente':id_paciente},(json) => {
        if(json.Correcto){
            var Seguimientos = json.Seguimientos;
            if(Seguimientos.length > 0){
                totalSeguimientos = Seguimientos.length;
                textoModal = json.CitaProxima != null ? '<p><strong>Este paciente tiene una cita agendada para el dia '+json.CitaProxima.fecha+'. ¿Desea marcar cómo completados los seguimientos existentes?</strong></p>' 
                : '<p><strong>Desea marcar cómo completados los seguimientos del paciente '+json.Paciente+'</strong></p>';
                $('#kt-list-items').children().remove();
                $('#pseg-title').html('');
                $('#foot').children().remove();
                $('#desc').children().remove();
                $('#pseg-title').html('Seguimientos - '+json.Paciente);
                $('#desc').append(textoModal);
                $.each(Seguimientos,function(i,seguimiento){
                    icono = '<input type="checkbox" class="form-control delete-sp" data-id="'+seguimiento.id+'">';
                    items += '<div class="kt-list-timeline__item" id="sp-'+seguimiento.id+'">\n\
                            <span class="kt-list-timeline__badge kt-list-timeline__badge--success"></span>\n\
                            <span class="kt-list-timeline__text"><strong>'+seguimiento.fecha+'</strong><br>'+seguimiento.motivo+'</span>\n\
                            <span class="kt-list-timeline__time">'+icono+'</span>\n\
                        </div>';
                });
                $('#kt-list-items').append(items);
                $('#foot').append('<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>\n\
                                   <button type="button" class="btn btn-success" id="mark-all">Marcar Todo</button>'
                                );
                deleteSeguimientoPaciente();
                markAllSeguimientosPaciente();
                $('#btn-modal-seg-1').show();
                $('#btn-modal-seg').show();
                $('#segs-divider').show();
            } else {
               $('#btn-modal-seg').hide();
               $('#segs-divider').hide();
            }
        }
    },'json')
    
}


function deleteSeguimientoPaciente(){
    $('.delete-sp').click(function(e){
        var id = e.target.dataset.id;
        $.post(_baseURL + '/seguimiento/delete',{'id':id},function(json){
            if(json.Correcto){
                $('#sp-'+id).remove();
                totalSeguimientos = totalSeguimientos -1;
                if(totalSeguimientos == 0){
                    $('#seguimientos-paciente').modal('toggle');
                    getSeguimientosPaciente();
                }
            }
        });
    });
}

function markAllSeguimientosPaciente(){
    $('#mark-all').click(function(){
        var id_paciente = $('#id_paciente').val();
        $.post(_baseURL + '/seguimiento/completar-seguimientos-paciente',{'id_paciente':id_paciente},function(json){
            if(json.Correcto){
                $('#seguimientos-paciente').modal('toggle');
                $('#kt-list-items').children().remove();
                getSeguimientosPaciente();
            }
        },'json');
    });
}

function crearSeguimiento(Cita){
    var estado = Cita.estado;
    var idC = Cita.id;
    if( estado-0 === 5 ){
        $.post(_baseURL + '/seguimiento/create',{'idC':idC},function(json){
             if(json.Correcto){
                isNewSeg = true;
                $('#segTitulo').html('Nuevo Seguimiento');
                $('#segCuerpo').append(json.viewForm);
                $('#pacienteAutocomplete').val(json.paciente);
                $('#pacienteAutocomplete').attr('disabled',true);
                $('#bitacora-inte').hide();
                addPickers();
                saveBtnClick();
             }
         },'json');
         modal.style.display = "block";
    }
}

function addPickers(){
    $('#seguimiento-fecha_seguimiento').datepicker();
    $('#seguimiento-hora_seguimiento').timepicker();
}

function saveBtnClick(){
    $('#seg-form').submit(function(e){
        e.preventDefault();
        guardarSeguimiento();
    });
}



function sinCitasMensaje(){
    return ('<div class="kt-portlet">\n\
                <div class="kt-portlet__body">\n\
                    <div class="kt-infobox">\n\
                            <div class="kt-infobox__header">\n\
                                <h2 class="kt-infobox__title">No se encontraron citas programadas</h2>\n\
                            </div>\n\
                            <div class="kt-infobox__body">\n\
                                <div class="kt-infobox__section">\n\
                                    <div class="kt-infobox__content">\n\
                                        Actualmente el paciente no cuenta con citas programadas para su respectiva visualización.<br> \n\
                                        Debe de agendar al menos una cita para ver esta sección.<br>\n\
                                        <br>\n\
                                    </div>\n\
                                </div>\n\
                            </div>\n\
                    </div>\n\
                </div>\n\
            </div>');
}


function closeModal(){
    if(isNewSeg){
        guardarSeguimiento();
    }
    removeChildrensModal();
}


function guardarSeguimiento(){
    var paciente = $('#seguimiento-id_paciente').val();
    var fecha = $('#seguimiento-fecha_seguimiento').val();
    var hora = $('#seguimiento-hora_seguimiento').val();
    var motivo = $('#seguimiento-motivo').val();
    var interaccion = $('#seguimiento-interaccion').val();
    if(paciente == '' || fecha == '' || hora == '' || motivo == '' || interaccion == ''){
        $.bsAlert('Para continuar debe ingresar los datos correspondientes');
        return;
    }
    $.post( _baseURL + "/seguimiento/create", {
            'paciente_id':paciente,
            'fecha_seguimiento':fecha,
            'hora_seguimiento':hora,
            'motivo':motivo,
            'interaccion':interaccion
        }, function(json){
        if(json.Correcto){
            modal.style.display = "none";
            removeChildrensModal();
        }
    },'json');
}

function removeChildrensModal(){
    $('#segTitulo').html('');
    $('#segCuerpo').children().remove();
    $('#segFooter').children().remove();
    $('.seg').html('');
}