/* global _baseURL */

$(document).ready(function(){
    $('#pacientes').DataTable({
        "pagingType": "full_numbers",
        "processing": true,
        "serverSide": true,
        "order": [[ 1, "asc" ]],
        "columnDefs": [{
            "targets": 6,
            "orderable": false
        }],
        "language":{
            "lengthMenu": "Mostrar _MENU_ entradas",
            "processing":     "Buscando...",
            "zeroRecords": "No se encontrarón resultados :(",
            "info": "Página _PAGE_ de _PAGES_",
            "infoEmpty": "Ninguna coincidencia encontrada",
            "infoFiltered": "(0 de _MAX_ )",
            "search": "Buscar:",
            "paginate": {
                "first": "Inicio",
                "last":  "Fin",
                "next":  "Sig.",
                "previous": "Ante." 
            }    
        },
        "createdRow": function( row, data, dataIndex ) {
            $(row).attr('data-id', data[0]);
            $(row).addClass('trpointer');
        },
        "ajax": {
            "url": _baseURL + '/paciente/pacientes',
            "type": "post",
            "dataType":"json",
            "error":function(e){console.log(e);},
        },
        "columns": [        
            { "data": 1},
            { "data": 2},
            { "data": 3},
            { "data": 4},
            { "data": 5},
            { "data": 6},
            { "data": 7}
        ],
    });
});
