 /* global _baseURL, windown */

var minutesArray =[0,15,30,45];

var timepickerOptions = { showMeridian:false };


$(document).ready( () => {
    $('#horariomedico-hora_inicio').timepicker( timepickerOptions );
    $('#horariomedico-hora_fin').timepicker( timepickerOptions );    
       
    $(".horario-item").attr("disabled", true);
    
    //mostrarFechas();
    
    $(".delete-horario").hide();
    $("#delete-horario-txt").hide();
    $("#id_clinica").val( $(".role-tab-item")[0].id );
    
    
    $(".role-tab-item").click(function (e) {
        var {id} = e.target;
        $("#id_clinica").val(id);
    });
    
    $('#_horario').on('hidden.bs.modal', function () {
        $('#modal_body').children().remove();
    });
  
    $("#btn_modal_horario").click(function(){
        var idClinica = $("#id_clinica").val() === '' ? 0 : $("#id_clinica").val()-0;
        if (idClinica === 0) {
            var bool = confirm("Por el momento no cuenta con una clínica a la cual adjudicar un horario. Por favor, cree una clínica.");
            if (bool) {
                window.location.href = _baseURL + "/clinica/create";
            }
        }
        $.ajax({
            url: _baseURL + '/horario/cargar-horarios?id_clinica=' + idClinica,
            type: "GET",
            contentType: "text/html; charset=utf-8",
            success: data => {
                $('#modal_body').html( data );
                //$(".horario-trabajo").hide();    
                setTimePicker();
                $("#_horario").modal("show");
                toggleHorario();
                agregarHorarios();
            }
        });       
    });
    
});

function toggleHorario(){
    $('.custom-control-input').change(function (e) {
        const {name, checked, value} = e.target;
        mostrarFechas(name, checked, value);
    });
}

var newinput = 0;
function agregarHorarios(){
    $('.btn-add-i').click( e => {
        newinput++;
        var {value, name} = e.target;
        var {name, value} = e.target;
        var inputDay = $("#dias").val();
        var newVal = inputDay + value + ",";
        $("#dias").val(newVal);
        campo = '<tr id="data-' + newinput + name + '" class="tr-fields">\n\
                <td>\n\
                    <input type="text" class="mt-1 horario-item ' + name + '-input" style="width: 70px;"  id="campo-' + newinput + name + '"&nbsp; name="hora-inicio[]" &nbsp; />\n\
                </td>\n\
                <td>\n\
                    <input type="text" class="mt-1 horario-item ' + name + '-input" style="width: 70px;"  id="campo-' + newinput + name + '"&nbsp; name="hora-fin[]"&nbsp; />\n\
                </td>\n\
                <td>\n\
                    <button type="button" class="btn btn-danger btn-sm btn_remove" id="' + newinput + name + '" value="' + value + '">X</button>\n\
                </td>\n\
            </tr>';
        $("#items-fecha-" + name).append(campo);
        setTimePicker();
    });
}

$(document).on('click', '.btn_remove', function (e) {
    var { value } = e.target;
    var inputDay = $("#dias").val();
    var quitarDia = inputDay.replace(value+",", "");
    $("#dias").val(quitarDia);
    var button_id = $(this).attr("id");
    $("#data-" + button_id).remove();
});

$('#eliminar').change(function(e){
    const {checked} = e.target;
    if(checked){
        $(".delete-horario").show();
        $("#delete-horario-txt").show();
    }else{
        $(".delete-horario").hide();
        $("#horario-delete-form")[0].reset();
        $("#delete-horario-txt").hide();
    }
});

function mostrarFechas(name, checked, value){
    var inputDay = $("#dias").val();
    if(!checked){
        $("#"+name+"-txt").html("-Cerrado-");
        $("#"+name+"-horas").hide();
        $("#"+name+"-hora-i").attr("disabled", true);
        $("#"+name+"-hora-f").attr("disabled", true);
        $("."+name+"-tems").attr("disabled", true);
        var re = new RegExp(escapeRegExp(value+','),'g');
        var quitarDias = inputDay.replace(re, '');
        $("#dias").val(quitarDias);
        $("."+name+"-input").attr("disabled", true);
    }else{
        $("#"+name+"-txt").html("-Abierto-");
        $("#"+name+"-hora-i").attr("disabled", false);
        $("#"+name+"-hora-f").attr("disabled", false);
        $("."+name+"-input").attr("disabled", false);
        $("#"+name+"-horas").show();      
        var newVal = inputDay+value+",";
        $("#dias").val(newVal);
    }
}

function escapeRegExp(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');//buscar todas las incidencias del valor a reemplazar  
}


function setTimePicker(){
    $('.horario-item').timepicker( timepickerOptions );    
}

