/* global $datetimePickerOptions, _baseURL */

$(document).ready(function(){
    $datetimePickerOptions.minuteStep = 15;
    $datetimePickerOptions.startDate = now();
    $datetimePickerOptions.autoclose = true;

    $('#evento-todo_dia').bootstrapSwitch({size:'small',onText:'Sí',offText:'No'});
    $('#evento-todo_dia').change(validarTodoDia);
    
    function validarTodoDia(){
        var todoDia = $('#evento-todo_dia').val();
        console.log(todoDia);
    }
    
    $('#evento-fecha_inicio').focus(function(){
    });
    
    $('#evento-todo_dia').on('switchChange.bootstrapSwitch',function(e,state){
        $('#evento-fecha_inicio').val('');
        $('#evento-fecha_fin').val('');
        cargarFechasEvento(state);
        $('#evento-fecha_inicio').focus();
    });
    
    $('#evento-fecha_inicio').datetimepicker($datetimePickerOptions).on('changeDate',
        function(){
            validarFecha();
            if($('#evento-fecha_inicio').val() !=  ""){
                $('#evento-fecha_fin').datetimepicker('setStartDate',$('#evento-fecha_inicio').val());
            }
    });
    $('#evento-fecha_fin').datetimepicker($datetimePickerOptions).on('changeDate',validarFecha);
    
    var cstate = $('#evento-todo_dia').is(':checked');
    cargarFechasEvento(cstate);
});

function cargarFechasEvento(state){
    if(state){
        $('#evento-fecha_inicio').datetimepicker('remove');
        $('#evento-fecha_inicio').datepicker();        
        $('#evento-fecha_fin').attr("disabled", true);
        $('#evento-fecha_fin').attr("required", false);
        $('.field-evento-fecha_fin').hide();
    }
    else{

        $('#evento-fecha_inicio').datepicker('remove');
        $('#evento-fecha_inicio').datetimepicker($datetimePickerOptions);
        $('#evento-fecha_fin').attr("required", true);
        $('#evento-fecha_fin').attr("disabled", false);
        $('.field-evento-fecha_fin').show();
    }
}

function validarFecha(){
    var todoDia = $('#evento-todo_dia').is(':checked');
    if($('#evento-fecha_inicio').val() != '' && (todoDia || $('#evento-fecha_fin').val() != '')){
        var data = { 
            fecha_inicio: $('#evento-fecha_inicio').val(),
            fecha_fin:  $('#evento-fecha_fin').val(),
            todo_dia: todoDia,
            id_evento: 0
        };
        $.blockUI({ message: '<h3>Validando...</h3>'});
        $.post(_baseURL+"/utils/validar-fecha-evento",data , function (json) {
            if (json.Correcto) {
                $.unblockUI();
                if(!json.FechaValida){
                    $.bsAlert("No hay disponibilidad de horario en la fecha y hora seleccionada, por favor verifique el calendario del médico.");
                    $("#evento-fecha_inicio").val('');
                    $("#evento-fecha_fin").val('');
                }
            }
        }, "json");
    }
}

function now(){
    var today = new Date();
    var date = today.getFullYear()+'-'+(today.getMonth()+1)+'-'+today.getDate();
    var time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
    return date+' '+time;
}
