
var isNewRecord = false;
$(document).ready(function(){
   
    $("#confirmarCitaModal").on("hidden.bs.modal", function () {
        if($('#confirmarCitaModal').data("desmarcar")){
            var idCita = $('#confirmarCitaModal').data("id-cita");
            $("#nf-"+idCita).prop("checked", false);
        }
        $('#confirmarCitaModal').data("id-cita",0);
        $('#confirmarCitaModal').find('#btn-confirmarCitaModalYes').unbind( "click" );
        $('#confirmarCitaModal').find('#btn-confirmarCitaModalNo').unbind( "click" );
        $("#confirmarCitaModal button.close").unbind( "click" );
    });
});

function confirmar(id){
    $('#confirmarCitaModal').find('#btn-confirmarCitaModalYes').click(function () {
        $('#confirmarCitaModal').modal('hide');
        $.post(_baseURL + '/cita/confirmar-cita',{id:id,asistio:'si'},function(json){
            if(json.Correcto){
                $('#confirmarCitaModal').data("desmarcar",false);
                funcionFinalConfirmarCita();
            }
            else{
                $.bsAlert(json.Mensaje);
                funcionFinalConfirmarCita();
            }
        },"json");
    });
    $('#confirmarCitaModal').find('#btn-confirmarCitaModalNo').click(function () {
        $('#confirmarCitaModal').modal('hide');
        $.post(_baseURL + '/cita/confirmar-cita',{id:id,asistio:'no'},function(json){
            if(json.Correcto){
                $('#confirmarCitaModal').data("desmarcar",false);
                crearSeguimiento(json.Cita);
            }
            else{
                $.bsAlert(json.Mensaje);
                funcionFinalConfirmarCita();
            }
        },"json");
    });
    $('#confirmarCitaModal').data("desmarcar",true);
    $('#confirmarCitaModal').data("id-cita",id);
    $('#confirmarCitaModal').modal('show');
    $("#confirmarCitaModal button.close").click(function(){$('#confirmarCitaModal').modal('hide');});
}

function crearSeguimiento(Cita){
    var estado = Cita.estado;
    var idC = Cita.id;
    if( estado-0 === 5 ){
        $.post(_baseURL + '/seguimiento/create',{'idC':idC},function(json){
             if(json.Correcto){
                  $('#segTitulo').html('Nuevo Seguimiento');
                  $('#segCuerpo').append(json.viewForm);
                  $('#pacienteAutocomplete').val(json.paciente);
                  $('#pacienteAutocomplete').attr('disabled',true);
                  $('#bitacora-inte').hide();
                  isNewRecord = true;
                  addPickers();
                  saveBtnClick();
             }
         },'json');
         modal.style.display = "block";
    }
}

function addPickers(){
    $('#seguimiento-fecha_seguimiento').datepicker();
    $('#seguimiento-hora_seguimiento').timepicker();
}

function closeModal(){
    if(isNewRecord){
        guardarSeguimiento();
    } 
    removeChildrensModal();
}


function saveBtnClick(){
    $('#seg-form').submit(function(e){
        e.preventDefault();
        if(isNewRecord){
           guardarSeguimiento();
       } 
    });
}

function guardarSeguimiento(){
    var paciente = $('#seguimiento-id_paciente').val();
    var fecha = $('#seguimiento-fecha_seguimiento').val();
    var hora = $('#seguimiento-hora_seguimiento').val();
    var motivo = $('#seguimiento-motivo').val();
    var interaccion = $('#seguimiento-interaccion').val();
    if(paciente === '' || fecha === '' || hora === '' || motivo === '' || interaccion === '')return;
    $.post( _baseURL + "/seguimiento/create", {
            'paciente_id':paciente,
            'fecha_seguimiento':fecha,
            'hora_seguimiento':hora,
            'motivo':motivo,
            'interaccion':interaccion
        }, function(json){
        if(json.Correcto){
            isNewRecord = false;
            modal.style.display = "none";
            removeChildrensModal();
            funcionFinalConfirmarCita();
        }
    },'json');
}

function removeChildrensModal(){
    $('#segTitulo').html('');
    $('#segCuerpo').children().remove();
    $('#segFooter').children().remove();
    $('.seg').html('');
}