/* global _baseURL */
const PAGADITO_CONF = 'Utilizar Pagadito';
const LINK_CONF = 'Utilizar un link propio';
const googleCalendarSelect = $('#google_calendar');

let alertConf = false;
let confExternas = {
    confPagadito:{
        invalid: false,
        actived: false,
        msg: false,
        action: () => {
            return guardarConfPagadito();
        },   
        callBack: () => {
            $('#info-pagadito-modal').modal('show');
        }
    },
    confLinkExterno:{ 
        invalid: false,
        actived: false,
        msg: false,
        action: () => {
            return guardarConfLinkExterno();
        },
        callBack: () => {
            $('#modal-url-cobro').modal('show');
        }
    },
    confGoogleCalendar:{ 
        invalid: false,
        actived: false,
        msg: false,
        action: () => true,
        callBack: () => {
            $('body,html').stop(true,true).animate({				
                scrollTop: $('#google-calendar-conf').offset().top
            },1000);
            googleCalendarSelect.focus();
        }
    }
};

$(document).ready(function(){
    $("#save3").on('click',function(event){  
        var url = $(this).attr('to');   
        $.get(_baseURL + '/settings/desvincular-calendar',  
        (json) => { 
            if( json.Correcto ){    
                    
                setTimeout(() => {  
                    $.bsAlert('El calendario se desvinculo correctamente'); 
                    $('#alertModal').modal('hide'); 
                    window.location.reload();   
                }, 1000);   
            }                   
        }, 'json');     
    });     
    showHorasReprogamacionCtrl();   
        
    obtenerConfiguracion('informacion_recetas_medicas');
    
    $(window).scroll(function(){
        const offs_btn = $("#save").offset().top;
        offs_btn > 186 ? $("#save").addClass("bnt-shadow") : $("#save").removeClass("bnt-shadow");
        
        if ( $(window).scrollTop() + $(window).height() === $(document).height() ) {
            $("#save").hide();
        } else {
            $("#save").show();
        }
    });
    
    let pagadito_conf = $('#conf_medio_pago');
    if( pagadito_conf.length > 0 ){
        if( pagadito_conf[0].checked ){
            $('#conf-'+pagadito_conf[0].id).show();
        } else {
            $('#conf-'+pagadito_conf[0].id).hide();
        }
    }
    
    $('.copy-btn').click( e => {
        let $temp = $('<input>');
        const ID = e.target.dataset.id;
        const ADDED_CONF = $('#'+ID+'-add').text().trim();
        const VAL_CONF = $('#'+ID).val().trim();
        $('body').append($temp);
        $temp.val( ADDED_CONF +  VAL_CONF ).select();
        document.execCommand('copy');
        $temp.remove();
        $('#'+e.target.dataset.id+'-btn').html('¡Copiado!');
        setTimeout(()=>{
            $('#'+e.target.dataset.id+'-btn').html('Copiar');
        },2000);
    });
    
    $('.ctrl-config-swt').change((e)=>{
        let {id,checked} = e.target;
        if(id === 'conf_medio_pago'){
            if(checked){
                $('#conf-'+id).show();
            } else {
                $('#conf-'+id).hide();
            }
        }
    });
    
    $('.ctrl-config-int').keyup( e => {
        let { value } = e.target;
        if( value.includes('-') ){
            e.target.value = value.replace('-', '');
        }
        if( value.includes('+') ){
            e.target.value = value.replace('+', '');
        }
    });
    
    
    $('.ctrl-config-check').click((e)=>{
        let { id } = e.target;
        let posiblesValores = $(".values-"+id);
        let valoresSelect = [];
        $.each( posiblesValores, (i,valor) =>{
            if(valor.checked){
                valoresSelect.push(valor.value);
            }
        });
        if(valoresSelect.length === 0 ){
            if(id === 'campos_requeridos_paciente'){
                $.bsAlert("Se ha desactivado la verificación de campos correo y celular. Para poder reactivarla seleccione al menos uno de los parametros");
            } else {
                $.bsAlert("Se ha desactivado la comunicación con los pacientes. Para poder reactivarla seleccione al menos uno de los parametros");
            }
        }
    });
    
    $('.max').keyup(function(e){
        let {id, value, dataset} = e.target;
        let longitud = dataset.long - 0;
        if(value.length > longitud){
            $('#error-'+id).show();
            $('#guardar-info-receta').prop('disabled',true);
        } else {
            $('#error-'+id).hide();
            $('#guardar-info-receta').prop('disabled',false);
        }
    });
    
    $('#leng-teleconsulta').html($('#link_teleconsulta').val().length);
    $('#link_teleconsulta').keyup(function(e){
        let { value, dataset } = e.target;
        let longitud = dataset.long-0;
        $('#leng-teleconsulta').html(value.length + '/' + longitud + ' caracteres');
        if(value.length > longitud){
            $('#leng-teleconsulta').html(' Máximo de caracteres permitidos ' + longitud);
            $('#link_teleconsulta').val(value.slice(0,longitud));
            $('#leng-teleconsulta').removeClass('kt-badge--brand');
            $('#leng-teleconsulta').addClass('kt-badge--danger');
        } else {
            $('#leng-teleconsulta').addClass('kt-badge--brand');
            $('#leng-teleconsulta').removeClass('kt-badge--danger');
        }
    });
    
    $('#guardar-info-receta').click(function(){
        let nombre = $('#nombre').val().trim();
        let apellido = $('#apellido').val().trim();
        let No_cedula_jvmp = $('#cedula').val().trim();
        let cedula_jvmp = $('#cedula-jvmp').val().trim();
        let especialidad = $('#especialidad').val().trim();
        let institucion = $('#institucion').val().trim();
        let correo = $('#correo-contacto').val().trim();
        let pais = $('#pais').val().trim();
        let confirmacion = $('#confirmacion')[0].checked ? 1 : 0;
        if(nombre === '' || apellido === '' || cedula === '' || institucion === '' || especialidad === ''){
           $.bsAlert('Debe ingresar los datos requeridos');
           return;
        }
        let valores = nombre+'|'+apellido+'|'+cedula_jvmp+'|'+No_cedula_jvmp+'|'+especialidad+'|'+institucion+'|'+(correo === '' ? '-' : correo)+'|'+(pais === '' ? '-' : pais);
        let data = {
            llave: 'informacion_recetas_medicas', 
            posibles_valores: valores, 
            valor: confirmacion
        };
        if(esAdminJerarquia){
            data = {...data, admin_jerarquia:true };
        }
        $.post(_baseURL + '/settings/actualizar-configuracion', 
        data,
        (json) => {
            if( json.Correcto ){
                let model = json.model;
                let [ nombre, apellido, jvmp, n_cedula, especialidad, institucion, correo, pais ] = model.posibles_valores.split('|');
                $('#info-receta').modal('hide');
                setInforeceta( nombre, apellido, jvmp, n_cedula, especialidad, institucion, correo, pais );
                model.valor-0 === 1 ? $('#confirmacion').attr('checked',true) : $('#confirmacion').attr('checked',false);
                $.bsAlert('La configuración de recetas ha sido guardada exitosamente');
            }
        }, 'json'); 
    });
    
    
    const constrolesSwt2 = $('.ctrl-config-swt-2');

    $.map( constrolesSwt2, (el, i) => {
        if( el.checked && el.value === PAGADITO_CONF ){
            $('#conf-pagadito-btn').show();
        } else if( el.checked && el.value === LINK_CONF ){
            $('#conf-url-propia-btn').show();
        }
    });

    constrolesSwt2.click( e => {
        const { id, value, checked } = e.target;
        const ID = id.split('-')[0];
        if(checked  && value.trim() === PAGADITO_CONF ){
            $('#conf-pagadito-btn').show();
            $('#' + ID + '-1' ).prop('checked', false);
        } else {
            $('#conf-pagadito-btn').hide();
        }
        if( checked  && value.trim() === LINK_CONF ){
            $('#conf-url-propia-btn').show();
            $('#' + ID + '-0' ).prop('checked', false);
        } else {
            $('#conf-url-propia-btn').hide();
        }
    });
    
    
    $('input[name="cobrar-pasarela-link"]').click( e => {
        const { value } = e.target;
        if ( value.toUpperCase() === 'SI' ){
            $('.campos-cargo-pasarela').show();
        } else {
            $('.campos-cargo-pasarela').hide();
        }
    });
    
    
    $('#guardar-link-cobro').click( guardarConfLinkExterno );
    
    $(".ctrl-config-text").keyup(function (e) {
        let {id} = e.target;
        let field = $("#" + id);
        let val = field[0].value;
        let longitud = val.length;
        let valorLimite = $('#' + id).val();
        if (id === 'link_medio_teleconsulta')
            return;
        $("#" + id + "-length").html(longitud + '/' + 15 + ' caracteres');
        if (id === "nombre_publico") {
            if (longitud > 15) {
                $("#" + id + "-length").html(' Máximo de caracteres permitidos ' + 15);
                $('#' + id).val(valorLimite.slice(0, 16));
                $("#" + id + "-length").removeClass('kt-badge--brand');
                $("#" + id + "-length").addClass('kt-badge--danger');
            } else {
                $("#" + id + "-length").addClass('kt-badge--brand');
                $("#" + id + "-length").removeClass('kt-badge--danger');
            }
        }
    });

    $('#permitir_reprogramacion_paciente').change( (e) => {
        let {checked} = e.target;
        checked ? $(".conf-horas_reprogramacion_cita").show()
                : $(".conf-horas_reprogramacion_cita").hide();
        
    });
    
    $(".save-btn").click(function () {
        guardarConfiguracion();
    });
        
    $('body').on('hide.bs.modal', e => {
        if ( alertConf && e.target.id === 'alertModal' ) {
            [].map.call(Object.getOwnPropertyNames(confExternas), (property) => {
                if ( confExternas[property].invalid && confExternas[property].msg ){
                    confExternas[property].callBack();
                    confExternas = {...confExternas, [property]: {...confExternas[property], invalid: false, msg: false}};
                } else{
                    confExternas = {...confExternas, [property]: {...confExternas[property], invalid: false}};
                }
            });
            alertConf = false;
        }
    });
    
});//ready fn

const validarCargoPasarela = (val, id = '') => {
    if( typeof val !== 'number' ){
        $.bsAlert('Ingrese un monto válido para los costos de pasarela');
        cerrarBsAlert();
        ( id !== '') && $(id).val( 0 );
        return false;
    }
    return true;
};

async function guardarConfLinkExterno() {
    const LINK_COBRO = $('#link-cobro').val().trim();
    const METODO_IVA = $('input[name="iva-link"]:checked').val() - 0;
    const COBRAR_PASARELA = ($('input[name="cobrar-pasarela-link"]:checked').val() === 'SI') ? true : false;
    const CARGO_PASARELA = $('input[name="cobro-pasarela-link"]:checked').val();//valor de tipo entero
    const PORCENTAJE_PASARELA = $('#valor-porcentual').val() - 0;
    const VALOR_FIJO_PASARELA = $('#valor-fijo').val() - 0;
    const PORCENTAJE_NO_VALIDO = COBRAR_PASARELA && !validarCargoPasarela(PORCENTAJE_PASARELA, id = '#valor-porcentual');
    const VALOR_FIJO_NO_VALIDO = COBRAR_PASARELA && !validarCargoPasarela(VALOR_FIJO_PASARELA, id = '#valor-fijo');
    if (LINK_COBRO.length < 8) {
        $.bsAlert('Link no válido');
        return false;
    }
    let data = {
        link: LINK_COBRO,
        metodo_iva: METODO_IVA,
        cobrar_pasarela: COBRAR_PASARELA ? 1 : 0,
        cargo_pasarela: CARGO_PASARELA,
        monto_porcentual: PORCENTAJE_PASARELA,
        monto_fijo: VALOR_FIJO_PASARELA
    };
    if (PORCENTAJE_NO_VALIDO || VALOR_FIJO_NO_VALIDO) {
        return false;
    }
    await $.post(_baseURL + '/pagadito/link-cobro-propio', data,
            (json) => {
        if (json.Correcto) {
            $('#modal-url-cobro').modal('hide');
            return true;
        } else {
            $.bsAlert('Ocurrió un error. Intente nuevamente');
            return false;
        }
    }, 'json');
}


function obtenerConfiguracion(llave){
    let data = { llave: llave };
    if(esAdminJerarquia){
        data = {...data, admin_jerarquia:true };
    }
    $.post(_baseURL + '/settings/obtener-configuracion',data,(json)=>{
        if(json.Correcto){
            let model = json.model;
            if(model.posibles_valores !== null){
                let [ nombre, apellido, jvmp, n_cedula, especialidad, institucion, correo, pais ] = model.posibles_valores.split('|');
                setInforeceta( nombre, apellido, jvmp, n_cedula, especialidad, institucion, correo, pais );
            }
            model.valor-0 === 1 ? $('#confirmacion').attr('checked',true) : $('#confirmacion').attr('checked',false);
        }
    });
}

function setInforeceta( nombre, apellido, jvmp, n_cedula, especialidad, institucion, correo, pais ){
    $('#cedula-jvmp').val( jvmp );
    $('#nombre').val( nombre );
    $('#apellido').val( apellido );
    $('#cedula').val( n_cedula );
    $('#especialidad').val( especialidad );
    $('#institucion').val( institucion );
    $('#correo-contacto').val( correo === '-' ?  '' : correo );
    $('#pais').val( pais === '-' ?  '' : pais );
}

$(".ctrl-config-int").click(function(e){
    let { id } = e.target;
    let field = $("#"+id);
    let val = parseInt(field[0].value);
    if(isNaN(val)){
        $.bsAlert("Ingrese un valor númerico");
    }

});

function showHorasReprogamacionCtrl(){
    const evtReproPaciente = $("#permitir_reprogramacion_paciente");
    if(evtReproPaciente.length > 0){
        var  checked  = evtReproPaciente[0].checked;
        if(checked){
            $(".conf-horas_reprogramacion_cita").show();
        } else {
            $(".conf-horas_reprogramacion_cita").hide();
        }
    }
}


function guardarConfiguracion(){
    //controles de configuracion por clase switch, entero, checkbox, texto, lista: obtener valores con ciclos para cada uno
    let ctrlSwt = $('.ctrl-config-swt');//controles tipo switch
    let ctrlInt = $('.ctrl-config-int');//controles tipo input de entero
    let ctrlCheck = $('.ctrl-config-check');//controles tipo check box
    let ctrlText = $('.ctrl-config-text');//controles tipo caja de texto
    let ctrlList = $('.ctrl-config-ls');//controles tipo lista
    let ctrlLibre = $('.ctrl-config-libre');//controles tipo input libre
    let ctrlMultipleSwt = $('.ctrl-config-swt-2');//controles tipo switch multiple
    let confEvaluada = []; 
    let data = [];//conf filtradas
    let exit = false;//detener la ejecucion de las configuraciones por validacion
    
    $.map( ctrlMultipleSwt, (el, i) => {
        const UID_PAGADITO = $('#uid').val().trim();
        const WSK_PAGADITO = $('#wsk').val().trim();
        const LINK_COBRO = $('#link-cobro').val().trim();
        const CONF_VAL = el.checked ? el.value : 0;
        if ( el.checked ) {
            if ( el.value === PAGADITO_CONF ) {
                if ( UID_PAGADITO === '' || WSK_PAGADITO === '' ) {
                    if ( !alertConf ) {
                        alertConf = true;
                        $.bsAlert('No ha configurado la información de su cuenta de pagadito'); 
                        confExternas = { ...confExternas,  confPagadito:{ ...confExternas.confPagadito, msg: true } };
                    } 
                    confExternas = { ...confExternas,  confPagadito:{ ...confExternas.confPagadito, invalid: true } };
                } else {
                    confExternas = { ...confExternas,  confPagadito:{ ...confExternas.confPagadito, actived: true } };
                }
            }
            if ( el.value === LINK_CONF ) {
                if ( LINK_COBRO === '' ) {
                    if( !alertConf ){
                        alertConf = true;
                        $.bsAlert('No ha configurado su link de cobro'); 
                        confExternas = { ...confExternas, confLinkExterno:{ ...confExternas.confLinkExterno, msg: true } };
                    }
                    confExternas = { ...confExternas, confLinkExterno:{ ...confExternas.confLinkExterno, invalid: true } };
                } else {
                    confExternas = { ...confExternas, confLinkExterno:{ ...confExternas.confLinkExterno, actived: true } };
                }
            }
        }
        if( !confEvaluada.includes( el.dataset.llave ) ){
            confEvaluada.push( el.dataset.llave );
            data.push({'id': el.dataset.llave, 'tipo': el.dataset.tipo, 'valor': CONF_VAL});
        }
    });
    
    if( $('#google_calendar').length  ){
        console.log(googleCalendarSelect);
        if( googleCalendarSelect.val().trim() === '' ){
            const googleMsg = '¡No has terminado de configurar tu calendario! Elige uno de tus calendarios disponibles en el selector indicado';
            if( !alertConf ){
                alertConf = true;
                $.bsAlert(googleMsg); 
                confExternas = { ...confExternas,  confGoogleCalendar:{ ...confExternas.confGoogleCalendar, msg: true } };
            } 
            confExternas = { ...confExternas,  confGoogleCalendar:{ ...confExternas.confGoogleCalendar, invalid: true } };
        }
    }
    
    [].map.call( Object.getOwnPropertyNames(confExternas), (property) => {
        if( confExternas[property].invalid ){
            exit = true; 
        } else if( confExternas[property].actived ) {
            exit = !confExternas[property].action();
        }
    });
    
    if( exit ){
        exit = false;
        return;
    } 
        
    $.map( ctrlCheck, (el,i) => { 
        let strValues = '';
        let posiblesValores = $('.values-'+el.id);
        let ctrlCheckSelect = [];//valores seleccionados
        if (!confEvaluada.includes(el.id)) {
            $.each(posiblesValores, (i, valor) => {
                if (valor.checked) {
                    !ctrlCheckSelect.includes(valor.value) && ctrlCheckSelect.push(valor.value);//evitar valores repetidos en el array
                }
            });
            confEvaluada.push( el.id );
            strValues = ctrlCheckSelect.join('|');
            data.push({'id':el.id,'tipo':el.dataset.tipo, 'valor':strValues});
            ctrlCheckSelect = [];
            strValues = '';
        }   
    });
    confEvaluada = [];
    
    $.map( ctrlSwt, (el, i) => {
        let valor = el.checked ? 1 : 0;
        data.push({'id':el.id, 'tipo':el.dataset.tipo, 'valor':valor});
    }); 
    
    $.map( ctrlInt, (el, i) => {
        let valor = el.value;
        if( el.id === 'horas_reprogramacion_cita' ){
            if(isNaN( valor-0 )){
                valor = 48;
            }
        }
        data.push({'id':el.id, 'tipo':el.dataset.tipo, 'valor':valor});
    });
        
    $.map( ctrlList, (el, i) => data.push({'id':el.id, 'tipo':el.dataset.tipo, 'valor':el.value}));
    $.map( ctrlText, (el, i) => data.push({'id':el.id, 'tipo':el.dataset.tipo, 'valor':el.value}));
    $.map( ctrlLibre, (el, i) => data.push({'id':el.id, 'tipo':el.dataset.tipo, 'valor':el.value}));
    
    let contador = 0;
    let longitud = data.length;
//    console.table(data);
//    return;
    $.map( data, (conf, i) => {
        let completo = actualizarValorConfig( conf );
        if( completo )contador++;
        if( contador === longitud ){
            $.bsAlert("La configuración ha sido guardada correctamente");
            guardarConfUrlUsuario();
            setInterval(function(){
                window.location.reload();
            },2500);
        } else {
            $.bsAlert("Ocurrio un error en el proceso vuelva a intentarlo");
        }
    });
}

async function actualizarValorConfig(data){
    if(esAdminJerarquia){
        data.admin_jerarquia = true;
    }
    await $.post( _baseURL + "/settings/update-setting",data,function(response){
        if( response.Correcto ){
            return true;
        } else {
            return false;
        }
    },"json");
    //return true;
}

function cerrarBsAlert() {
    setTimeout(() => {
        $('#alertModal').modal('hide');
    }, 2000);
}
