const modalComentario = '<div class="modal" role="dialog" aria-hidden="true" id="comentario-modal">\n\
                    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">\n\
                        <div class="modal-content">\n\
                            <div class="modal-header">\n\
                                <h5 class="modal-title title mt-2">¿Cómo crees que podríamos mejorar esta plataforma?</h5>\n\
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>\n\
                            </div>\n\
                            <div class="modal-body">\n\
                                <div class="row mt-4">\n\
                                    <div class="col-md-12">\n\
                                        <label>Comentario <span style="color: red;"> *</span></label>\n\
                                        <textarea id="comentario" class="form-control" rows="6" autocomplete="off"></textarea>\n\
                                    </div>\n\
                                </div>\n\
                            </div>\n\
                            <div class="modal-footer">\n\
                                <button id="enviar-comentario" type="button" class="btn btn-success" >Enviar Comentario</button>\n\
                            </div>\n\
                        </div>\n\
                    </div>\n\
                </div>';
var fechaFilter = $('#fecha-comentario').val();
$(document).ready(()=>{
    
    if( tipoUsuario-0 === 1 )crearModalComentario();
    if( tipoUsuario-0 === 0 )listarComentarios();
    
    if( tipoUsuario === 0 ){
        $('#fecha-comentario').datepicker({
            'gotoCurrent': true,
            'todayHighlight': true
        });
    }
    
    if( tipoUsuario === 0 ){
        $('#fecha-comentario').change( e =>{
            fechaFilter = e.target.value;
            listarComentarios();
        });
    }
});

function crearModalComentario(){
    const body = $('body');
    body.append( modalComentario );
    mostrarModalComentario();
    enviarComentario();
}

function mostrarModalComentario(){
    $('#_comentario').click(()=>{
        $('#comentario-modal').modal('toggle');
    });
};

function enviarComentario(){
    $('#enviar-comentario').click(()=>{
        const comentario = $('#comentario').val();
        if( comentario.trim() === ''){
            $.bsAlert('Debe de ingresar un comentario');
            return false;
        }
        $.post( _baseURL + '/comentario-suscripcion/create', 
            {
                comentario: comentario 
            },
            ( json )=>{
                if( json.Correcto ){
                    $("textarea#comentario").val( '' );
                    $('#comentario-modal').modal( 'toggle' );
                    $.bsAlert('Tu comentario ha sido enviado con éxito');
                } else {
                    $.bsAlert('No se pudo enviar. Ocurrió un error');
                }
            }
        ,'json');
    });
}

function listarComentarios(){
    $('#comentarios-ls').children().remove();
    $.get(_baseURL + '/comentario-suscripcion/index',
        {
            fecha:fechaFilter
        },(json) => {
        let comentarios = "";
        if(json.Correcto){
            if( json.Comentarios.length > 0 ){
                $.each(json.Comentarios,(i,comentario)=>{
                    let icon = 'flaticon-speech-bubble';
                    let color = 'kt-font-primary';
                    let el = '<div class="kt-notification-v2__item " data-id="' + comentario.id +'">\
                                    <a href="' + comentario.url + '" class="kt-notification-v2__item-icon" data-id="' + comentario.id +'">\
                                        <i class="' +icon +' '+color+ '"></i>\
                                    </a>\
                                    <div class="kt-notification-v2__itek-wrapper">\
                                        <span class="kt-notification-v2__item-title">\
                                            <a style="color: #5d5b6f;" href="' + comentario.url + '" data-id="' + comentario.id +'">\
                                                ' + comentario.titulo + '\
                                            </a>\
                                        </span>\
                                        <div class="kt-notification-v2__item-desc">\
                                            ' + comentario.comentario  + '\
                                        </div>\
                                    </div>\
                                </div>';
                    comentarios += el;
                });
                $('#comentarios-ls').append( comentarios );
            } else {
                $('#comentarios-ls').append( noComent() );
            }
        }
    },'json');
}

function noComent(){
    return ('<div class="kt-notification-v2__item " >\
                <a href="javascript:void(0);" class="kt-notification-v2__item-icon">\
                    <i class="flaticon-symbol kt-font-info"></i>\
                </a>\
                <div class="kt-notification-v2__itek-wrapper">\
                    <span class="kt-notification-v2__item-title">\
                        <a style="color: #5d5b6f;" href="javascript:void(0);">\
                            ' + 'No hay comentarios que mostrar' + '\
                        </a>\
                    </span>\
                    <div class="kt-notification-v2__item-desc">\
                        ' + 'No se han registrado comentarios para mejoras, sugerencias o cambios para Olivia'  + '\
                    </div>\
                </div>\
            </div>');
}
