/* global _baseURL, reprogramar, fecha_anterior, confComunicacion, vistaCita, tSuscripcion, tU, fechaCita, horaCita, todayDate, diasNoHabiles */

var fechaActual = new Date();
$(document).ready(function(){
    initSelectProcedimientos();
    $('#procedimientos').on('select2:select', function (e) {
        $(".select2-search__field").val('');
    });
    
    if((fechaCita !== '' || horaCita === '' )&& $('#procedimientos').val().length > 0 && vistaCita === 'create' ){
        sumarTiempo();
        sumarCosto();
        inputsPrecios();
    }
    
    vistaCita === 'create' && valoresComunicacion();
    vistaCita === 'update' && inputsPrecios();
    $("#cita-tiempo_estimado").change(function(){
        $("#cita-fecha").val('');
    });
    $('#cita-fecha').focus(function(){
        if(($("#cita-tiempo_estimado").val() == '' || $("#cita-tiempo_estimado").val() == '0') || ($('#procedimientos').val().length == 0) ){
            $.bsAlert("Seleccione un procedimiento, y que el estimado sea mayor que cero");
            $('#procedimientos').focus();
            $("#cita-fecha").val('');
            $("#cita-tiempo_estimado").val('');
        }
    });
    
//    bloquear teclas del widget    
//    $("#cita-fecha").keydown(function(e){ 
//        return false;
//    });

    $('#procedimientos').change(function(){
        sumarTiempo();
        sumarCosto();
        inputsPrecios();
        tipoCitaPorTipoProcedmientos();
    });

    $('#cita-tiempo_estimado').TouchSpin({
        buttondown_class: 'btn btn-secondary',
        buttonup_class: 'btn btn-secondary',
        verticalbuttons: true,
        verticalup: '<i class="la la-plus"></i>',
        verticaldown: '<i class="la la-minus"></i>',
        step: 5,
        max: 600
    });

    $("#pacienteAutocomplete").autocomplete({
        source: function (request, response) {
            $.post(_baseURL + "/utils/pacientes", { text: request.term }, function (json) {
                if (json.Correcto) {
                    response($.map(json.Pacientes, function(p) {
                        var nombreCompleto = p.nombre + ' ' + p.apellido+ ' ' +'('+(p.codigo === null ? 'No definido' : p.codigo)+')';
                        return {
                            label: nombreCompleto,
                            value: nombreCompleto,
                            id: p.id
                        };
                    }));
                }
            }, "json");
            },
        minLength: 1,
        select: function (event, ui) {
            $("#cita-id_paciente").val(ui.item.id);
            $("#pacienteAutocomplete").addClass("cuadro-lleno");
            }
    });
    
    $("#pacienteAutocomplete").click(function () {
        if ($("#pacienteAutocomplete").hasClass("cuadro-lleno")) {
            $("#pacienteAutocomplete").removeClass("cuadro-lleno");
            $("#pacienteAutocomplete").val("");
            $("#cita-id_paciente").val("");
        }
    });
    
    //$('#procedimientos').selectpicker();

    if(tSuscripcion-0 === 0){
        if(tU-0 === 1){
            $("#cita-id_clinica").change(function(){
                $("#procedimientos").val( null );
                habilitarOpcionesProcedimiento();
            });
            habilitarOpcionesProcedimiento();
        }
    }
    
    $("#id_clinica").click(function () {
        const opt = $("#id_clinica").children();
        if ( opt.length === 0) {
            const bool = confirm("Por el momento no cuenta con una clínica a la cual adjudicar un asistente. Por favor, cree una clínica.");
            if ( bool ) {
                window.location.href = _baseURL + "/clinica/create";
            }
        }
    });
    

});


function sumarTiempo(){
    var idsProc = ($('#procedimientos').val() + "").split(',').filter(function (x) { return (x != undefined && x != ""); });
    var totalMinutos = 0;
    $.each(idsProc,function(i,id){
        var horas = parseInt($("#procedimientos option[value='" + id + "']").data("horas"));
        var minutos = parseInt($("#procedimientos option[value=" + id + "]").data("minutos"));
        totalMinutos += (horas * 60) + minutos;
    });
    $("#cita-tiempo_estimado").val(totalMinutos);
}

function sumarCosto(){
    var idsProc = ($('#procedimientos').val() + "").split(',').filter(function (x) { return (x != undefined && x != ""); });
    var totalCosto = 0;
    $.each(idsProc,function(i,id){
        var costo = parseFloat($("#procedimientos option[value='" + id + "']").data("costo"));
        totalCosto +=  costo;
    });
    $("#cita-costo").val(totalCosto);
}

function inputsPrecios(){
    var idsProc = ($('#procedimientos').val() + "").split(',').filter(function (x) { return (x != undefined && x != ""); });
    var costos = [];
    $.each(idsProc,function(i,id){
        var costo = parseFloat($("#procedimientos option[value='" + id + "']").data("costo"));
        costos.push(costo);
    });
    $("#precio-por-procedimiento").val(costos.join(','));
}

function tipoCitaPorTipoProcedmientos(){
    const idsProc = ($('#procedimientos').val() + "").split(',').filter(function (x) { return (x != undefined && x != ""); });
    let totalEnlinea = 0;
    let totalPresencial = 0;
    $.each( idsProc ,(i,id) => {
        let tipoPcr = $("#procedimientos option[value='" + id + "']").data("tipo")-0;
        if( tipoPcr === 1 ){
            totalEnlinea++;
        } else {
            totalPresencial++;
        }
    });
    if( totalPresencial >= totalEnlinea ){
        $('input[name=tipo-cita][value=0]').prop("checked", true);
    } else {
        $('input[name=tipo-cita][value=1]').prop("checked", true);        
    }
    
}

function habilitarOpcionesProcedimiento(){
    var idClinica = $("#cita-id_clinica").val();
    $("#procedimientos option").each(function(){
        var strClinicas = $(this).data("clinica");
        var idsClinicas = (strClinicas + "").split(',');
        if(!idsClinicas.includes(idClinica)){
            $(this).attr("disabled","disabled");
        }
        else{
            $(this).removeAttr("disabled");
        }
    });
    $('#procedimientos').select2('destroy');
    initSelectProcedimientos();
}


function initSelectProcedimientos(){
    $('#procedimientos').select2({
        closeOnSelect: false,
        placeholder: 'Seleccione los procedimientos a aplicar',
        language: {
            noResults: function () {
              return "No existen procedimientos asociados a esta clínica";
            }
        }
    });
}

$('#save-paciente').click( e => {
    e.preventDefault();
    const nombre = $("#paciente-nombre").val().trim();                            
    const apellido = $("#paciente-apellido").val().trim();
    const email = $("#paciente-email").val().trim();
    let cel = $("#paciente-celular").val().trim();
    const celR = $("#paciente-celular").attr('aria-required');
    const emailR = $("#paciente-email").attr('aria-required');
    if( cel !== '' ){
        const prefijo = $('.iti__selected-flag').attr('title').split(':')[1].trim();
        cel = prefijo + cel;
    }
    $("#paciente-celular").val( cel );
    if((emailR === 'true' && email === '') || (celR === 'true' && cel === ''))return;
    const url =  _baseURL + "/paciente/paciente-rapido";
    var data = $('#pacienteModal').serialize();
            $.ajax({
                data:  data,
                url:   url, 
                type:  'post',
                dataType: "json",
                success:  function (response) {
                        $('#pacienteModal')[0].reset();
                        if(response.Correcto){
                            $('#_formModal').modal('toggle');
                            $("#pacienteAutocomplete").val(response.nombre);
                            $("#cita-id_paciente").val(response.id_paciente);
                            $("#pacienteAutocomplete").addClass("cuadro-lleno");
                            return;
                        } 
                        
                },
                error: function(error){
                    $.bsAlert('No se pudo crear el registro, revise los datos ingresados');
                }
        });
});


function valoresComunicacion(){
    if( confComunicacion.includes('sms') ){
        $("#paciente-celular").addClass("campo-activo");
    }
    
    if( confComunicacion.includes('correo') ){
        $("#paciente-email").addClass("campo-activo");
    }
}

$("#cita-id_clinica").click(function(){
    var opt = $("#cita-id_clinica").children();
    if( tSuscripcion-0 === 0 ){
        if( opt.length === 0 ){
          var bool=confirm("Por el momento no cuenta con una clínica a la cual asociar una cita. Por favor, cree una clínica.");
            if(bool){
              window.location.href = _baseURL + "/clinica/create";
            }
        }
    }
});


//$("#cita-fecha").click(function(){
//    validarHorariosExistentes();
//});

$('#cita-fecha').focus( () => {
    $('#cita-fecha').blur();
    validarHorariosExistentes();
});

function validarHorariosExistentes(){
    var horariosArr =  horarios.split(',');
    if(horariosArr.length -1 === 0){
        var bool=confirm("Por el momento no cuenta con horaios para añadir una cita. Por favor, ingrese los horarios de trabajo.");
        if(bool){
          window.location.href = _baseURL + "/horario/index";
        }
    }
}

$('#cita-form').submit(function(){
    var horariosArr =  horarios.split(',');
    var optCli = $("#cita-id_clinica").children();
    var optProc = $("#procedimientos").children();
    var hrefHorarios = true;
    var hrefProce = true;
    //console.log(optCli);
    if(tSuscripcion-0 === 0){
        if(optCli.length === 0 && tU-0 !== 2){
            var bool=confirm("Por el momento no cuenta con una clínica a la cual asociar una cita. Por favor, cree una clínica.");
            if(bool){
              hrefHorarios = false;
              hrefProce = false;
              window.location.href = _baseURL + "/clinica/create";
            }
        }
    }
    if(horariosArr.length -1 == 0 && hrefHorarios){
        var bool=confirm("Por el momento no cuenta con horaios para añadir una cita. Por favor, ingrese los horarios de trabajo.");
        if(bool){
          hrefProce = false;
          window.location.href = _baseURL + "/horario/create";
        }
    }
    if(optProc.length == 0 && hrefProce){
      var bool=confirm("Por el momento no cuenta con procedimientos para asociar a una cita. Por favor, cree al menos un procedimiento.");
        if(bool){
          window.location.href = _baseURL + "/procedimiento/create";
        }
    }
});