/* global _baseURL,  vistaCita, tSuscripcion, tU, horaCita, todayDate, diasNoHabiles */
let guardado = false;
let formatFechaCita = '';
const NO_REPETIR = 0;
const DIARIAMENTE = 1;
const SEMANALMENTE = 2;
const MENSUALMENTE = 3;
const PERSONALIZADO = 4;
const DIAS = {
    0:'Domingo',
    1:'Lunes',
    2:'Martes',
    3:'Miercoles',
    4:'Jueves',
    5:'Viernes', 
    6:'Sabado'
};
const fechaStr = f => `${addCero(f.getUTCDate())}/${addCero(f.getUTCMonth() + 1)}/${f.getUTCFullYear()}`; 
const VALORES_DIARIO = {
    'repeticiones': 30,
    'fechaLimite': (fecha) => {
        const f = new Date(fecha);
        f.setMonth(f.getUTCMonth() + 1);
        return fechaStr(f);
    }
};
const VALORES_SEMANAL = {
    'repeticiones': 8,
    'fechaLimite': (fecha) => {
        const f = new Date(fecha);
        f.setMonth(f.getUTCMonth() + 2);
        return fechaStr(f);
    }
};
const VALORES_MENSUAL = {
    'repeticiones': 12,
    'fechaLimite': (fecha) => {
        const f = new Date(fecha);
        f.setMonth(f.getUTCMonth() + 12);
        return fechaStr(f);
    }
}; 
const CONF_PERIODO = {
    'days' : VALORES_DIARIO,
    'week' : VALORES_SEMANAL,
    'month' : VALORES_MENSUAL
};
(function(){
    validarRepetirCitaDesdeCalendario();

    $('#fecha-limite').datetimepicker({
        startDate: todayDate,
        daysOfWeekDisabled:[],
        keyboardNavigation:true,
        autoclose:true,
        showMeridian:true,
        minView:2,
        language: 'es',
        format:'dd/mm/yyyy',    
        pickTime:false,
    });

    $('#cita-repetircita').change( e => {
        const { value } = e.target;
        if( value-0 === PERSONALIZADO ){
            $('#cita-periodica-modal').modal('show');
            $('#btn-conf-modal').show();
            $('#cita-repetircita').addClass('resize-dropdow');
            valoresPorDefecto();
            selectDiaSemana();
            valoresPorPeriodo('week');
        } else {    
            $('#btn-conf-modal').hide();
            $('#cita-repetircita').removeClass('resize-dropdow');
            guardado = false;
        }
    });

    $('#rango-repeticion').change( e => {
        $('#cita-rango').val( e.target.value );
        calcularFechaDeFin();
    });
    $('#repeticiones').change( e => $('#cita-repeticiones').val( e.target.value ));
    $('input[name="dia-semana"]').change( e => $('#cita-diasemanarepeticion').val( e.target.value ));
    $('#fecha-limite').change( e => $('#cita-fechalimite').val( e.target.value ));
    $('input[name="termina-por"]').change( e => {
        const finalizaPor = e.target.value;
        camposFinalizacionCitaPeriodica( finalizaPor );
        $('#cita-finalizarrepeticionpor').val( finalizaPor );
    });

    $('#periodos-personalizados').change( e => {
        const periodo = e.target.value;
        if( periodo === 'week' ){
            $('#dias-semana-inputs').show();
        } else {
            $('#dias-semana-inputs').hide();
        }
        $('#cita-periodo').val( periodo );
        mensajeFinMes();
        valoresPorPeriodo(periodo);
    });

    $('#guardar-conf-personalizada').click( () => {
        guardado = true;
        $('#cita-periodica-modal').modal('hide');    
    });

    // $('#cita-periodica-modal').on('shown.bs.modal', () => guardado = false );
    $('#cita-periodica-modal').on('hidden.bs.modal', () =>{
        if(!guardado){
            $('#cita-repetircita').val( NO_REPETIR );
            $('#btn-conf-modal').hide();
            $('#cita-repetircita').removeClass('resize-dropdow');
            textoOpcionesRepetirPersonalizado(reset=true);
        } else {
            textoOpcionesRepetirPersonalizado();
        }
    });

    $("#horas").change( () => habilitarRepetirCita());
})();//ready fn
function setFormatoFechaCita(){
    formatFechaCita = $('#cita-fecha').val().split('/').reverse().join('-') || todayDate.split(' ')[0];
}
function valoresPorPeriodo(periodo){
    const { repeticiones, fechaLimite } = CONF_PERIODO[periodo];
    const fechaLimiteConf =  fechaLimite( formatFechaCita );
    $('#repeticiones').val( repeticiones );
    $('#cita-repeticiones').val( repeticiones );
    $('#cita-fechalimite').val( fechaLimiteConf );
    $('#fecha-limite').val( fechaLimiteConf );
}
function valoresPorDefecto(){
    const periodo = $('#periodos-personalizados').val();
    const rango = $('#rango-repeticion').val();
    const repeticiones = $('#repeticiones').val();
    const diaSemana = $('input[name="dia-semana"]:checked').val();
    const finalizaPor = $('input[name="termina-por"]:checked').val();
    $('#cita-periodo').val( periodo );
    $('#cita-rango').val( rango );
    $('#cita-repeticiones').val( repeticiones );
    $('#cita-diasemanarepeticion').val( diaSemana );
    $('#cita-fechalimite').val( $('#fecha-limite').val() );
    $('#cita-finalizarrepeticionpor').val( finalizaPor );
    camposFinalizacionCitaPeriodica(finalizaPor);
}
function camposFinalizacionCitaPeriodica(finalizaPor){
    if( finalizaPor === 'fecha'){
        $('#fecha-limite').attr('disabled', false);
        $('#repeticiones').attr('disabled', true);
    } else {
        $('#fecha-limite').attr('disabled', true);
        $('#repeticiones').attr('disabled', false);
    }
}
function validarCitaPeriodica(){
    const fecha = $('#cita-fecha').val();
    const hora = $('#horas').val();
    const periodo = $('input[name=cita-periodo]:checked').val();
    const minutos = $('#cita-tiempo_estimado').val()-0;
    const rango = $('#cita-rango').val()-0;
    const repeticiones = $('#cita-repeticiones').val()-0;
    if( fecha === '' ){
        $.bsAlert('Debe seleccionar una fecha');
    }
    $.post( _baseURL + '/utils/validar-cita-periodica', 
        { fecha, hora, minutos, periodo, rango, repeticiones }, 
        ({ existeCita, cita })=>{
            if( existeCita ){
                $.bsAlert('Existe una cita para el dia ' + cita.fecha );
            }    
    }, 'json');

}
function habilitarRepetirCita(){
    const hora = $("#horas").val();
    const fecha = $('#cita-fecha').val();
    if((hora !== '' && hora !==null) && fecha !== ''){
        $('#cita-repetircita').attr('disabled', false);
    } else {
        $('#cita-repetircita').attr('disabled', true);
    }
}
function calcularFechaDeFin(){
    const DIA = 1;
    const DIAS_SEMA = 7;
    const PERIODO = $('#periodos-personalizados').val();
    const RANGO = $('#rango-repeticion').val()-0;
    const fechaFin = new Date( formatFechaCita );
    let totalDias = 0;
    if( PERIODO !== 'month' ){
        totalDias = PERIODO === 'days' ? RANGO * DIA : RANGO * DIAS_SEMA;
        fechaFin.setDate(fechaFin.getDate() + totalDias);
    } else {
        fechaFin.setMonth(fechaFin.getMonth() + RANGO);
    } 
    mensajeFinMes(PERIODO,RANGO,fechaFin.getUTCDate());
    const formatoFechaFin = [
        addCero(fechaFin.getUTCDate()),
        addCero(fechaFin.getMonth() + 1),
        fechaFin.getFullYear()
    ].join('/');
    $('#fecha-limite').val( formatoFechaFin );
    textoOpcionesRepetirCita();
}
function selectDiaSemana(){
    const diaPorFecha = new Date( formatFechaCita ).getUTCDay();
    const dias = $('input[name="dia-semana"]');
    dias.filter(`[value=${diaPorFecha}]`).attr('checked', true);
}
function mensajeFinMes(periodoCita,rangoCita,dia){
    const periodo = periodoCita || $('#periodos-personalizados').val();
    const rango = rangoCita || $('#rango-repeticion').val()-0;
    const diaPorFecha = dia || new Date( formatFechaCita ).getUTCDate();
    if( periodo === 'month' && rango === 1 && diaPorFecha === 31 ){
        $('#mensaje-mes').show();
        $('#mensaje-texto').html( `Repetición en el día ${dia} del mes`);
    } else {
        $('#mensaje-mes').hide();
    }
}
function fechaInicioRepeticionesTimePicker(){
    $('#fecha-limite').datetimepicker('setStartDate', formatFechaCita ); 
}
function textoOpcionesRepetirCita(){
    const fechaCita = new Date( formatFechaCita );
    const diaPorFecha = fechaCita.getUTCDate();
    const diaSemana = DIAS[fechaCita.getUTCDay()];
    $('#cita-repetircita option[value="'+SEMANALMENTE+'"]').text(`Semanal en ${diaSemana} por un mes`);
    $('#cita-repetircita option[value="'+MENSUALMENTE+'"]').text(`Mensual por un año los ${diaPorFecha} de mes`);
}
function setFechaFinDiario(){
    const f = new Date( formatFechaCita );
    f.setDate(f.getUTCDate() + 1);
    return [
        addCero(f.getUTCDate()),
        addCero(f.getMonth() + 1),
        f.getFullYear()
    ].join('/');
}
function textoOpcionesRepetirPersonalizado(reset=false){
    const labelPeriodos = {
        'days': 'día-días',
        'week':'semana-semanas',
        'month': 'mes-meses'
    };
    if( reset ){
        $('#cita-repetircita option[value="'+PERSONALIZADO+'"]').text( 'Personalizado' );
        return;
    }
    const periodo = $('#periodos-personalizados').val();
    const rango = $('#rango-repeticion').val()-0;
    const fechaLimite = $('#fecha-limite').val();
    const terminaPor = $('input[name="termina-por"]:checked').val();
    const repeticiones = $('#cita-repeticiones').val()-0;
    const labels = labelPeriodos[periodo];
    const [ periodoSingular, periodoPrural ] = labels.split('-');
    const textoPeriodo = rango > 1 ? periodoPrural : periodoSingular;
    const textoRango = rango > 1 ? rango : '';
    let textoPersonalizado; 
    terminaPor === 'fecha'
    ? textoPersonalizado = `Cada ${ textoRango } ${ textoPeriodo } hasta el ${ fechaLimite }`
    : textoPersonalizado = `Cada ${ textoRango } ${ textoPeriodo }, ${ repeticiones } repeticiones`;
    $('#cita-repetircita option[value="'+PERSONALIZADO+'"]').text( textoPersonalizado );
}
function validarRepetirCitaDesdeCalendario(){
    if( fechaCita !== '' && horaCita !== '' ){
        setFormatoFechaCita();
        textoOpcionesRepetirCita();
        fechaInicioRepeticionesTimePicker();
        $('#cita-repetircita').attr('disabled', false);
    }
}