/* global _baseURL */
$('#procedimientos').select2({
    closeOnSelect: false,
    placeholder: 'Seleccione los procedimientos a aplicar'
});
    

var _SOURCE_VOID_ = [];

var rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi;
jQuery.htmlPrefilter = function( html ) {
    return html.replace( rxhtmlTag, "<$1></$2>" );
};


$(document).ready(function(){    
    $('#procedimientos').on('select2:select', function (e) {
        $(".select2-search__field").val('');
    });
    
    var SOURCE = [
        {
            url: _baseURL + '/calendario/citas',
            method:'post'
        },
        {
            url: _baseURL + '/calendario/eventos',
            method:'post'
        },
        {
            url: _baseURL + '/calendario/seguimientos',
            method:'post'
        },
        {
            url: _baseURL + '/calendario/recordatorios',
            method:'post'
        }
    ];
    
    _SOURCE_VOID_ = [...SOURCE];
    initCalendar( SOURCE );
    
    
    $('.calendario-field').click( () => {
        const OLIVIA = $('#olivia-field')[0].checked;
        const WEB = $('#web-field')[0].checked;
        var SOURCE_DEF = [];
        if( OLIVIA && WEB ){
            const WEB_ITEM = {
                    url: _baseURL + '/calendario/citas-web',
                    method:'post'
                };
            SOURCE_DEF = [...SOURCE,WEB_ITEM];
        } else if( !OLIVIA && WEB ){
            SOURCE_DEF = [
                {
                    url: _baseURL + '/calendario/citas-web',
                    method:'post'
                }
            ];
        } else if( OLIVIA && !WEB ){
            SOURCE_DEF = [...SOURCE]; 
        } else {
            SOURCE_DEF = [...SOURCE]; 
        }
        $('#calendario-medico').fullCalendar('destroy');
        initCalendar( SOURCE_DEF );
    });
 
});

function initCalendarVoidParams(){
    $('#calendario-medico').fullCalendar('destroy');
    $('#web-field').prop( 'checked', false );
    initCalendar( _SOURCE_VOID_ );
}

function initCalendar( SOURCE ){
var rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi;
jQuery.htmlPrefilter = function( html ) {
    return html.replace( rxhtmlTag, "<$1></$2>" );
};

    $('#calendario-medico').fullCalendar({
        locale: 'es',
        eventLimit: true,
        defaultView: 'agendaWeek',
        scrollTime : "07:00:00",
        allDayDefault: false,
        lazyFetchin:false,
        selectable: true,
        nowIndicator: true,
        editable: true,
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listWeek'
        },
        eventRender: function(eventObj, $el){
		eventObj.resourceId = new Date().getTime();
            $el.attr('data-html', true);
            const textColor = ([timeDiv, titleDiv], color) => {
                timeDiv.style.color = color;
                titleDiv.style.color = color;
            };
            const bordeIdentif = ((eventObj.type === 'cita' || eventObj.type === 'solicitud') && eventObj.esPresencial )
            ? { borderBottom : 'solid 4px #343A65', marginBottom: '10px' } 
            : { borderBottom : 'solid 4px #D4D8F7', marginBottom: '10px' };
            eventObj.type === 'solicitud' && textColor($el.children().children(), eventObj.borderColor);
            $el.css({ border: 'solid 1px' + eventObj.borderColor });
            ( eventObj.type === 'cita' || eventObj.type === 'solicitud' ) && $el.css( bordeIdentif );
            if( (eventObj.type === 'cita' || eventObj.type === 'solicitud' || eventObj.type === 'recordatorio' ) && eventObj.tooltip ){
                var cuerpo = '';
                var titulo = '';
                if((eventObj.type === 'cita' || eventObj.type === 'solicitud' ) && eventObj.tooltip ){
                    titulo = eventObj.type === 'cita' ? 'Cita con '+eventObj.title : 'Solicitud de cita con '+eventObj.title;
                    cuerpo = '<strong>Paciente:</strong> '+eventObj.title +'<br/>'+
                             '<strong>Teléfono:</strong> '+eventObj.cel +'<br/>'+
                             '<strong>Email:</strong> '+eventObj.email+'<br/>'+
                             '<strong>Asunto:</strong> '+eventObj.description+'<br/>'+
                             '<strong>Tipo de cita:</strong> '+( eventObj.esPresencial ? 'Presencial' : 'En linea' )+'<br/>'+
                             '<strong>Procedimientos:</strong> '+eventObj.procedimientos;
                } else {
                    titulo = eventObj.title;
                    if(eventObj.type === 'recordatorio' && eventObj.paciente !== 'No definido'){
                        cuerpo = '<strong>Titulo:</strong> ' + eventObj.title + '<br/>'+   
                                 '<strong>Nombre:</strong> ' + eventObj.paciente + '<br/>'+
                                 '<strong>Teléfono:</strong> ' + eventObj.cel + '<br/>'+
                                 '<strong>Email:</strong> ' + eventObj.email;
                    } else {
                        cuerpo = '<strong>Titulo:</strong> ' + eventObj.title;
                    }
                }
                $el.popover({
                    title: titulo,
                    content: cuerpo,
                    trigger: 'hover',
                    placement: 'top',
                    container: 'body'
                });
            }
        },
        eventSources: SOURCE,
        eventClick: function( event ) {
            if( event.type === 'solicitud' ){
                viewSolicitud( event.id );
            } else {
                if ( event.url ) {
                    window.location.href = event.url;
                    return false;
                }
            }
        },
        dateClick: function(info){
            $('#_procsCita').modal('toggle');
            $('#continuar').click( () => seleccionarProcsCitaCalendario(info) );
        },
        select: function(info){
            $('#_procsCita').modal('toggle');
            $('#continuar').click( () => seleccionarProcsCitaCalendario(info) );
        }
    });

}

function seleccionarProcsCitaCalendario(info){
    if($('#procedimientos').val().length === 0){
        $.bsAlert('Debe seleccionar al menos un procedimiento');
        return;
    }
    const f = info._i;
    const procs = $('#procedimientos').val().join(',');
    location.href = _baseURL + '/cita/create?fc=' + f + '?' + procs;
}
