<?php

use app\customs\SesionUtils;

/* @var $this \yii\web\View */
/* @var $clinica app\models\Clinica */
/* @var $clinicas app\models\Clinica[] */

$clinica = SesionUtils::ClinicaSeleccionada();
$clinicas = SesionUtils::ClinicasUsuario();
?>

<div class="kt-subheader__toolbar">
    <div class="kt-subheader__wrapper">
        <a id="usuario-clinica-seleccionada" data-idseleccionado="<?= $clinica->id?>" href="#" class="btn kt-subheader__btn-daterange" 
           id="kt_dashboard_daterangepicker" data-toggle="kt-tooltip" 
           title="" data-placement="left" 
           data-original-title="<?=strlen($clinica->nombre) > 20 ? 'Suscripción seleccionada: '.$clinica->nombre : 'Suscripción seleccionada'?>">
            <span class="kt-subheader__btn-daterange-title" id="kt_dashboard_daterangepicker_title">
                Dr(a). <?= $clinica->suscripcion->usuario->perfil->nombreCorto?>:
            </span>&nbsp;
            <?php if(strlen($clinica->nombre) > 20 ){ $clinica_substr = substr($clinica->nombre, 0,20);?>
            <span class="kt-subheader__btn-daterange-date" id="kt_dashboard_daterangepicker_date" data-toggle="kt-tooltip" title="" data-placement="down" data-original-title="<?=$clinica->nombre?>">
                    <?= $clinica_substr.'...'?>
            </span>
            <?php } else {?>
                <span class="kt-subheader__btn-daterange-date" id="kt_dashboard_daterangepicker_date">
                    <?= $clinica->nombre?>
                </span>
            <?php }?>
        </a>
        <?php if(count($clinicas) > 1){ ?>
        <div class="dropdown dropdown-inline" data-toggle="kt-tooltip" title="" data-placement="left" data-original-title="Cambiar de suscripción">
            <a href="#" class="btn btn-icon kt-badge kt-badge--unified-primary kt-badge--rounded" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="flaticon-more"></i>
            </a>
            
            <div class="dropdown-menu dropdown-menu-fit dropdown-menu-md dropdown-menu-right">
                <!--begin::Nav-->
                <ul class="kt-nav">
                    <li class="kt-nav__head">
                        Suscripciones:                                    
                        <i class="flaticon2-correct kt-font-success" data-toggle="kt-tooltip" data-placement="right" title="" data-original-title="Click to learn more..."></i>
                    </li>
                    <li class="kt-nav__separator"></li>
                    <?php foreach($clinicas as $cli){ ?>
                    <li class="kt-nav__item">
                        <a href="#" class="kt-nav__link" onclick="_seleccionarClinica(<?= $cli->id ?>)">
                            <i class="kt-nav__link-icon flaticon-arrows"></i>
                            <span class="kt-nav__link-text">Dr(a). <?= $cli->suscripcion->usuario->perfil->nombreCorto?></span>
                        </a>
                    </li>
                    <?php } ?>
                </ul>
                <!--end::Nav-->
            </div>
        </div>
        <?php } ?>
    </div>
</div>