<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use app\models\Usuario;

/* @var $this yii\web\View */
/* @var $model app\models\Usuario */
/* @var $form yii\widgets\ActiveForm */


$model  = Yii::$app->user->identity;
$nombres = $model->perfil->nombre;
$apellido = $model->perfil->apellidos;
$email = $model->perfil->email;
$telefono = $model->perfil->telefonos;
$fL = substr($nombres, 0,1);

$this->title = 'Perfil del usuario';
$this->params['breadcrumbs'][] = $this->title;

?>
            <!-- begin:: Content -->
<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">

    <!--Begin::Section-->
    <div class="row">
        <div class="col-xl-12">

            <!--begin:: Widgets/Applications/User/Profile3-->
            <div class="kt-portlet kt-portlet--height-fluid">
                <div class="kt-portlet__body">
                    <div class="kt-widget kt-widget--user-profile-3">
                        <div class="kt-widget__top">
                            <div class="kt-widget__media kt-hidden-">
                                <i class="fa fa-user-circle fa-5x" ></i>
                            </div>
                          
                            <div class="kt-widget__content">
                                <div class="kt-widget__head">
                                    <a href="#" class="kt-widget__username">
                                        <?= $nombres . " " . $apellido ?>
                                       
                                    </a>
                                    <div class="kt-widget__action">
                                      
                                        <a href="<?= Url::to(['perfil/editar-perfil']) ?>"><button type="button" class="btn btn-primary">Actualizar</button> </a>

                                    </div>
                                </div>
                                <!--div class="kt-widget__subhead">
                                    <a href="#"><i class="flaticon2-correct"></i>Cirujano dentista</a>
                                  
                                </div-->
                                <?php if($model->tipo == Usuario::DOCTOR):?>
                                <div class="kt-widget__info">
                                  
                                    <div class="kt-widget__progress">
                                        <div class="kt-widget__text">
                                           <i class="fa fa-smile"></i>
                                        </div>
                                      
                                        <div class="kt-widget__stats">
                                             <?php
                                            $count=0;
                                            $sumador=0;
                                            foreach ($feedback as $feed ){
                                                    $count++;
                                                    $sumador+=$feed->puntuacion;
                                            }
                                            echo $count == 0 ? 0 : round(($sumador/$count)*(10/3),2);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif;?>
                            </div>
                        </div>

                         <div class="row">
                                      
                             <div class="col-lg-6" >
                                        <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>

                                 <div class="kt-widget1 kt-widget1--fit">
                                    <div class="kt-widget1__item">
                                        <div class="kt-widget1__info">
                                            <h3 class="kt-widget1__title">Clínicas</h3>
                                            <?php if($model->tipo == Usuario::DOCTOR){ 
                                                foreach ($clinicas as $clinica) { ?>
                                                    <span class="kt-widget1__desc" > <?= $clinica->nombre ?></span>
                                                    <br>
                                            <?php }/*foreach*/} else { ?>
                                                <span class="kt-widget1__desc" > <?= $clinicas->nombre ?></span>
                                                <br>
                                            <?php }?>
                                        </div>
                                       
                                    </div>
                                    <?php if($model->tipo == Usuario::DOCTOR):?> 
                                    <div class="kt-widget1__item">
                                        <div class="kt-widget1__info">
                                            <h3 class="kt-widget1__title">Asistentes asignados</h3>
                                             <?php foreach ($asistentes as $asistente) { ?>
                                           <span class="kt-widget1__desc" > <?= $asistente->usuario->perfil->nombre." ".$asistente->usuario->perfil->apellidos ?></span>
                                            <br>
                                           <?php } ?>
                                        </div>
                                    </div>
                                    <?php endif;?> 
                                </div>
                            </div>
                            <div class="col-lg-6" >
                                  <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                 <div class="kt-widget1 kt-widget1--fit">
                                    <div class="kt-widget1__item">
                                        <div class="kt-widget1__info">
                                            <h3 class="kt-widget1__title">Email</h3>
                                            <span class="kt-widget1__desc"><?=$email?></span>
                                        </div>
                                        
                                    </div>
                                    <div class="kt-widget1__item">
                                        <div class="kt-widget1__info">
                                            <h3 class="kt-widget1__title">Teléfono</h3>
                                            <span class="kt-widget1__desc"><?=$telefono?></span>
                                        </div>
                                       
                                    </div>
                                    <div class="kt-widget1__item">
                                        <div class="kt-widget1__info">
                                            <h3 class="kt-widget1__title">País</h3>
                                            <span class="kt-widget1__desc">El Salvador</span>
                                        </div>
                                        
                                    </div>
                                    <div class="kt-widget1__item">
                                        <div class="kt-widget1__info">
                                            <h3 class="kt-widget1__title">Pacientes registrados</h3>
                                             <?php 
                                            $count=0;
                                            foreach ($pacientes as $paciente) { 
                                                $count++;
                                            }
                                            ?>
                                             <span class="kt-widget1__desc"><?=$count?></span>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if($model->tipo == Usuario::DOCTOR):?>
                            <hr>
                            <div class="row mt-4">
                                <div class="col-md-6 offset-6" >
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Firma</h3>
                                                <p class="mt-2">
                                                    <?= Html::a($labelFirma, ['firma-medico/create'], ['class' => 'btn btn-primary']) ?>
                                                    <?= $firma != null ?  Html::a('Eliminar', ['firma-medico/delete', 'id' => $firma->id], [
                                                        'class' => 'btn btn-danger',
                                                        'data' => [
                                                            'confirm' => '¿Está seguro de eliminar este elemento?',
                                                            'method' => 'post',
                                                        ],
                                                    ]) : ''     ?>
                                                </p>
                                                <span class="kt-widget1__desc">
                                                    <?= $firma == null   ? 'No definida' : 
                                                        '<img src="'.$firma->srcFirma.'" class="firma-medico" alt="Firma">' ?>
                                                </span>
                                                <br>
                                            </div>
                                        </div>
                                    </div>
                                </div>    
                            </div>
                        <?php endif;?> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>