<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;


/* @var $this yii\web\View */
/* @var $model app\models\Usuario */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'Cambiar contraseña';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="col-md-12 kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="box box-primary kt-portlet__body">
        <div class="box-body">
            <div class="usuario-form">

                <?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form kt-form--label-right']]); ?>

                <?= $form->field($model, 'nombre_usuario')->label('Usuario')->textInput(['readonly' => true]) ?>
                <?= $form->field($model, 'oldPassword')->label("Password anterior")->passwordInput() ?>
                <?= $form->field($model, 'password')->label("Nuevo password")->passwordInput() ?>
                <?= $form->field($model, 'passwordConfirm')->label('Confirmación del password <span style="color:red;"> *</span>')->passwordInput() ?>
                <div class="form-group">
                    <?= Html::submitButton('Guardar', ['class' => 'btn btn-primary']) ?>
                </div>

                <?php ActiveForm::end(); ?>

            </div>
        </div>
    </div>
</div>