<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\UsuarioAsset;

/* @var $this yii\web\View */
/* @var $model app\models\Usuario */
/* @var $form yii\widgets\ActiveForm */
$tipo = [0 => 'Administrador', 1 => 'Doctor', 2 => 'Asistente'];
UsuarioAsset::register($this)
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form kt-form--label-right']]); ?>
    <div class="usuario-form kt-portlet__body">
        <input type="hidden" id="isnr" value="<?= $model->isNewRecord?>">
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($perfil, 'nombre')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($perfil, 'apellidos')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($perfil, 'email')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($perfil, 'telefonos')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="kt-separator kt-separator--border-dashed kt-separator--space-lg kt-separator--portlet-fit"></div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'nombre_usuario')->textInput(['maxlength' => true,'readonly' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'password')->passwordInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'passwordConfirm')->label('Confirmación del password <span style="color:red;"> *</span>')->passwordInput() ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'tipo')->radioList($tipo,['class' => 'kt-radio-inline']) ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($model, 'id_rol')->dropDownList($roles) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'activo')->checkbox() ?>
            </div>
        </div>
    </div>
    <div class="kt-portlet__foot">
        <div class="kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>