<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Suscripcion */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Suscripcions', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="suscripcion-view kt-portlet">
<div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <p>
            <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Cambiar Plan y Cupon', ['cambiar-plan', 'id' => $model->id], ['class' => 'btn btn-success']) ?>
            <?= Html::a('Eliminar', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => '¿Está seguro de eliminar este elemento?',
                    'method' => 'post',
                ],
            ]) ?>
        </p>

        <?= DetailView::widget([
            'model' => $model,
            'attributes' => [
                'id',
            'id_usuario',
            'fecha_inicio',
            'id_plan',
            'activa:boolean',
            'telefono_notificacion',
            'email:email',
            'fecha_cancelacion',
            ],
        ]) ?>

    </div>
</div>
