<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Suscripciones';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="suscripcion-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <p>
            <?= Html::a('Crear Suscripción', ['create'], ['class' => 'btn btn-success']) ?>
        </p>

        
            <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'emptyText' => 'No se encontraron registros a mostrar.',
            'columns' => [
                'id',
                'usuario.nombre_usuario',
                'fecha_inicio:date',
                'etiquetaTipo',
                'plan.nombre',
                'activa:boolean',
                ['class' => 'app\customs\ActionColumn'],
            ],
        ]); ?>
    
    
    </div>
</div>
