<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\SuscripionAsset;
/* @var $this yii\web\View */
/* @var $model app\models\Suscripcion */
/* @var $form yii\widgets\ActiveForm */

SuscripionAsset::register($this);

$model->fecha_inicio = $model->isNewRecord ? $model->fecha_inicio :  date("d/m/Y",strtotime($model->fecha_inicio));
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="suscripcion-form kt-portlet__body">
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'fecha_inicio')->textInput(['readonly'=>true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'id_plan')->dropDownList($planes) ?>
            </div>
            <div class="col-lg-4">
               <?= $form->field($model, 'id_usuario')->dropDownList($usuarios,['prompt' => ' - Seleccione un usuario -', 'disabled'=>true]) ?> 
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'readonly'=>true]) ?>
            </div>
            <div class="col-lg-4">
                <label>Cupones</label>
                <?= Html::dropDownList('id_cupon', null,$cupones,['class'=>'form-control', 'prompt' => ' - Seleccione un cupon -', 'options'=>[$cuponSelected=>['selected'=>true]]]) ?>
            </div>
        </div>
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>