<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\SuscripionAsset;
use app\models\Suscripcion;
/* @var $this yii\web\View */
/* @var $model app\models\Suscripcion */
/* @var $form yii\widgets\ActiveForm */


SuscripionAsset::register($this);

$this->registerCss("
    #select2-suscripcion-id_pais-container{
        padding-left: 8px !important;
        padding-right: 20px !important;
        padding-top: inherit !important;
        padding-bottom: inherit !important;
    }
    ");
$this->registerJs('$(document).ready(function(){
        $("#suscripcion-id_pais").select2();
    });', yii\web\View::POS_READY);

$model->fecha_inicio = $model->isNewRecord ? $model->fecha_inicio :  date("d/m/Y",strtotime($model->fecha_inicio));
$dropdowOpt = $model->isNewRecord ? [] : ['disabled'=>true];
?>
<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="suscripcion-form kt-portlet__body">
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'fecha_inicio')->textInput() ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'id_plan')->dropDownList($planes,$dropdowOpt) ?>
            </div>
            <div class="col-lg-4">
               <?= $form->field($model, 'id_usuario')->dropDownList($usuarios,['prompt' => ' - Seleccione un usuario -']) ?> 
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'telefono_notificacion')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'fecha_cancelacion')->textInput() ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'tipo')->dropDownList(Suscripcion::$TIPOS) ?>
            </div>
        </div>
        <?php if($model->isNewRecord){?>
        <div class="row">
            <div class="col-lg-4">
                <label>Cupones</label>
                <?= Html::dropDownList('id_cupon', null,$cupones,['class'=>'form-control', 'prompt' => ' - Seleccione un cupon -']) ?>
            </div>
        </div>
        <?php }?>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'id_pais')->dropDownList($paises) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 mt-3">
                <?= $form->field($model, 'activa')->checkbox() ?>
            </div>
            <div class="col-lg-4 mt-3">
                <?= $form->field($model, 'stripe_activo')->checkbox() ?>
            </div>
        </div>

    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>