<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use app\customs\StripeUtils;

/* @var $this yii\web\View */
/* @var $model app\models\FormaPago */
/* @var $subscription \Stripe\Subscription */
/* @var $customer \Stripe\Customer */
/* @var $invoices[] \Stripe\Invoice */

$this->title = $model->nombreUsuario;
$this->params['breadcrumbs'][] = ['label' => 'Stripe', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="forma-pago-view kt-portlet">
<div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        
        <p>
            <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Eliminar', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => '¿Está seguro de eliminar este cliente?',
                    'method' => 'post',
                ],
            ]) ?>
            <?= Html::a('Desuscribir', ['desuscribir', 'id' => $model->id], [
                'class' => 'btn btn-warning',
                'data' => [
                    'confirm' => '¿Está seguro de desuscribir este cliente?',
                    'method' => 'post',
                ],
            ]) ?>
        </p>
        <ul class="nav nav-tabs">
          <li class="nav-item active"><a class="nav-link active" data-toggle="tab" href="#home">Info</a></li>
          <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#subscription">Suscripcion</a></li>
          <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#customer">Cliente</a></li>
          <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#invoices">Facturas</a></li>
        </ul>

        <div class="tab-content">
          <div id="home" class="tab-pane active">
            <h3>Info</h3>
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'id',
                'customer_id',
                'created',
                'currency',
                'invoice_prefix',
                'description',
                'pay_method',
                'subcription_id',
                ],
            ]) ?>
          </div>
          <div id="subscription" class="tab-pane">
            <h3>Suscripción</h3>
            <?php if($subscription != null) { ?>
            <table id="w1" class="table table-striped table-bordered detail-view">
                <tbody>
                    <tr><th>Estado: </th><td><?= StripeUtils::EstadoLabel($subscription->status) ?></td></tr>
                    <tr><th>Período actual inicio</th><td><?= date('d/m/Y',$subscription->current_period_start) ?></td></tr>
                    <tr><th>Período actual fin</th><td><?= date('d/m/Y',$subscription->current_period_end) ?></td></tr>
                    <tr><th>Dias hasta vencimiento</th><td><?= $subscription->days_until_due ?></td></tr>
                    <tr><th>Ultima factura</th><td><?= $subscription->latest_invoice ?></td></tr>
                </tbody>
            </table>
            <?php } else { ?>
                <div class="alert alert-outline-warning fade show" role="alert">
                    <div class="alert-icon"><i class="flaticon-warning"></i></div>
                    <div class="alert-text"><?= $mensaje_suscripcion?></div>
                    <div class="alert-close">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true"><i class="la la-close"></i></span>
                        </button>
                    </div>
                </div>
            <?php } ?>
          </div>
          <div id="customer" class="tab-pane">
            <h3>Cliente</h3>
            <?php if($customer != null) { ?>
            <table id="w1" class="table table-striped table-bordered detail-view">
                <tbody>
                    <tr><th>Creado</th><td><?= date('d/m/Y',$customer->created) ?></td></tr>
                    <tr><th>Created</th><td><?= $customer->name?></td></tr>
                    <tr><th>E-Mail</th><td><?= $customer->email ?></td></tr>
                    <tr><th>Descripción</th><td><?= $customer->description ?></td></tr>
                    <tr><th>Balance</th><td><?= $customer->balance ?></td></tr>
                </tbody>
            </table>
            <?php } else { ?>
                <div class="alert alert-outline-warning fade show" role="alert">
                    <div class="alert-icon"><i class="flaticon-warning"></i></div>
                    <div class="alert-text"><?= $mensaje_cliente?></div>
                    <div class="alert-close">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true"><i class="la la-close"></i></span>
                        </button>
                    </div>
                </div>
            <?php } ?>
          </div>
          <div id="invoices" class="tab-pane">
            <h3>Facturas</h3>
            <?php if($invoices != null) { ?>
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Periodo</th>
                            <th>N° Referencia</th>
                            <th>Estado</th>
                            <th>Descripcion</th>
                            <th>Monto</th>
                            <th>Detalles</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($invoices as $invoice){ ?>
                        <tr>
                            <td><?= date('d/m/Y',$invoice->period_start) ?> - <?= date('d/m/Y',$invoice->period_end) ?></td>                            
                            <td><?= $invoice->number ?></td>
                            <td><?= $invoice->status ?></td>
                            <td><?= $invoice->description ?></td>
                            <td><?= $invoice->total?></td>
                            <td><a target="_blank" href="<?= $invoice->hosted_invoice_url?>"><i class="fas fa-eye" style="font-size: 2rem;"></i></a></td>
                        </tr>    
                    <?php } ?>
                    <tbody>        
                </table>
            <?php } else { ?>
                <div class="alert alert-outline-warning fade show" role="alert">
                    <div class="alert-icon"><i class="flaticon-warning"></i></div>
                    <div class="alert-text"><?= $mensaje_facturas?></div>
                    <div class="alert-close">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true"><i class="la la-close"></i></span>
                        </button>
                    </div>
                </div>
            <?php } ?>
          </div>
        </div>
        

    </div>
</div>
