<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;
use app\assets\SeguimientoAsset;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $usuario app\models\Usuario */

SeguimientoAsset::register($this);
$usuario = Yii::$app->user->identity;
$this->title = 'Seguimientos';
$this->params['breadcrumbs'][] = $this->title;
?>
<style>
    .trpointer{
        cursor:pointer !important;
    }
    
    .no-visible{
        opacity: 0;
    }
    
    .scrolly{
        overflow-y: scroll;
    }
</style>
<div class="seguimiento-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p class="mt-3">
        <button class="btn btn-success" id="crear-seguimiento">Crear Seguimiento</button>
        </p>
    </div>
    <div class="kt-portlet__body">

        <ul class="nav nav-tabs  nav-tabs-line nav-tabs-line-success" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" style="font-size: 16px;" data-toggle="tab" href="#seguimientos" role="tab" aria-selected="true"><i class="flaticon-calendar-with-a-clock-time-tools"></i>Seguimientos</a>
            </li>
            <li class="nav-item"></li>
            <li class="nav-item"></li>
            <li class="nav-item">
                <a class="nav-link" style="font-size: 16px;" data-toggle="tab" href="#asistencias" role="tab" aria-selected="false"><i class="flaticon-calendar-3"></i>Marcar Asistencia</a>
            </li>
        </ul>                        
        <div class="tab-content">
            <div class="tab-pane active" id="seguimientos" role="tabpanel">
                <div class="table-responsive">
                    <div id="w1" class="grid-view">    
                        <table class="table table-hover" id="seguimientos-t">
                            <thead>
                                <tr>
                                    <th>Código</th>
                                    <th>Paciente</th>
                                    <th>Fecha de Seguimiento</th>
                                    <th>Motivo</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                
                            </tbody>        
                        </table>
                    </div>
                </div>    
            </div>
            <div class="tab-pane" id="asistencias" role="tabpanel">
                <div class="table-responsive">
                    <div id="w2" class="grid-view">    
                        <table class="table table-hover" id="citas-asistencia-t">
                            <thead>
                                <tr>
                                    <th>Código</th>
                                    <th>Paciente</th>
                                    <th>Fecha de Cita</th>
                                    <th>¿Asistió a su Cita?</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>        
                        </table>
                    </div>        
                </div> 
            </div>
        </div>      
    </div>
</div>

<div id="seguimientosModal" class="modal-seg">
  <div class="modal-contenido">
      <div class="modal-head">
        <h4 class="title-mod" id="segTitulo"></h4> 
        <span id="closeModalSeg" class="close">&times;</span>
      </div>
    <div id="segCuerpo"></div>
  </div>
</div> 

<div id="_ViewSeg" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content" id="_ViewSegCont">
            <div class="modal-header">
                <h4 class="modal-title" id="_ViewSegTitle"></h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="_ViewSegBody">
                
            </div>
            <div class="modal-footer" id="_ViewSegFoot">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="_segMod" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="_segTitle"></h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="_segBody">
                
            </div>
            <div class="modal-footer" id="_segFoot">
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

