<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\MaskedInput; 
use app\assets\ReporteFeedBackAsset;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $feed app\models\Feedback */

ReporteFeedBackAsset::register($this);
$usuario = Yii::$app->user->identity;
$idSuscripcion = $usuario->suscripcion->id;
$this->title = 'Retroalimentaciones';
$this->params['breadcrumbs'][] = $this->title;
$periodo = \Yii::$app->request->get('periodo');
$seleccionado = isset($periodo) ? ($periodo) : "week";
$btnClass = "btn btn-lg btn-primary";
?>
<div class="kt-portlet__body">
    <div class="row text-right">
        <div class="offset-8 col-md-4">
            <div class="dropdown">
                <button class="btn btn-success dropdown-toggle" type="button" id="filtros" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Filtrar
                </button>
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="filtros" style="">
                    <?= Html::a('Semana', ['reportes/retroalimentacion','periodo'=>'week'], [
                        'class' => 'dropdown-item',
                        'method' => 'get',
                    ]) ?>
                    <?= Html::a('Mes', ['reportes/retroalimentacion','periodo'=>'month'], [
                        'class' => 'dropdown-item',
                        'method' => 'get',
                    ]) ?>
                    <?= Html::a('Trimestral', ['reportes/retroalimentacion','periodo'=>'trimester'], [
                        'class' => 'dropdown-item',
                        'method' => 'get',
                    ]) ?>
                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#rango-fechas">Personalizado</a>
                </div>
            </div>
        </div>    
    </div>
    <div class="row text-right">
        <div class="offset-8 col-md-4">
            <span id="badge-periodo" style="font-size: 14px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded mt-3"><?=$label?></span>
        </div>    
    </div>
    <div class="row">
        <div class="m-4"></div>
    </div>

</div>
<div class="row">
   <div class="col-lg-4">
        <div class="kt-portlet kt-portlet--bordered-semi kt-portlet--height-fluid">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                           Calificación Promedio
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                     <H1>
                       <?=round($calificacion_promedio,2)?>
                     </H1>
            </div>
        </div>
    </div> 
    <div class="col-lg-4">
                <div class="kt-portlet kt-portlet--bordered-semi kt-portlet--height-fluid">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        # de Retroalimentaciones
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                     <H1>
                       <?=$totalFeedbacks?>
                    </H1>  
            </div>
        </div>
    </div>
        <div class="col-lg-4">
             <div class="kt-portlet kt-portlet--bordered-semi kt-portlet--height-fluid">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                            Tasa de respuesta
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                     <H1>
                      <?=round(($porcentaje_respuesta)*100)."%"?>
                    </H1> 
            </div>
        </div>
    </div>
</div>
<div class="row" style="background-color: white; ">
   <!--begin::Portlet-->
    <div class="kt-portlet" style="box-shadow: none;">
     
        <div class="kt-portlet__body">
           <ul class="nav nav-pills nav-fill" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" data-toggle="tab" href="#kt_tabs_1_1">
                       <img src='<?php echo $this->theme->baseUrl; ?>/assets/media/icons/Smiling.svg' id="smiling" width="20">
                         <span style="margin-left: 15px;">
                        <?php
                        $count=0;
                        foreach ($cita_calificacion as $feed ){
                            if( $feed->puntuacion == 3) {
                                $count++;
                            }
                        }
                        echo $count;
                        ?>
                        </span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link " data-toggle="tab" href="#kt_tabs_1_2">
                        <img  src="<?php echo $this->theme->baseUrl; ?>/assets/media/icons/Expresionless.svg"  width="20">

                        <span style="margin-left: 15px;">  
                        <?php
                        $count=0;
                        foreach ($cita_calificacion as $feed ){
                            if( $feed->puntuacion == 2) {
                                $count++;
                            }
                        }
                        echo $count;
                        ?>
                        </span>
                    </a>
                </li>
            <li class="nav-item">
                    <a class="nav-link" data-toggle="tab" href="#kt_tabs_1_3"> 
                        <img  src="<?php echo $this->theme->baseUrl; ?>/assets/media/icons/Sad.svg"  width="20">
                        <span style="margin-left: 15px;">  
                        <?php
                        $count=0;
                        foreach ($cita_calificacion as $feed ){
                            if( $feed->puntuacion == 1) {
                                $count++;
                            }
                        }
                        echo $count;
                        ?>
                         </span>
                     </a>
                </li> 
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="kt_tabs_1_1" role="tabpanel">
                    <div class="kt-widget kt-widget--users">
                        <div class="kt-scroll kt-scroll--pull">
                             <div class="kt-widget__items">
                            <?php
                           
                            foreach ($citas as $registro){
                              
                                      foreach ($cita_calificacion as $feed )
                                        {

                                            if($feed->id_cita==$registro->id && $feed->puntuacion==3)
                                            {
                                               
                            ?> 
                                            <div class="kt-widget__item">
                                                <span class="kt-userpic kt-userpic--circle">
                                                   <i class="fa fa-user-circle fa-5x" ></i>
                                                </span>
                                                <div class="kt-widget__info">
                                                    <div class="kt-widget__section">
                                                        <a href="#" class="kt-widget__username">
                                                            <?= boolval($feed->anonimo) ? 'Anónimo' : $feed->cita->paciente->nombreCompleto ?></a>
                                                    </div>
                                                    <span class="kt-widget__desc" >
                                                      <?=$feed->comentario?>
                                                    </span>
                                                </div>
                                                <div class="kt-widget__action">
                                                    <?php if( !boolval($feed->anonimo) ){?>
                                                    <a href="<?= Url::to(['paciente/view','id'=>$feed->cita->id_paciente])?>">
                                                        <button class="btn btn-success" >Ver Paciente</button>
                                                    </a>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                           <?php } ?>
                                      <?php  } ?>                 
                                 <?php   } ?>
                             </div>
                        </div>
                     </div>
                </div>
                <div class="tab-pane" id="kt_tabs_1_2" role="tabpanel">
                    <div class="kt-widget kt-widget--users">
                        <div class="kt-scroll kt-scroll--pull">
                           <div class="kt-widget__items">
                            <?php
                            foreach ($citas as $registro){
                                      foreach ($cita_calificacion as $feed ){
                                            if($feed->id_cita==$registro->id && $feed->puntuacion==2)
                                            {            
                            ?> 
                                            <div class="kt-widget__item">
                                                <span class="kt-userpic kt-userpic--circle">
                                                   <i class="fa fa-user-circle fa-5x" ></i>
                                                </span>
                                                <div class="kt-widget__info">
                                                    <div class="kt-widget__section">
                                                        <a href="#" class="kt-widget__username">
                                                            <?= boolval($feed->anonimo) ? 'Anónimo' : $feed->cita->paciente->nombreCompleto ?></a>
                                                    </div>
                                                    <span class="kt-widget__desc" >
                                                      <?=$feed->comentario?>
                                                    </span>
                                                </div>
                                                <div class="kt-widget__action">
                                                    <?php if( !boolval($feed->anonimo) ){?>
                                                    <a href="<?= Url::to(['paciente/view','id'=>$feed->cita->id_paciente])?>">
                                                        <button class="btn btn-success" >Ver Paciente</button>
                                                    </a>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                           <?php } ?>
                                      <?php  } ?>
                                 <?php   } ?>                     
                         </div>
                    </div>
                </div>
            </div>
             <div class="tab-pane" id="kt_tabs_1_3" role="tabpanel">
               <div class="kt-widget kt-widget--users">
                <div class="kt-scroll kt-scroll--pull">
                        <div class="kt-widget__items">
                            <?php
                            foreach ($citas as $registro){
                                      foreach ($cita_calificacion as $feed ){
                                            if($feed->id_cita==$registro->id && $feed->puntuacion==1)
                                            {               
                            ?> 
                                            <div class="kt-widget__item">
                                                <span class="kt-userpic kt-userpic--circle">
                                                   <i class="fa fa-user-circle fa-5x" ></i>
                                                </span>
                                                <div class="kt-widget__info">
                                                    <div class="kt-widget__section">
                                                        <a href="#" class="kt-widget__username">
                                                            <?= boolval($feed->anonimo) ? 'Anónimo' : $feed->cita->paciente->nombreCompleto ?></a>
                                                    </div>
                                                    <span class="kt-widget__desc" >
                                                      <?=$feed->comentario?>
                                                    </span>
                                                </div>
                                                <div class="kt-widget__action">
                                                    <?php if( !boolval($feed->anonimo) ){?>
                                                    <a href="<?= Url::to(['paciente/view','id'=>$feed->cita->id_paciente])?>">
                                                        <button class="btn btn-success" >Ver Paciente</button>
                                                    </a>
                                                    <?php } ?>
                                                </div>
                                            </div>    
                                           <?php } ?>
                                      <?php  } ?>
                                 <?php   } ?>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="rango-fechas" class="modal fade">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="pseg-title">Filtar por fechas</h4>
                <button data-dismiss="modal" class="close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 dropdown">
                        <label>Fecha inicio</label>
                        <?= MaskedInput::widget([
                            'name' => 'fecha-inicio',
                            'id'   => 'fecha-inicio',
                            'value'=> null,
                            'clientOptions' => ['placeholder' =>'DD/MM/AAAA'],
                            'mask' => '99/99/9999',
                        ]); ?>
                    </div>
                    <div class="col-md-12 mt-3">
                        <label>Fecha limite</label>
                         <?= MaskedInput::widget([
                            'name' => 'fecha-fin',
                            'id'   => 'fecha-fin',
                            'value'=> null,
                            'clientOptions' => ['placeholder' =>'DD/MM/AAAA'],
                            'mask' => '99/99/9999',
                        ]); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-success" id="obtener-rango">Filtrar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
