<?php

use yii\helpers\Html;
use app\themes\metronic\assets\ChartJsAssets;
use yii\helpers\Url;
use app\themes\metronic\assets\BootstrapDatepickerAssets;
use app\customs\Utils;

/* @var $this yii\web\View */
/* @var $resultado array */

$this->title = 'PACIENTES EN ATENCIÓN';
$this->params['breadcrumbs'][] = $this->title;

ChartJsAssets::register($this);
BootstrapDatepickerAssets::register($this);


$cantidadesStr = "";
$labelsStr = "";
$colorStr = "";
foreach($resultado as $grupo){
    $labelsStr .= "'" . $grupo['nombre'] . "',";
    $cantidadesStr .= $grupo['cantidad'] . ",";
    $color = Utils::getColor($grupo['nombre'] . $grupo['cantidad']);
    $colorStr .=  "'rgb(" .$color[0] . "," . $color[1] . "," . $color[2]   . ")',";
}

$this->registerJs("
    var data = {
        datasets: [{
            data: [" . $cantidadesStr . "],
            backgroundColor:[
                " . $colorStr . "
            ]
        }],

        // These labels appear in the legend and in the tooltips when hovering different arcs
        labels: [" . $labelsStr . "]
    };
    $(document).ready(function(){
        var ctx = $('canvas.chart');
        var myPieChart = new Chart(ctx, {
            type: 'pie',
            data: data
        });
        
        $('#fechaHasta').datepicker({
            format: 'dd/mm/yyyy'
        });
    });
");

$fechaHastaFormato = date('d/m/Y' , strtotime($fechaHasta));
?>
<div class="rol-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <div class="rigth">
            <form method="post"  class="form-inline" action="<?= Url::to(['reportes/pacientes-por-grupo'])?>">
                <input type="hidden" name="_csrf" value="<?=Yii::$app->request->getCsrfToken()?>" />
                <div class="form-group">
                    <label for="fechaHasta">Fecha hasta</label>
                    <input type="text" class="form-control form-control-sm" id="fechaHasta" name="fechaHasta" placeholder="Fecha hasta" value="<?= $fechaHastaFormato ?>" />
                </div>
                <button type="submit" class="btn btn-primary">Cargar</button>
            </form>
        </div>
    </div>
    <div class="kt-portlet__body">
        <div class="row text-right">
            <div class="offset-8 col-md-4">
                <span id="badge-periodo" style="font-size: 14px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">
                    <b>Filtro:</b>&nbsp;hasta el <?= $fechaHastaFormato ?>
                </span>
            </div>    
        </div>

        <div class="row">
            <div class="col-md-12">
                <table class="table">
                    <thead>
                        <th>ÁREA</th>
                        <th>CANTIDAD</th>
                    </thead>
                    <tbody>
                        <?php 
                        $totales = 0;
                        foreach ($resultado as $grupo){ 
                            $totales += intval($grupo['cantidad']);
                        ?>
                        <tr>
                            <td><?= $grupo['nombre']?></td>
                            <td><?= $grupo['cantidad']?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <th>Total general</th>
                        <th><?= $totales?></th>
                    </tfoot>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-1"></div>
            <div class="col-10">
                <div id="pacientes-chart-container">   
                    <canvas class="chart" height="400" width="400"></canvas>
                </div>
                
            </div>
            <div class="col-1"></div>
        </div>
    </div>
    
</div>
