<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\assets\ReporteCitasAsset;
use yii\widgets\MaskedInput; 

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Citas';
$this->params['breadcrumbs'][] = $this->title;

ReporteCitasAsset::register($this);
?>
<div class="rol-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <div class="rigth">
            <div class="dropdown mt-2">
                 <button class="btn btn-success dropdown-toggle" type="button" id="filtros" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                     Filtrar
                 </button>
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="filtros" style="">
                    <a class="dropdown-item filtro-periodo" href="#" data-periodo="week" data-label="Semana">Semana</a>
                    <a class="dropdown-item filtro-periodo" href="#" data-periodo="month" data-label="Mes">Mes</a>
                    <a class="dropdown-item filtro-periodo" href="#" data-periodo="trimester" data-label="Trimestre">Trimestre</a>
                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#rango-fechas" data-label="Personalizado">Personalizado</a>
                </div>
            </div> 
        </div>
    </div>
    <div class="kt-portlet__body">
        <div class="row text-right">
            <div class="offset-8 col-md-4">
                <span id="badge-periodo" style="font-size: 14px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">Semana</span>
            </div>    
        </div>

        <div class="row">
            <div class="m-4"></div>
        </div>
        <div class="row">
            <div class="col-1"></div>
            <div class="col-10">
                <div id="citas-chart-container">   
                </div>
                
            </div>
            <div class="col-1"></div>
        </div>
    </div>
    
</div>
<div class="row">
    <div class="col-lg-6">
        <div class="kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Pacientes Atentidos vs Citas Agendadas</h1>
                </div>
            </div>
            <div class="kt-portlet__body  kt-portlet__body--fit">
                <div class="row row-no-padding row-col-separator-xl">
                    <div class="col-6">
                        <!--begin:: Widgets/Daily Sales-->
                        <div class="kt-portlet kt-portlet--height-fluid">
                            <div class="kt-widget14">
                                <div class="kt-widget_content">
                                    <span id="citas_versus_fraccion" class="data-reporte-citas texto-reporte-citas"></span>
                                </div>
                            </div>
                        </div>
                        <!--end:: Widgets/Daily Sales-->
                    </div>
                    <div class="col-6">
                        <!--begin:: Widgets/Profit Share-->
                        <div class="kt-portlet kt-portlet--height-fluid">
                            <div class="kt-widget14">
                                <div class="kt-widget_content">
                                    <span class="data-reporte-citas">
                                        <span id="citas_versus_porcentaje" class="texto-reporte-citas"></span>
                                        <span class="subtexto-reporte-citas">&nbsp;éxito</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <!--end:: Widgets/Profit Share-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="kt-portlet">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h1 class="kt-portlet__head-title">Total de Ventas</h1>
                </div>
            </div>
            <div class="kt-portlet__body  kt-portlet__body--fit">
                <div class="row row-no-padding row-col-separator-xl">
                    <div class="col-xl-12">
                        <!--begin:: Widgets/Daily Sales-->
                        <div class="kt-portlet kt-portlet--height-fluid">
                            <div class="kt-widget14">
                                <div class="kt-widget_content">
                                    <span class="data-reporte-citas">
                                        <span id="citas_ventas_aprox_entero" class="texto-reporte-citas"></span>
                                        <span id="citas_ventas_aprox_centavos" class="supratexto-reporte-citas">&nbsp;éxito</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <!--end:: Widgets/Daily Sales-->
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-6">
        <div class="kt-portlet kt-portlet--bordered-semi kt-portlet--height-fluid">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        Procedimientos más Realizados
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div 
                    class="kt-widget4 kt-scroll" 
                    id="top_procedimientos" 
                    data-scroll="true" 
                    data-mobile-height="150" 
                    data-height="200" 
                    style="overflow-y: scroll; height: 200px;">
                </div>
            </div>
        </div>
    </div>    <div class="col-6">
        <div class="kt-portlet kt-portlet--bordered-semi kt-portlet--height-fluid">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        Procedimientos con más Ingresos
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div 
                    class="kt-widget4 kt-scroll" 
                    id="top_ventas"
                    data-scroll="true" 
                    data-mobile-height="150" 
                    data-height="200" 
                    style="overflow-y: scroll; height: 200px;">
                </div>
            </div>
        </div>
    </div>
</div>

<div id="rango-fechas" class="modal fade">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="pseg-title">Filtar por fechas</h4>
                <button data-dismiss="modal" class="close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 dropdown">
                        <label>Fecha inicio</label>
                        <?= MaskedInput::widget([
                            'name' => 'fecha-inicio',
                            'id'   => 'fecha-inicio',
                            'value'=> null,
                            'clientOptions' => ['placeholder' =>'DD/MM/AAAA'],
                            'mask' => '99/99/9999',
                        ]); ?>
                    </div>
                    <div class="col-md-12 mt-3">
                        <label>Fecha limite</label>
                         <?= MaskedInput::widget([
                            'name' => 'fecha-fin',
                            'id'   => 'fecha-fin',
                            'value'=> null,
                            'clientOptions' => ['placeholder' =>'DD/MM/AAAA'],
                            'mask' => '99/99/9999',
                        ]); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-success" id="obtener-rango">Filtrar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->