<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\assets\ReporteUsuariosActivosAsset;
use yii\widgets\MaskedInput;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Usuarios Activos';
$this->params['breadcrumbs'][] = $this->title;

ReporteUsuariosActivosAsset::register($this);
$now = date('Y-m-d');
$date_f_sub = date('Y-m-d', strtotime($now.'-15 days'));
$fecha_f = date_create($now);
$fecha_i = date_create($date_f_sub);
$fecha_f_format = date_format($fecha_f,'d/m/Y');
$fecha_i_format = date_format($fecha_i,'d/m/Y');
?>
<style>
.usuarios .datepicker-dropdown{ 
  z-index: 100;
}
</style>
<div class="rol-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="usuarios kt-portlet__body">
        <div class="row">
             <div class="col-md-1 offset-1"></div>
            <div class="col-md-4 dropdown">
                <label>Fecha inicio</label>
                <?= MaskedInput::widget([
                    'name' => 'fecha-inicio',
                    'id'   => 'fecha-inicio',
                    'value'=> $fecha_i_format,
                    'mask' => '99/99/9999',
                ]); ?>
            </div>
            <div class="col-md-4">
                <label>Fecha limite</label>
                 <?= MaskedInput::widget([
                    'name' => 'fecha-fin',
                    'id'   => 'fecha-fin',
                    'value'=> $fecha_f_format,
                    'mask' => '99/99/9999',
                ]); ?>
            </div>
            <div class="col-md-2">
                <button class="btn btn-success mt-4 mt-1" id="get-grafica">Ver activos</button>
            </div> 
        </div>
        <div class="row">
            <div class="m-4"></div>
        </div>
        <div class="row">
            <div class="col-2"></div>
            <div class="col-8">
                <div id="usuarios-chart-container">   
                </div>
                
            </div>
            <div class="col-2"></div>
        </div>
    </div>
</div>

<div class="rol-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="usuarios kt-portlet__body">
        <div class="row">
             <div class="col-md-1 offset-1"></div>
            <div class="col-md-4 dropdown">
                <label>Fecha inicio</label>
                <?= MaskedInput::widget([
                    'name' => 'fecha-inicio_c',
                    'id'   => 'fecha-inicio_c',
                    'value'=> $fecha_i_format,
                    'mask' => '99/99/9999',
                ]); ?>
            </div>
            <div class="col-md-4">
                <label>Fecha limite</label>
                 <?= MaskedInput::widget([
                    'name' => 'fecha-fin_c',
                    'id'   => 'fecha-fin_c',
                    'value'=> $fecha_f_format,
                    'mask' => '99/99/9999',
                ]); ?>
            </div>
            <div class="col-md-2">
                <button class="btn btn-success mt-4 mt-1" id="grafica-citas-p">Ver N° Citas</button>
            </div> 
        </div>
        <div class="row">
            <div class="m-4"></div>
        </div>
        <div class="row">
            <div class="col-2"></div>
            <div class="col-8">
                <div id="citas-us-chart-container">   
                </div>
                
            </div>
            <div class="col-2"></div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-12">
        <div class="kt-portlet kt-portlet--bordered-semi kt-portlet--height-fluid">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                            Usuarios inactivos
                    </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                <div class="kt-widget4" >
                    <div class="row">
                        <div class="col-md-4">
                            <label>Fecha limite</label>
                             <?= MaskedInput::widget([
                                'name' => 'fecha-u-a',
                                'id'   => 'fecha-u-a',
                                'value'=> $fecha_f_format,
                                'mask' => '99/99/9999',
                            ]); ?>
                        </div>
                        <div class="col-md-4">
                            <button class="btn btn-success mt-4 mt-1" id="get-inactivos">Ver inactivos</button>
                        </div> 
                    </div>
                    <div class="table-responsive">
                        <div id="w1" class="grid-view">    
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Email</th>
                                        <th>Nombre</th>
                                        <th>Apellidos</th>
                                        <th>Tel</th>
                                        <th>N° citas</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody id="usuarios-inactivos">
                                <tbody>        
                            </table>
                        </div>        
                    </div>   
                </div>
            </div>
        </div>
    </div>  
</div>
