<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\RecordatorioAsset;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Recordatorios antes de la cita';
$this->params['breadcrumbs'][] = $this->title;
RecordatorioAsset::register($this);
?>
<div class="recordatorio-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>

    <div class="kt-portlet__body">
    
    <?php $form = ActiveForm::begin(['action' => ['recordatorio/guardar-recordatorios'],'options' => ['class' => 'kt-form']]); ?>
       
        <div class="table-responsive">
            <table class="table table-hover" id="kt_table_1" width="75%" style="font-weight: 1rem;border-bottom-width: 1px;font-size: 11pt;   padding-top: 1rem;padding-bottom: 1rem;" >
                <thead class="thead-inverse">
                    <tr>
                        <th title="Field #1">Nombre</th>
                        <th title="Field #3">Tiempo de recordatorio</th>
                        <th title="Field #3">Unidad</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($recordatorios as $recordatorio){?>           
                    <?= $this->render('_form',['model' => $recordatorio,'form' => $form])?>
                <?php } ?> 
                </tbody>
            </table>
        </div>
        <div class="row">
            <?=Html::submitButton('Guardar',['class' => 'btn btn-primary']) ?>
        </div>
    <?php ActiveForm::end();?>
    </div>
</div>