<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\RecordatorioDoctor */

$this->title = $model->asunto;
$this->params['breadcrumbs'][] = ['label' => 'Recordatorios', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
$href = $model->es_paciente ? ['paciente/view', 'id' => $model->id_paciente] : ['#'];
\yii\web\YiiAsset::register($this);
?>
    <div class="Nota-view  kt-grid__item kt-grid__item--fluid" id="kt_content_Nota">
        <div class="row" style="text-shadow: none;">
            <div class="col-xl-12" style="text-shadow: none;">
                <!--begin:: Widgets/Applications/User/Profile3-->
                <div class="kt-portlet kt-portlet--height-fluid" style="text-shadow: none;">
                    <div class="kt-portlet__body" style="text-shadow: none;">
                        <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
                            <div class="kt-widget__top" style="text-shadow: none;">
                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <p>
                                            <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.8rem; 
                                               font-weight:500; color: #464457; ">
                                               <?= $model->asunto ?>
                                            </a>
                                            <?php if($model->es_paciente){?>
                                            <?= Html::a(' - '. $model->nombrePaciente, $href, ['style'=>'-20px;font-size: 1.8rem; 
                                               font-weight:500; color: #464457;', 'class' => 'kt-portlet__head-title']) ?>
                                            <?php }?>
                                        <p>
                                        <div class="kt-widget__action " style="margin-left:-55px;">
                                            <p class="d-none d-md-block">
                                                <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                                                <?=
                                                Html::a('Eliminar', ['delete', 'id' => $model->id], [
                                                    'class' => 'btn btn-danger',
                                                    'data' => [
                                                        'confirm' => '¿Está seguro de eliminar este elemento?',
                                                        'method' => 'post',
                                                    ],
                                                ])
                                                ?>
                                            </p>
                                        </div>
                                        <div class="d-md-none">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                                                    Opciones
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    <?= Html::a('<i class="la la-edit kt-font-primary mt-2"></i>Actualizar', ['update', 'id' => $model->id], ['class' => 'dropdown-item']) ?>
                                                    <div class="dropdown-divider"></div>
                                                    <?= Html::a('<i class="la la-trash kt-font-danger mt-2"></i>Eliminar', ['delete', 'id' => $model->id], [
                                                    'class' => 'dropdown-item',
                                                    'data' => [
                                                        'confirm' => '¿Está seguro de eliminar este elemento?',
                                                        'method' => 'post',
                                                    ],
                                                ]) ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row" style="margin-top: -30px;">
                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Asunto Recordatorio</h3>
                                                <span class="kt-widget1__desc" ><?= $model->asuntoRecordatorio?></span>
                                                <br>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Comentarios Recordatorio</h3>
                                                <span class="kt-widget1__desc"><?= $model->comentariosRecordatorio?></span>
                                                <br>
                                            </div>
                                        </div>
                                                                                <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Paciente</h3>
                                                <span class="kt-widget1__desc"><?= $model->es_paciente ? Html::a($model->nombrePaciente, $href,[]) : $model->nombrePaciente ?></span>
                                                <br>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Fecha Inicio</h3>
                                                <span class="kt-widget1__desc"><?= $model->fecha_inicio?></span>
                                                <br>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Fecha Fin</h3>
                                                <span class="kt-widget1__desc"><?= $model->fecha_fin?></span>
                                                <br>
                                            </div>
                                        </div>
                                        <?php if(!$model->finalizado){?>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">Finalizado</h3>
                                                <span class="kt-widget1__desc">
                                                    <?= Html::checkbox('finalizado', false, ['id'=>'finalizado', 'data-id'=>$model->id])?>
                                                    <label>¿Marcar como finalizado?</label>
                                                </span>
                                                <br>
                                            </div>
                                        </div>
                                        <?php }?>
                                    </div>
                                </div>
                            </div>
                            <hr>
                        </div>
                    </div>
                </div>
                <!--end:: Widgets/Applications/User/Profile3-->
            </div>
        </div>
    </div>

<?php
    $this->registerJs("
        $(document).ready(function(){
            $('#finalizado').click(function(e){
                var {dataset,checked} = e.target;
                var id = dataset.id;
                if(checked){
                    var bool = confirm('¿Esta seguro de marcar este elemento como finalizado?');
                    if(bool){
                        $.post(_baseURL + '/recordatorio-doctor/finalizado',{'id':id},function(json){
                            if(json.Correcto){
                                window.location.reload();
                            }
                        },'json');
                    }
                }
                
            });
        });
    ");
    ?>

