<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $usuario app\models\Usuario */

$usuario = Yii::$app->user->identity;
$this->title = 'Recordatorios';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="evento-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <p>
            <?= Html::a('Crear Recordatorio', ['create'], ['class' => 'btn btn-success']) ?>
        </p>


        <div class="table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'tableOptions' => ['class' => 'table table-hover', 'style' => 'font-size: 11pt'],
                'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
                'rowOptions'=>function($model){
                    return ['data-id'=>$model->id];
                },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    'asunto',
                    'fecha_inicio',
                    'fecha_fin',
                    'privacidad:boolean',
                    'todo_dia:boolean',
                    'es_paciente:boolean',
                    'finalizado:boolean',
                    'nombrePaciente',
                    [
                        'class' => 'app\customs\ActionColumn',
                        'template' => '{view} {update} {delete}',
                        'buttons' => [
                            'update' => function($url, $model, $key) use ($usuario) {
                                return $usuario->tipo == app\models\Usuario::DOCTOR || $model->privacidad == 0 ? Html::a('<span class="kt-font-warning flaticon-edit"></span>', $url) : "";
                            },
                            'delete' => function($url, $model, $key) use ($usuario) {
                                return $usuario->tipo == app\models\Usuario::DOCTOR ? Html::a('<span class="kt-font-danger flaticon2-trash"></span>', $url, [
                                            'data' => [
                                                'method' => 'post',
                                                'params' => ['id' => $model->id], // <- extra level
                                            ],
                                        ]) : "";
                            }
                        ]
                    ],
                ],
            ]);
            ?>
            <?php
            $this->registerJs("
                    $('tbody td:not(.disable-click)').css('cursor', 'pointer');
                    $(document).on('click','table tr td:not(.disable-click)',function(e) {      
                        var id = $(this).closest('tr').data('id');
                        if (e.target == this && id)
                            location.href = '" . Url::to(['/recordatorio-doctor/view']) . "?id=' + id;
                    });
                ");
            ?>
        </div> 
    </div>
</div>
