<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Usuario;
use yii\helpers\Url;
use app\models\Suscripcion;

/* @var $this yii\web\View */
/* @var $usuario Usuario */
/* @var $suscripcion app\models\Suscripcion */
/* @var $dataProvider yii\data\ActiveDataProvider */

$usuario = Yii::$app->user->identity;
$suscripcion = $usuario->suscripcion;

$this->title = 'Procedimientos';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="procedimiento-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p class="mt-2">
            <?= Html::a('Crear Procedimiento', ['create'], ['class' => 'btn btn-success']) ?>
        </p>
    </div>
    <div class="kt-portlet__body">

        <?php if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL) { ?>
        <p>
            <?= $this->render('../layouts/_filtro_clinica',['clinicas' => $clinicas,'clinicas_seleccionadas' => $clinicas_seleccionadas])?>
        </p>
        <?php } ?>

        <div class="table-responsive">

          
                
         <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'tableOptions' => ['class' => 'table table-hover','style'=>'font-size: 11pt'],
            'rowOptions'=>function($model){
            return ['data-id'=>$model->id];
            },
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],
                'nombre',
                'descripcion',
                'costo',
                'tiempo',
                [
                    'class' => 'app\customs\ActionColumn',
                    'template' => '{view} {update} {delete}',
                    'buttons' => [
                        'delete' => function ($url,$model,$key){
                            return $model->totalProcedimientoCitas > 0
                                    ? ""
                                    : Html::a('<span class="kt-font-danger flaticon2-trash"></span>',
                                    ['delete', 'id' => $model->id],
                                    ['data-method' => 'post','data-confirm'=>'¿Está seguro de eliminar este elemento?']);
                        },
                    ]
                ],
            ],
        ]); ?>
        <?php
        $this->registerJs("
            $('tbody td:not(.disable-click)').css('cursor', 'pointer');
            $(document).on('click','table tr td:not(.disable-click)',function(e) {      
                var id = $(this).closest('tr').data('id');
                if (e.target == this && id)
                    location.href = '" . Url::to(['/procedimiento/view']) . "?id=' + id;
            });
        ");
        ?>

         
    
    
    </div>
</div>
