<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\ProcedimientoAsset;
use app\models\Usuario;
use yii\helpers\ArrayHelper;
use  app\models\Suscripcion;
/* @var $this yii\web\View */
/* @var $model app\models\Procedimiento */
/* @var $form yii\widgets\ActiveForm */
/* @var $usuario app\models\Usuario */
/* @var $suscripcion app\models\Suscripcion */

$horas = $model->isNewRecord ? 0 : ($model->tiempo_recordatorio / 60);
$timing=$model->tiempo_recordatorio;
$minutos = $timing - ($horas * 60);

$model->tiempo_recordatorio = $minutos;

ProcedimientoAsset::register($this);

$usuario = Yii::$app->user->identity;
$suscripcion = $usuario->suscripcion;

?>
<script>
    var tipoUsuario = '<?= (Yii::$app->user->identity->tipo ) ?>';
</script>
<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="procedimiento-form kt-portlet__body">
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'nombre')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-8">
                <?= $form->field($model, 'descripcion')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'costo')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'horas')->textInput(['placeholder' => 'horas']) ?>
            </div>
            <div class="col-lg-4">
                <div class="p-1">&nbsp;</div>
                <?= $form->field($model, 'tiempo_duracion')->textInput(['placeholder' => 'minutos'])->label(false) ?>
            </div>
        </div>
        <?php 
        if($usuario->tipo == Usuario::DOCTOR){
            $seleccionadas = ArrayHelper::getColumn($model->clinicaProcedimientos,'id_clinica');
        ?>
        <div class="row">
            <div class="col-lg-4">
                <div class="form-group">
                    <?= $form->field($model, 'tipo')->hiddenInput(['value'=>$model::PRESENCIAL])->label(false) ?>
                    <label>Tipo de procedimiento:</label>
                    <div class="radio-inline">
                        <label class="radio mx-2">
                        <input type="radio" name="tipo-proc" class="pcr-t" checked="" value="<?=$model::PRESENCIAL?>">
                        <span></span>Presencial</label>
                        <label class="radio mx-2">
                        <input type="radio" name="tipo-proc" class="pcr-t" value="<?=$model::EN_LINEA?>" <?= (!$model->isNewRecord && $model->tipo == $model::EN_LINEA) ? 'checked=""' : ''?> >
                        <span></span>En línea</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6 mt-less-px-10">
                <?= $form->field($model, 'para_solicitud_cita')->checkbox() ?>
            </div>
        </div>
            <?php if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL) { ?>
            <div class="row">
                <div class="col-lg-4">
                    <div class="form-group" id="clinicas-i">
                        <label class="control-label" for="clinicas">Clínica</label>
                        <?= Html::checkboxList('clinicas',$seleccionadas,$clinicas) ?>
                    </div>

                </div>
            </div>
            <?php } ?>
        <?php } ?>
        
        <?php 
            if($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA) { 
                
            $grupoSeleccionados = ArrayHelper::getColumn($model->gruposProcedimiento,'id_grupo');
            
        ?>
            <div class="row">
                <div class="col-lg-4">
                    <div class="form-group" id="clinicas-i">
                        <label class="control-label" for="grupos">Grupo</label>
                        <?= Html::checkboxList('grupos',$grupoSeleccionados,$grupos) ?>
                    </div>

                </div>
            </div>
        <?php } ?>
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>