<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Plan */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="plan-form kt-portlet__body">
       
        <div class="row">
            <div class="col-lg-12">
                <?= $form->field($model, 'nombre')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
       
        <div class="row">
            <div class="col-lg-12"><?= $form->field($model, 'descripcion')->textArea(['maxlength' => true]) ?></div>
        </div>
        <div class="row">
            <div class="col-lg-4"><?= $form->field($model, 'precio')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'precio_cita')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'stripe_id')->textInput() ?></div>
        </div>
        <div class="row">
            <div class="col-lg-3"><?= $form->field($model, 'maximo_usuarios')->textInput() ?></div>
            <div class="col-lg-3"><?= $form->field($model, 'maximo_mensajes')->textInput() ?></div>
        </div>
        <div class="row">
            <div class="col-lg-3">
                <label>Tipo de Plan</label>
                <?= $form->field($model, 'tipo')->radio(['label'=>'Por Citas', 'value'=>$model::TIPO_X_CITAS, 'uncheked' => null]) ?>
                <?= $form->field($model, 'tipo')->radio(['label'=>'Por Mensajes', 'value'=>$model::TIPO_X_SMS, 'uncheked' => null]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-3"><?= $form->field($model, 'activo')->checkbox() ?></div>
        </div>
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>