<?php

use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Pagadito */

$label = $model == NULL ? 'Agregar' : 'Actualizar';
$accion = $model == NULL ? ['create'] : ['update', 'id' => $model->id];
$icon = $model == NULL ? 'la-plus' : 'la-edit';

$this->title = 'Datos Pagadito';
$this->params['breadcrumbs'][] = ['label' => 'Datos Pagadito', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="pagadito-view">
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="row" style="text-shadow: none;">
            <div class="col-xl-12" style="text-shadow: none;">
                <!--begin:: Widgets/Applications/User/Profile3-->
                <div class="kt-portlet kt-portlet--height-fluid" style="text-shadow: none;">
                    <div class="kt-portlet__body" style="text-shadow: none;">
                        <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
                            <div class="kt-widget__top" style="text-shadow: none;">
                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <p>
                                            <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.8rem; 
                                               font-weight:500; color: #464457; ">Datos Pagadito
                                            </a>
                                        </p>
                                        <div class="kt-widget__action " style="margin-left:-55px;">
                                            <p class="d-none d-md-block">
                                                <?= Html::a($label, $accion, ['class' => 'btn btn-primary']) ?>
                                                <?= $model != NULL ? Html::a('Eliminar', ['delete', 'id' => $model->id], [
                                                    'class' => 'btn btn-danger',
                                                        'data' => [
                                                            'confirm' => '¿Está seguro de eliminar este elemento?',
                                                            'method' => 'post',
                                                        ],
                                                    ]) : ''
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="d-md-none">
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                                                Opciones
                                            </button>
                                            <div class="dropdown-menu">
                                                <?= Html::a('<i class="la ' . $icon . ' kt-font-primary mt-2"></i>' . $label, $accion, ['class' => 'dropdown-item']) ?>
                                                <div class="dropdown-divider"></div>
                                                <?= $model != NULL ?  Html::a('<i class="la la-trash kt-font-danger mt-2"></i>Eliminar', ['delete', 'id' => $model->id], [
                                                    'class' => 'dropdown-item',
                                                        'data' => [
                                                            'confirm' => '¿Está seguro de eliminar este elemento?',
                                                            'method' => 'post',
                                                        ],
                                                    ]) : ''
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row" style="margin-top: -30px;">
                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">UID</h3>
                                                <span class="kt-widget1__desc" ><?= $model != NULL ? $model->uid : 'No definido' ?></span>
                                                <br>
                                            </div>
                                        </div>
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">WSK</h3>
                                                <span class="kt-widget1__desc"><?= $model != NULL ? $model->wsk : 'No definido' ?></span>
                                                <br>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6" >
                                    <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                    <div class="kt-widget1 kt-widget1--fit">
                                        <div class="kt-widget1__item">
                                            <div class="kt-widget1__info">
                                                <h3 class="kt-widget1__title">URL WEBHOOk</h3>
                                                <span class="kt-widget1__desc" ><?= ($model == NULL || $model->webhook_url == NULL) ? 'No definido' : $model->webhook_url ?></span>
                                                <br>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
