<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\models\ProcedimientoCita;
use app\assets\ViewAdjuntoAsset;
/* @var $this yii\web\View */
/* @var $model app\models\Paciente */

$this->title = $model->nombre." ".$model->apellido;
$this->params['breadcrumbs'][] = ['label' => 'Pacientes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
ViewAdjuntoAsset::register($this);
if($model->ultimaCita != null){
    $procedimiento_cita_array=ProcedimientoCita::find()->where(['id_cita' => $model->ultimaCita->id])->all();
}
?>
<div class="paciente-view " style="text-shadow: none;">
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="row" style="text-shadow: none;">
            <div class="col-xl-12" style="text-shadow: none;">
                <div class="kt-portlet kt-portlet--height-fluid" style="text-shadow: none;">
                    <div class="kt-portlet__body" style="text-shadow: none;">
                        <ul class="nav nav-tabs  nav-tabs-line nav-tabs-line-success" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#kt_tabs_7_1" role="tab"><i class="la la-info-circle"></i> Información general</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#kt_tabs_7_3" role="tab"><i class="la la-history"></i> Historial de citas</a>
                            </li>
                        </ul>
                        <div class="kt-widget kt-widget--user-profile-3">
                            <div class="kt-widget__top" style="text-shadow: none;">
                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <p>
                                            <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.8rem; 
                                                font-weight:500; color: #464457; ">
                                                <?= $model->nombre." ".$model->apellido?>
                                            </a>
                                        <p>
                                        <div class="kt-widget__action " style="margin-left:-55px;">
                                            <p class="d-none d-md-block">
                                                <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                                                <?= Html::a('Eliminar', ['delete', 'id' => $model->id], [
                                                    'class' => 'btn btn-danger',
                                                    'data' => [
                                                        'confirm' => '¿Está seguro de eliminar este elemento?',
                                                        'method' => 'post',
                                                    ],
                                                ]) ?>
                                            </p>
                                        </div>
                                        <div class="d-md-none">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                                                    Opciones
                                                </button>
                                                <div class="dropdown-menu">
                                                    <?= Html::a('<i class="la la-edit kt-font-primary mt-2"></i>Actualizar', ['update', 'id' => $model->id], ['class' => 'dropdown-item']) ?>
                                                    <div class="dropdown-divider"></div>
                                                    <?= Html::a('<i class="la la-trash kt-font-danger mt-2"></i>Eliminar', ['delete', 'id' => $model->id], [
                                                    'class' => 'dropdown-item',
                                                    'data' => [
                                                        'confirm' => '¿Está seguro de eliminar este elemento?',
                                                        'method' => 'post',
                                                    ],
                                                ]) ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="kt-widget__top" style="text-shadow: none;">
                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <p style="margin-top: -110px;margin-left: -15px;"></p>
                                        <div class="kt-widget__action " style="margin-left:-55px;text-align: right;margin-top: 15px;">
                                            <p style="font-size: 1.1rem;font-weight: 500; margin-top: 15px;">Próxima cita en:</p>
                                            <p>
                                                <?=$model->citaProxima == null ? 'No hay cita' : $model->citaProxima->fecha ?>
                                            </p>
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <p style="margin-top: -70px;">
                                        <a href="<?= Url::to(['cita/create','pid' => $model->id]) ?>" class="kt-grid-nav__item">
                                            <button type="button" class="btn btn-success btn-sm btn-upper flaticon2-plus"> Agregar Cita</button>
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="tab-pane active" id="kt_tabs_7_1" role="tabpanel">
                                <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
                                    
                                    <div class="kt-widget__top" style="text-shadow: none;">
                                        <div class="kt-widget__content">
                                            <div class="kt-widget__head">
                                                <a href="#" class="kt-portlet__head-title" style="margin-left: -20px;font-size: 1.2rem; 
                                                        font-weight:500; color: #646c9a;;">
                                                    <h2>Datos principales</h2>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row" style="margin-top: -30px;">
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Nombre Completo</h3>
                                                        <span class="kt-widget1__desc" ><?=$model->nombre.' '.$model->apellido?></span>
                                                        <br>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Edad</h3>
                                                        <span class="kt-widget1__desc"><?=$model->edad?></span>
                                                        <br>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Teléfono fijo</h3>
                                                        <span class="kt-widget1__desc" >
                                                            <?= ($model->telefono_fijo == NULL) ? "(no definido)" : $model->telefono_fijo ?>
                                                        </span>
                                                        <br>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Celular</h3>
                                                        <span class="kt-widget1__desc" >
                                                            <?= ($model->celular == NULL) ? "(no definido)" : $model->celular ?>
                                                        </span>
                                                        <br>
                                                    </div>
                                                </div>
                                              </div>
                                        </div>
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Email</h3>
                                                        <span class="kt-widget1__desc"><?=$model->email?></span>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Aseguradora</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->aseguradora == NULL) ? "(No definido)" : $model->aseguradora ?>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Número tarjeta aseguradora</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->no_aseguradora == NULL) ? "(No definido)": $model->no_aseguradora ?>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Observaciones</h3>
                                                        <span class="kt-widget1__desc" >
                                                            <?= ($model->notas == NULL) ? "(No definido)": $model->notas ?>
                                                        </span>
                                                        <br>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col">
                                            <h2 class="kt-widget1__desc" >Datos médicos</h2>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row" style="margin-top: -30px;">
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Referido por</h3>
                                                        <span class="kt-widget1__desc" >
                                                            <?= ($model->referido_por == NULL)? "(No definido)" : $model->referido_por?>
                                                        </span>
                                                        <br>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Enfermedades Actuales</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->enfermedades_actuales == NULL)? "(No definido)" : $model->enfermedades_actuales ?>
                                                        </span>
                                                        <br>
                                                    </div>
                                                </div>
                                            </div>
                                       </div>
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Alergias</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->alergias == NULL)? "(No definido)" : $model->alergias ?>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Medicamentos</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->medicamentos == NULL)? "(No definido)" : $model->medicamentos ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($model->ultimaCita != null){?>
                                    <hr>
                                    <div class="row">
                                        <div class="col">
                                            <h2 class="kt-widget1__desc" >Datos de última cita</h2>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row" style="margin-top: -30px;">
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Asunto</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->ultimaCita->asunto == '') ? "(No definido)" : $model->ultimaCita->asunto; ?>
                                                        </span>
                                                        <br>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Diagnóstico</h3>
                                                        <span class="kt-widget1__desc"><?= ($model->ultimaCita->diagnostico == NULL) ? "(No definido)" : $model->ultimaCita->diagnostico; ?></span>
                                                        <br>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title" style="padding-bottom: 20px;">Procedimientos</h3>
                                                        <?php
                                                        foreach ($procedimiento_cita_array as $model_cli_pro) {
                                                            echo " <li style='margin-top:-15px;' class='kt-widget1__desc'>" . $model_cli_pro->procedimiento->nombre . "</li><br>";
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Fecha</h3>
                                                        <span class="kt-widget1__desc"><?= $model->ultimaCita->fecha?></span>
                                                        <br>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(count($model->ultimaCita->adjuntoCita) > 0){?>
                                    <hr>
                                        <div class="row">
                                            <div class="col">
                                                <h2 class="kt-widget1__desc" >Adjuntos recientes</h2>
                                            </div>
                                        </div>
                                    <hr>
                                    <div class="row">
                                    <?php foreach($model->ultimaCita->adjuntoCita as $adjunto){
                                            echo $this->render('../adjunto/_viewTipo',['ad'=>$adjunto]);
                                        ?>
                                    <?php }?>
                                    </div>
                                    <?php }?>
                                    <?php }?>
                                    <hr>
                                    <div class="row">
                                        <div class="col">
                                            <h2 class="kt-widget1__desc" >Datos secundarios</h2>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row" style="margin-top: -30px;">
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">País</h3>
                                                        <span class="kt-widget1__desc" >El Salvador</span>
                                                        <br>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">C&oacute;digo</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->codigo == NULL)? "(No definido)" : $model->codigo ?>
                                                        </span>
                                                        <br>
                                                    </div>
                                                </div>
                                            </div>
                                       </div>
                                        <div class="col-lg-6" >
                                            <div class="kt-separator kt-separator--space-md kt-separator--border-dashed" style="border-color: white;"></div>
                                            <div class="kt-widget1 kt-widget1--fit">
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Fecha de nacimiento</h3>
                                                        <span class="kt-widget1__desc"><?=$model->fecha_nacimiento?></span>
                                                    </div>
                                                </div>
                                                <div class="kt-widget1__item">
                                                    <div class="kt-widget1__info">
                                                        <h3 class="kt-widget1__title">Sexo</h3>
                                                        <span class="kt-widget1__desc">
                                                            <?= ($model->sexo == 'h') ? 'Masculino' : 'Femenino' ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="kt_tabs_7_3" role="tabpanel">
                                <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
                                    <?= $this->render('_historial',['model' => $model->historicoCitas])?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" role="dialog" aria-hidden="true" id="view-imagen">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title title mt-2" id="title"></h5><span class="kt-badge kt-badge--brand kt-badge--lg title ml-2" id="edit-title"><i class="far fa-edit" style="font-size: 20px;"></i></span>
                    <textarea cols="2" rows="1" class="col-sm-3 col-md-6 form-control edit-title" id="descripcion" name="descripcion"></textarea>
                    <span class="kt-badge kt-badge--danger kt-badge--lg edit-title ml-2 mr-2" id="close-edit"><i class="far fa-times-circle" style="font-size: 20px;"></i></span>
                    <span class="kt-badge kt-badge--success kt-badge--lg edit-title mr-2" id="guardar"><i class="far fa-save" style="font-size: 20px;"></i></span>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="post-slide">
                    <div class="circle-prev">
                        <i class="flaticon2-fast-back navigation-btn prev" id="prev"></i>
                    </div>
                    <div class="circle-next">
                        <i class="flaticon2-fast-next navigation-btn next" id="next"></i>
                    </div>
                    <div class="circle-delete">
                        <i class="fa fa-trash-alt delete" id="eliminar-adjunto"></i>
                    </div>
                    <div class="circle-download" id="descargar-adjunto">
                        <a href="" id="url-adjunto"><i class="far fa-eye download"></i></a>
                    </div>
                    <img id="img-view" src="" width="100%" alt="...">
                </div>    
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div><!-- /.modal -->
