<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\PacienteAsset;
use yii\widgets\MaskedInput;
use app\themes\metronic\assets\Select2Assets;
use borales\extensions\phoneInput\PhoneInput;
use app\models\Suscripcion;
use app\models\Paciente;
use app\models\UsuarioSuscripcion;

/* @var $this yii\web\View */
/* @var $model app\models\Paciente */
/* @var $form yii\widgets\ActiveForm */
/* @var $usuario \app\models\Usuario */
/* @var $suscripcion \app\models\Suscripcion */

$sexo = ['h' => 'Hombre', 'm' => 'Mujer'];

Select2Assets::register($this);
PacienteAsset::register($this);

$clasePais = ($model->isNewRecord ? "" : (is_null($model->id_pais) ? "" : " cuadro-lleno"));
$nombrePais = ($model->isNewRecord ? "" : (is_null($model->id_pais) ? "" : $model->pais->nombre . " (" . $model->pais->iso . ")"));

$usuario = Yii::$app->user->identity;
$suscripcion = $usuario->suscripcion;

$esSusJerarquizada = $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA;

?>
<style>
    .campo-activo{
        border-color: green;
    }
</style>
<input type="hidden" id="valores-comunicacion" value="<?=$valores?>">
<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form', 'autocomplete' => 'off']]); ?>
    <div class="paciente-form kt-portlet__body">
        <?php if(
                    !$model->isNewRecord
                    && $suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA 
                    && ($usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_ADMINISTRADOR
                        || $usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR)
                ){ ?>
         <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'id_clinica')->dropDownList($clinicas)->label("Asignado a:") ?>
            </div>
        </div>
        <?php } ?>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'codigo')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'fecha_nacimiento')->textInput()->widget(MaskedInput::className(), [
                    'mask' => '99/99/9999',
                ]) ?>
            </div>
            <?php if( $esSusJerarquizada ):?>
            <div class="col-lg-4">
                <?php
                    $atributos = $usuario->tipoUsuarioJerarquia == \app\models\UsuarioSuscripcion::TIPO_ADMINISTRADOR ? ['disabled' => 'disabled'] : [];
                ?>
                <?= $form->field($model, 'estado')->dropDownList(Paciente::$estados,$atributos) ?>
            </div>
            <?php endif; ?>
        </div>
        <div class="row">
            <div class="col-lg-5">
                <?= $form->field($model, 'nombre')->textInput(['maxlength' => true,'required'=>'true']) ?>
            </div>
            <div class="col-lg-5">
                <?= $form->field($model, 'apellido')->textInput(['maxlength' => true,'required'=>'true']) ?>
            </div>
            <div class="col-lg-2">
                <?= $form->field($model, 'sexo')->radioList($sexo,['required'=>'true']) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-3">
                <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-3">
                <?= $form->field($model, 'telefono_fijo')->widget(PhoneInput::className(), [
                        'jsOptions' => [
                            'preferredCountries' => ['sv', 'gt', 'hn', 'ni', 'cr','pa', 'mx', 'us'],
                        ]
                    ]); 
                ?>
            </div>
            <div class="col-lg-3">
                <?= $form->field($model, 'celular')->widget(PhoneInput::className(), [
                        'jsOptions' => [
                            'preferredCountries' => ['sv', 'gt', 'hn', 'ni', 'cr','pa', 'mx', 'us'],
                        ]
                    ]); 
                ?>
            </div>
            <div class="col-lg-3">
                <div class="p-2">&nbsp;</div>
                <?= $form->field($model, 'usa_whatsapp')->checkbox() ?>
            </div>
        </div>
        <div class="kt-separator kt-separator--border-solid kt-separator--space-lg kt-separator--portlet-fit"></div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'id_tipo_encargado')->dropDownList($tipos,['prompt' => '- Seleccione un tipo -']) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'nombre_encargado')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-2">
                <button class="btn btn-success mt-4" type="button" data-toggle="collapse" data-target="#datos-encargado-secundario" aria-expanded="false" aria-controls="collapseExample">
                    <i class="la la-plus"></i>Contacto
                </button>
            </div>
        </div>
        <div class="kt-separator kt-separator--border-solid kt-separator--space-lg kt-separator--portlet-fit"></div>
            <div class="collapse" id="datos-encargado-secundario">
                <div class="well">
                    <h5>Datos de encargado secundario</h5>
                    <div class="row">
                        <div class="col-lg-3">
                            <?= $form->field($model, 'nombre_encargado_sec')->textInput(['maxlength' => true, 'autofocus'=>true]) ?>
                        </div>
                        <div class="col-lg-3">
                            <?= $form->field($model, 'apellido_encargado_sec')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-lg-3">
                            <?= $form->field($model, 'celular_encargado_sec')->widget(PhoneInput::className(), [
                                    'jsOptions' => [
                                        'preferredCountries' => ['sv', 'gt', 'hn', 'ni', 'cr','pa', 'mx', 'us'],
                                    ]
                                ]); 
                            ?>
                        </div>
                        <div class="col-lg-3">
                            <?= $form->field($model, 'email_encargado_sec')->textInput(['maxlength' => true]) ?>
                        </div>
                    </div>
                    <div class="kt-separator kt-separator--border-solid kt-separator--space-lg kt-separator--portlet-fit"></div>
                </div>
            </div>
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'aseguradora')->dropDownList($aseguradoras) ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($model, 'no_aseguradora')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'direccion')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label class="control-label" for="paisAutocomplete">País</label>
                    <?= Html::textInput('paisAutocomplete',$nombrePais,['id' => 'paisAutocomplete', 'class' => 'form-control' . $clasePais])?>
                    <?= $form->field($model, 'id_pais')->hiddenInput()->label(false) ?>
                </div>
            </div>
            <?php if( $esSusJerarquizada ):?>
            <div class="col-lg-4 select-procedencia-container">
                <?= $form->field($model, 'procedencia')->dropDownList($procedencias, ['prompt'=>'']) ?>
            </div>
            <?php endif; ?>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <?= $form->field($model, 'referido_por')->textInput(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <?= $form->field($model, 'enfermedades_actuales')->textarea(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'alergias')->textarea(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-4">
                <?= $form->field($model, 'medicamentos')->textarea(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="row">
         
            <div class="col-lg-12">
                <?= $form->field($model, 'notas')->textarea(['maxlength' => true]) ?>
            </div>
        </div>
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>