<?php
use app\models\Paciente;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $model app\models\Paciente */
/* @var $form yii\widgets\ActiveForm */
/* @var $usuario \app\models\Usuario */
/* @var $suscripcion \app\models\Suscripcion */

$this->registerJs('$("#paciente-procedencia").select2({
        tags: true,
        language: {
            noResults: function() {
                return "No hay procedencias";        
            },
            searching: function() {
                return "Buscando..";
            }
        }
    });', View::POS_READY);
$this->registerCss('
    .select-procedencia-container .select2-selection__rendered{
        padding-top: 0 !important;
        padding-bottom: 0 !important;

        padding-left: 8px !important;
        padding-right: 20px !important;
    }

    .select-procedencia-container .select2-selection__arrow{
        top: 50% !important;
    }
');
?>

<div class="row">
    <div class="col-lg-4">
        <?= $form->field($model, 'estado')->dropDownList(Paciente::$estados) ?>
    </div>
    <?php if (count($grupos) > 1){ ?>
        <div class="col-lg-4">
            <?= $form->field($model, 'id_grupo')->dropDownList($grupos) ?>
        </div>
    <?php } else{ ?>
        <?= $form->field($model, 'id_grupo')->hiddenInput()->label(false) ?>
    <?php } ?>
    <div class="col-lg-4 select-procedencia-container">
        <?= $form->field($model, 'procedencia')->dropDownList($procedencias) ?>
    </div>
</div>
