<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\ProcedimientoAsset;
use app\models\Usuario;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model app\models\Notificacion */
/* @var $form yii\widgets\ActiveForm */

?>
<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="procedimiento-form kt-portlet__body">
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'titulo')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($model, 'accion')->textInput(['maxlength' => true, 'placeholder'=>'Controlador/acción:cita/index - URL:https://www.google.com']) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'verbo')->textInput(['maxlength' => true]) ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($model, 'tipo')->dropDownList(app\models\Notificacion::TIPOS) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <?= $form->field($model, 'descripcion')->textArea(['maxlength' => true]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4"><?= $form->field($model, 'activo')->checkbox() ?></div>
        </div>

    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>