<?php
use yii\helpers\Html;
use app\models\CobroPagadito;
use app\models\Pagadito;

/* @var $pagadito app\models\Pagadito */
/* @var $cobroCita app\models\CobroPagadito */

$usuario = \Yii::$app->user->identity;
$simboloMoneda = $usuario->suscripcion->pais->simbolo;

$opt_iva_1_chk = ($pagadito != null && $pagadito->cargar_iva == CobroPagadito::IVA_INCLUIDO) ? 'checked' : '';
$opt_iva_2_chk = ($pagadito != null && $pagadito->cargar_iva == CobroPagadito::AGREGAR_IVA) ? 'checked' : '';
$opt_iva_3_chk = ($pagadito != null && $pagadito->cargar_iva == CobroPagadito::SIN_IVA) ? 'checked' : '';

$metodo_cobro_1_chk = ($pagadito != null && $pagadito->metodo_cobro == CobroPagadito::ASUMIR_CARGO_PASARELA) ? 'checked' : '';
$metodo_cobro_2_chk = ($pagadito != null && $pagadito->metodo_cobro == CobroPagadito::CARGO_PASARELA_PACIENTE) ? 'checked' : '';

$cobroCita = $model->cobroPagadito;
?>

<!-- Begin::Modal cobro de cita mediante pagadito o link -->
<?php if( ( $medioPagoCita == Pagadito::MEDIO_PAGO_PAGADITO || $medioPagoCita == Pagadito::MEDIO_PAGO_LINK ) && $cobroCita == NULL ):?>
<div id="cobrar-cita-modal" class="modal fade" data-idcita="<?=$model->id?>">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div id="cobrar-cita-modal-cont" class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Cobro de Cita</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Detalle</p>
                <ul>
                    <?php $costo=0;foreach ($procedimiento_cita_array as $model_cli_pro):?>
                        <li><?=$model_cli_pro->procedimiento->nombre?></li>
                    <?php endforeach;?>
                </ul>
                <div class="row">
                    <div class="col-md-6 mt-4">
                        <p>Monto por Servicio</p>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><?= $simboloMoneda ?></span>
                            </div>
                            <input type="text" class="form-control" id="costo" value="<?=$model->costo?>">
                        </div>
                    </div>
                </div>
                <form class="form">
                    <div class="form-group mt-5 to-hide">
                        <label><strong>¿Cobro de IVA?</strong><span class="text-muted" style="font-size: 11px;"> Valor de IVA agregado al monto del servicio.</span></label>
                        <div class="radio-inline">
                            <label class="radio p-1">
                                <input type="radio" name="iva" value="<?=CobroPagadito::IVA_INCLUIDO?>" <?=$opt_iva_1_chk == 'checked' ? $opt_iva_1_chk : 'checked' ?>>
                                <span></span>IVA Incluido en Monto
                            </label>
                            <label class="radio p-1">
                                <input type="radio" name="iva" value="<?=CobroPagadito::AGREGAR_IVA?>" <?=$opt_iva_2_chk?>>
                                <span></span>Agregar IVA
                            </label>
                            <label class="radio p-1">
                                <input type="radio" name="iva" value="<?=CobroPagadito::SIN_IVA?>" <?=$opt_iva_3_chk?>>
                                <span></span>No Cobrar IVA
                            </label>
                        </div>
                    </div>
                    <?php if( $medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO || $boolCobroPasarela ): ?>
                    <div class="form-group mt-4 to-hide">
                        <label><strong>¿Cargo de Pasarela de Pago?</strong><span class="text-muted" style="font-size: 11px;"> (Pertenece a la Pasarela y no a Olivia)</span></label>
                        <div class="radio-inline">
                            <label class="radio p-1">
                                <input type="radio" name="cargo-pasarela" value="<?=CobroPagadito::ASUMIR_CARGO_PASARELA?>" <?=$metodo_cobro_1_chk == 'checked' ? $metodo_cobro_1_chk : 'checked'?>>
                                <span></span>Asumir Cobro
                            </label>
                            <label class="radio p-1">
                                <input type="radio" name="cargo-pasarela" value="<?=CobroPagadito::CARGO_PASARELA_PACIENTE?>" <?=$metodo_cobro_2_chk?>>
                                <span></span>Cobrar al Paciente
                            </label>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="form-group mt-4 to-hide">
                        <label><strong>Medio para enviar el link de pago:</strong></label>
                        <div class="kt-checkbox-inline">
                            <label class="kt-checkbox">
                                <input type="checkbox" <?=$paciente->celular == null ? 'disabled' : 'checked'?> id="sms">SMS<?=$paciente->celular == null ? ' <small>(Deshabilitado por falta de número de celular)</small>' : ''?> 
                                <span></span>
                            </label>
                        </div>
                        <div class="kt-checkbox-inline">
                            <label class="kt-checkbox">
                                <input type="checkbox" <?=$paciente->email == null ? 'disabled' : 'checked'?> id="correo">Correo<?=$paciente->email == null ? ' <small>(Deshabilitado por falta de correo)</small>' : ''?>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="form-group mt-4" id="url-fields" style="display:none;">
                        <label>URL de cobro</label>
                        <div class="input-group">
                            <input id="url-cobro" type="text" class="form-control" readonly="">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="button" id="copiar-btn" >Copiar Link</button>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-10 text-right">
                            <h6>
                                IVA:<br>
                                Cargo Plataforma:<br>
                                Monto Total:
                            </h6>
                        </div>
                        <div class="col-md-2 text-left">
                            <h6>
                                <?= $simboloMoneda ?><span id="total-iva"></span><br>
                                <?= $simboloMoneda ?><span id="cargo-plataforma"></span><br>
                                <?= $simboloMoneda ?><span id="monto-total"></span>
                            </h6>
                        </div>
                    </div>
                </form>    
            </div>
            <div class="modal-footer" >
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button data-id="<?=$model->id?>" type="button" class="btn btn-primary" id="efectuar-cobro">Efectuar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php endif; ?>
<!-- End::Modal cobro de cita mediante pagadito-->

<?php if(($medioPagoCita == Pagadito::MEDIO_PAGO_PAGADITO || $medioPagoCita == Pagadito::MEDIO_PAGO_LINK ) && $cobroCita != NULL):?>
<div id="detalle-cobro-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div id="detalle-cobro-modal-cont" class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Detalle de Cobro</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Detalle</p>
                <ul>
                    <?php $costo=0;foreach ($procedimiento_cita_array as $model_cli_pro):?>
                        <li><?=$model_cli_pro->procedimiento->nombre?></li>
                    <?php endforeach;?>
                </ul>
                <form class="form">
                    <?php if($cobroCita->token != null):?>
                    <div class="form-group mt-4" id="url-cobro">
                        <label>URL de cobro</label>
                        <div class="input-group">
                            <input id="url-cobro-detalle" type="text" class="form-control" value="<?=$cobroCita->urlCobro?>" readonly="">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="button" id="copiar-btn-detalle" >Copiar Link</button>
                            </div>
                        </div>
                    </div>
                    <?php endif;?>
                    <?php if($pagadito->tipo == Pagadito::PAGADITO ): ?>
                    <div class="form-group mt-4">
                        <label>Estado de cobro</label>
                        <div class="input-group">
                            <?=$cobroCita->textoEstado?>
                        </div>
                    </div>
                    <?php endif;?>
                    <?php if($pagadito->tipo == Pagadito::LINK_EXTERNO && $cobroCita->estado != CobroPagadito::LINK_COMPLETADO): ?>
                    <div class="form-group" id="estados-cobro-link">
                        <label>Estado de cobro:</label>
                        <?= Html::dropDownList('estado', $cobroCita->estado, CobroPagadito::$estados_link,['id'=>'estados-link-externo', 'class'=>'form-control mb-4', 'data-id' => $cobroCita->id] );?>
                    </div>
                    <?php endif;?>
                    <div class="form-group mt-4" id="fecha-cobro-group" style="<?=($cobroCita->fecha_pago != null) ? 'display: block;' : 'display: none;'?>">
                        <p>Fecha de pago</p>
                        <ul>
                            <li id="fecha-cobro"><?=date('d/m/Y', strtotime($cobroCita->fecha_pago))?></li>
                        </ul>
                    </div>
                    <div class="row">
                        <div class="col-md-10 text-right">
                            <h6>
                                IVA:<br>
                                Cargo Plataforma:<br>
                                Monto Total:
                            </h6>
                        </div>
                        <div class="col-md-2 text-left">
                            <h6>
                                <span><?= $simboloMoneda.$cobroCita->iva ?></span><br>
                                <span><?= $simboloMoneda.$cobroCita->cargo_pasarela ?></span><br>
                                <span><?= $simboloMoneda.$cobroCita->total_cobrado ?></span>
                            </h6>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer" >
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php endif; ?>
