<?php

use yii\helpers\Html;
use app\assets\MensajeriaAsset;
use app\themes\metronic\assets\BootstrapDatepickerAssets;
use app\customs\SesionUtils;
/* @var $this yii\web\View */
/* @var $searchModel app\models\PlantillaMensajeSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$placeHolder = "Escribe un mensaje. Por ejemplo: Hola {Paciente}, el consultorio estará cerrado la semana que viene por motivos de fuerza mayor.&#10;Estaremos atendiendo nuevamente el lunes que le sigue.Los saluda {Especialista}.&#10;&#10;Los {Paciente} y {Especialista} que se ven el texto superior son etiquetas que serán sustituidas por el nombre del paciente o especialista seleccionado.&#10;Puedes hacer uso de ellas eligiendo las etiquetas disponibles a la derecha.";
$especialista = ucwords($prefijo ).' '. SesionUtils::getLlaveValor('nombre_publico')->valor;
$this->title = 'Mensajería';
$this->params['breadcrumbs'][] = $this->title;
$today = date("Y-m-d");
$endweek = strtotime($today."+ 7 days");
MensajeriaAsset::register($this);
BootstrapDatepickerAssets::register($this);
?>

<div class="plantilla-mensaje-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title">Mensajería</h1>
        </div>
    </div>
    <div class="kt-portlet__body">
        <div class="form-group row">
            <label for="example-text-input" class="col-lg-1 col-form-label">Recipientes</label>
            <div class="col-lg-5">
                <select class="form-control" id="recipientes" name="recipientes[]" multiple="multiple">
                </select>
            </div>
            <div class="col-lg-4">
                <button type="button" id="btn-personalizar" class="btn btn-secondary btn-dark">Seleccionar Varios</button>
            </div>
        </div>
        <div class="form-group row">
            <div class="form-group col-lg-9 col-md-9 col-sm-12">
                <p>*Si los pacientes no cuentan con un correo, el mensaje no será enviado.</p>
                <textarea class="form-control" id="EmailMessage" style="margin-top: 10px;resize: none;" name="EmailMessage" rows="7" cols="60" data-html="true"  placeholder="<?=nl2br($placeHolder)?>"></textarea>
            </div>
            <div class="col-lg-3">
                <div class="kt-section__content" style="margin-top: 10px;">
                    <div class="btn-group-vertical mensajeria-tools" role="group" aria-label="Vertical button group">
                        <label>Escribe con Etiquetas:</label>
                        <button type="button" class="btn btn-secondary" style="margin-bottom: 15px; width: 110px;" value="{paciente}" data-toggle="kt-tooltip" title="" data-placement="right" data-original-title="Ejem. Miguel Quinteros">Paciente</button>
                        <button type="button" class="btn btn-secondary" style="margin-bottom: 15px; width: 110px;" value="{especialista}" data-toggle="kt-tooltip" title="" data-placement="right" data-original-title="<?=$especialista?>.">Especialista</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group">
            <label>Tipo de comunicación</label>
            <div class="kt-checkbox-inline">
                <label class="kt-checkbox">
                    <input id="is-email" type="checkbox" checked="checked" readonly="readonly"> Email
                    <span></span>
                </label>
                <label class="kt-checkbox" style="display:none;">
                    <input id="is-sms" type="checkbox"> SMS
                    <span></span>
                </label>
            </div>
            <br>

            <p style="text-align: right;">
                <?= Html::buttonInput('Enviar', ['id' => 'btn-enviar-mensaje','class' => 'btn btn-primary col-lg-3', 'name' =>'enviar']) ?>
            </p>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="modalPacientes" tabindex="-1" role="dialog" aria-labelledby="modalPacientesLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        
        <h4 class="modal-title" id="modalPacientesLabel">Seleccione una opción</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
        <div class="modal-body container">
            <div class="row-fluid">
                <div class="form-group" id="opt-pacientes">
                    <label class="radio-inline"><input type="radio" value="today" name="optradio" checked> Citas de hoy</label>
                    <label class="radio-inline"><input type="radio" value="week" name="optradio"> Citas de la semana</label>
                    <label class="radio-inline"><input type="radio" value="custom" name="optradio"> Rango de fechas</label> 
                </div>
            </div>
            <div id="fecha-hoy-group" class="row form-inline campos-filtro-pacientes">
                <div class="form-group">
                    <label class="form-label mr-3" for="fecha-hoy">Citas de hoy:</label>
                    <input id="fecha-hoy" type="text" class="form-control" readonly="readonly" value="<?= date('d/m/Y')?>" />
                </div>
            </div>
            <div id="fecha-semana-group" class="row campos-filtro-pacientes">
                <div class="form-group col-sm-6">
                    <label class="form-label" for="fecha-inicio-semana">Siguiente semana</label>
                    <input id="fecha-inicio-semana" type="text" class="form-control bg-silver" readonly="readonly" value="<?= date('d/m/Y')?>" />    
                </div>
                <div class="form-group col-sm-6">
                    <label class="form-label">&nbsp;</label>
                    <input id="fecha-inicio-semana" type="text" class="form-control bg-silver" readonly="readonly" value="<?= date("d/m/Y",$endweek)?>" />
                </div>
            </div>
            <div id="fecha-abierta-group" class="row campos-filtro-pacientes">
                <div class="form-group col-sm-6">
                    <label class="form-label">Fecha personalizada</label>
                    <input id="fecha-inicio" type="text" class="form-control bg-silver" value="<?= date('d/m/Y')?>" />    
                </div>
                <div class="form-group col-sm-6">
                    <label class="form-label">&nbsp;</label>
                    <input id="fecha-fin" type="text" class="form-control bg-silver" value="<?= date("d/m/Y",$endweek)?>" />
                </div>
            </div>
            <div class="row">
                <table class="table table-striped" id="table-pacientes">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>Email</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
        </div>
      <div class="modal-footer">
            <button id="btn-obtener" type="button" class="btn btn-success">Obtener</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button id="btn-ok" type="button" class="btn btn-primary">Agregar</button>        
      </div>
    </div>
  </div>
</div>
