<?php

use yii\helpers\Html;
use app\assets\HorarioAsset;
use app\models\HorarioMedico;
use app\models\Usuario;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $horarios[] app\models\HorarioMedico */

HorarioAsset::register($this);
$this->title = 'Horario de atención del médico';
$this->params['breadcrumbs'][] = $this->title;
$dias = [1 => 'Domingo',2 => 'Lunes', 3 => 'Martes', 4 => 'Miercoles', 5 => 'Jueves', 6 => 'Viernes', 7 => 'Sabado'];
$usuario = Yii::$app->user->identity;
HorarioAsset::register($this);
$i=0;
$c=0;
?>
<div class="horario-medico-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p>
            <a class="btn btn-success my-4 mb-2 btn-md" id="btn_modal_horario"  href="#">Agregar o Editar Horario</a>
        </p>
    </div>
    <div class="kt-portlet__body">
        <div class="col-md-12 col-lg-12 col-xl-4">
            <div class="kt-widget1">
                <ul class="nav nav-tabs  nav-tabs-line nav-tabs-line-success" role="tablist">
                <?php foreach ($clinicas as $clinica) { $i++;?>
                    <li class='nav-item'>
                        <a class='nav-link <?php if( $i ==1 ){ echo "active"; } ?> role-tab-item' data-toggle='tab' href='#kt_tabs<?=$clinica->id?>' id="<?=$clinica->id?>" role='tab'>
                            <i class='la la-building'></i> <?= $clinica->nombre ?>
                        </a>
                    </li>                           
                <?php } ?>
                </ul> 
                <div class="tab-content">
                <?php foreach ($clinicas as $clinica) { $c++;?>
                    <div class='tab-pane  <?php if( $c ==1 ){ echo "active"; } ?>' id='kt_tabs<?=$clinica->id?>' role='tabpanel'>
                        <div class='kt-widget kt-widget--user-profile-3' style='text-shadow: none;'>
                            <?php
                            foreach ($dias as $noDia => $nombreDia){
                                $horarios = $clinica->getHorarios()->where(['dia' => $noDia])->orderBy(['hora_inicio' => SORT_ASC])->all();
                             ?>       
                            <div class='kt-widget1__item'>
                                <div class='kt-widget1__info'>
                                    <h3 class='kt-widget1__title'><?= $nombreDia?></h3>
                                </div>
                                <?php
                                if(sizeof($horarios)==0){
                                    echo "Cerrado"; 
                                }
                                else{
                                ?>
                                <ul>
                                <?php foreach ($horarios as $horario) { ?>
                                    <li class='kt-widget1__number' style='color:#6c7293; margin-left:-100px;'>
                                        <?= substr($horario->hora_inicio, 0, 5)?> - <?=substr($horario->hora_fin, 0, 5)?>
                                    </li>
                                <?php } ?>
                                </ul>
                                <?php } ?>
                            </div>
                            <?php } ?>
                         </div>
                     </div> 
                    <?php } ?> <!--end:: Widgets/Stats2-2 -->
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" role="dialog" aria-hidden="true" id="_horario">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <?php
            $form = ActiveForm::begin([

                'class' => 'kt-form container',
                'method' => 'POST',
            ]);
            ?>
            <div class="modal-header">
                <h4 class="modal-title">Nuevo Horario de Trabajo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <input type="hidden" name="id_clinica" class="" id="id_clinica" value="" >
            <div class="modal-body container" id="modal_body">
               
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>                
                <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
                
            </div>
            <?php ActiveForm::end(); ?>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
