<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\assets\FormaPagoAsset;
use app\customs\StripeUtils;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Tu plan actual';
$this->params['breadcrumbs'][] = $this->title;
$leyendaBoton = $model == null ? 'Agregar' : 'Actualizar';

FormaPagoAsset::register($this);
?>
<style>
    .no-h{
        color: #000 !important;
    }
    .no-h:hover{
        color: #000;
    }
</style>
<div class="forma-pago-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p>
            <?= $model != null ? Html::a('<i class="fas fa-file-invoice-dollar"></i>Ver facturas',['forma-pago/facturas'], ['class'=>'btn btn-dark mt-2']) : ''?>
        </p>
    </div>
    
    <div class="kt-portlet__body">
    
        <div class="row">
            <div class="col-xl-12">
                <!--begin:: Widgets/Applications/User/Profile3-->
                <div class="kt-portlet kt-portlet--height-fluid">
                    <div class="kt-portlet__body">
                        <div class="kt-widget kt-widget--user-profile-3">
                            <div class="kt-widget__top">
                                <div class="kt-widget__pic kt-widget__pic--danger kt-font-danger kt-font-boldest kt-font-light kt-hidden">
                                    JM
                                </div>
                                <div class="kt-widget__content">
                                    <div class="kt-widget__head">
                                        <a href="javascript:void(0);" class="kt-widget__username no-h">
                                            <h4>
                                                <?= $plan->nombre?><?= $this->render("_icono_stripe",['estado_suscripcion' => $estado_suscripcion])?>
                                            </h4>
                                        </a> 
                                    </div>
                                    <?php if($estado_suscripcion == StripeUtils::ESTADO_SIN_FORMA_PAGO || $estado_suscripcion == StripeUtils::ESTADO_SIN_SUSCRIPCION){ ?>
                                    <p style="color:red;">
                                       Tu plan de prueba ha terminado. Ingresa tu tarjeta en el botón al inferior de la página para seguir usando Olivia y sus beneficios.
                                    </p>
                                    <?php }?>
                                    <?php if($estado_suscripcion == StripeUtils::ESTADO_INCOMPLETA || $estado_suscripcion == StripeUtils::ESTADO_INCOMPLETA_EXPIRADA){ ?>
                                    <p style="color:red;">
                                       Tu plan no está activo debido a que tu fecha de corte ya pasó y no se ha realizado ningún pago. Ingresa tu tarjeta en el botón al inferior de la página para seguir usando Olivia y sus beneficios.
                                    </p>
                                    <?php }?>
                                    <br>
                                    
                                    <div class="kt-widget__info">
                                        <div class="kt-widget__desc">
                                            <?= $plan->descripcionPlan?>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="kt-widget__info">
                                        <div class="kt-widget__desc">
                                            <h5>¿Que incluye?</h5>
                                        </div>
                                    </div>
                                    
                                    <div class="kt-widget__info">
                                        <div class="kt-widget__desc">
                                            <ul>
                                                <li>Recordatorios Automatizados</li>
                                                <li>Agenda Digital</li>
                                                <li>Calendario en la Nube</li>
                                                <li>Historial de Pacientes</li>
                                                <li>Reportes y Métricas</li>
                                                <li>Posibilidad de Recalendarización</li>
                                                <li>Asistentes Ilimitadas</li>
                                                <li>Servicio de Multiclínica</li>
                                            </ul>
                                        </div>
                                    </div>
                                    
                                    <div class="row" style="font-size: 14px;">
                                        <div class="col-lg-8">
                                            <div class="kt-widget__info">
                                                <div class="kt-widget__desc">
                                                    <h4>Estado del plan</h4>
                                                </div>
                                            </div>
                                            <div class="kt-widget__info">
                                                <div class="kt-widget__desc">
                                                    <?= $this->render("_info_estado_suscripcion",['estado_suscripcion' => $estado_suscripcion,'suscripcion' => $suscripcion, 'plan'=>$plan])?><br>
                                                    <?php if($customerSrc != null){?>
                                                    <strong>Citas incluidas:</strong> <?=$usage?> de <?=$planStripe->tiers[0]->up_to?><br> 
                                                    <strong>Citas extra:</strong> <?=$extras?>
                                                    <?php }?>
                                                </div>
                                            </div>
                                        </div>                                        
                                        <div class="col-lg-4 row">
                                            <?php if($model != null){?>
                                            <div class="col-md-6">
                                                <div class="kt-widget__info">
                                                    <div class="kt-widget__desc">
                                                        <h4>Tipo de pago</h4>
                                                    </div>
                                                </div>
                                                <?php if($customerSrc != null) { ?>
                                                <div class="kt-widget__info">
                                                    <div class="kt-widget__desc">
                                                        <span class="kt-widget__title"><?= $customerSrc->brand ?></span><br>
                                                        <span class="kt-widget__value"><span>xxxxxxxx-</span><?= $customerSrc->last4?></span><br>
                                                        <span class="kt-widget__value">Expira: <?= $customerSrc->exp_month?>/<?= $customerSrc->exp_year?></span><br>
                                                    </div>
                                                </div>
						<?php } else { ?>
						<div class="kt-widget__info">
                                                    <div class="kt-widget__desc">
                                                        <p>No cuentas con un tipo de pago</p>
                                                    </div>
                                                </div>
												
                                            <?php } ?>
                                            </div>
                                            <?php }?>
                                            <div class="col-md-6 mt-5">
                                                <form action="<?= Url::to(['forma-pago/create'])?>" method="POST">
                                                    <script
                                                        src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                                                        data-image="<?= Yii::$app->homeUrl."/img/olivia.jpg" ?>"
                                                        data-key="<?= $strPKey ?>"
                                                        data-name="Olivia Health"
                                                        data-panel-label="<?= $leyendaBoton?> forma de pago"
                                                        data-label="<?= $leyendaBoton?> tarjeta"
                                                        data-allow-remember-me=false
                                                        data-locale="auto">
                                                    </script>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <hr style="border: 1px solid #ebedef; width: 100%; margin-top: 50px;">
                                        <div class="col-md-1 mx-auto">
                                            <i class="fa fa-user-lock text-success mt-4 mb-4" style="font-size: 3rem;"></i>
                                        </div>
                                        <div class="col-md-11">
                                            <p>
                                               ¡Tu información bancaria está en buenas manos!<br>
                                               Olivia Health no visualiza ni conoce tus formas de pago en ningún momento.<br> 
                                               Éstas son manejadas directamente por Stripe: una compañía de tecnología estadounidense encargada de recibir los pagos de más de 100,000 empresas en todo el mundo.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php if($model != null){ ?>
                            <!--div class="kt-widget__bottom">

                                <div class="kt-widget__item">
                                    <div class="kt-widget__icon">
                                        <i class="flaticon-confetti"></i>
                                    </div>
                                    <div class="kt-widget__details">
                                        <span class="kt-widget__title">Facturas</span>
                                        <span class="kt-widget__value"><a href="javascript:void(0)" id="detalle-facturas">Listar</a></span>
                                    </div>
                                </div>
                            </div-->
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <!--end:: Widgets/Applications/User/Profile3-->
            </div>
        </div>
        <!--form action="<?= Url::to(['forma-pago/create'])?>" method="POST">
            <script
                src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                data-key="<?= $strPKey ?>"
                data-name="Olivia Health"
                data-panel-label="<?= $leyendaBoton?> forma de pago"
                data-label="<?= $leyendaBoton?> forma de pago"
                data-allow-remember-me=false
                data-locale="auto">
            </script>
        </form-->
        <!--p>
            <?= Html::a('Cambiar plan',['forma-pago/index'], ['class'=>'btn btn-primary'])?>
        </p-->    
    </div>
</div>


<!--div id="modal-facturas" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Detalle de facturas</h4>
        <button type="button" class="close" data-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
      </div>
    </div>

  </div>
</div-->



