<?php
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\FormaPago */
/* @var $invoices Stripe\Invoice[] */
$this->title = 'Facturas';
$this->params['breadcrumbs'][] = $this->title;
$invoices = $response->data;
?>
<div class="cita-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p>
            <?=Html::a('Plan actual',['forma-pago/index'], ['class'=>'btn btn-dark mt-2'])?>
        </p>    
    </div>
    <div class="kt-portlet__body">
        <div class="table-responsive">
            <div id="w1" class="grid-view">    
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Periodo</th>
                            <th>N° Referencia</th>
                            <th>Estado</th>
                            <th>Monto</th>
                            <th>Detalles</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($invoices as $invoice){ ?>
                        <tr>
                            <td><?= date('d/m/Y',$invoice->period_start) ?> - <?= date('d/m/Y',$invoice->period_end) ?></td>                            
                            <td><?= $invoice->number ?></td>
                            <td><?= $invoice->status ?></td>
                            <td><?= number_format(($invoice->total)/100, 2, '.', '')?></td>
                            <td><a target="_blank" href="<?= $invoice->hosted_invoice_url?>"><i class="fas fa-eye" style="font-size: 2rem;"></i></a></td>
                        </tr>    
                    <?php } ?>
                    <tbody>        
                </table>
            </div>        
        </div>    
    </div>    
</div>    
    
    
